/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.parser.OpenAPIResolver;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.extensions.SwaggerParserExtension;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.util.ResolverFully;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.mockserver.cache.LRUCache;
import org.mockserver.logging.MockServerLogger;

public class OpenAPIParser {
    private static final LRUCache<String, OpenAPI> openAPILRUCache = new LRUCache(new MockServerLogger(), 250, TimeUnit.MINUTES.toMillis(10L));
    public static final String OPEN_API_LOAD_ERROR = "Unable to load API spec";

    public static OpenAPI buildOpenAPI(String specUrlOrPayload) {
        OpenAPI openAPI = openAPILRUCache.get(specUrlOrPayload);
        if (openAPI == null) {
            SwaggerParseResult swaggerParseResult = null;
            List auths = null;
            ParseOptions parseOptions = new ParseOptions();
            parseOptions.setResolve(true);
            parseOptions.setResolveFully(true);
            parseOptions.setResolveCombinators(true);
            parseOptions.setFlatten(true);
            parseOptions.setFlattenComposedSchemas(true);
            ArrayList errorMessage = new ArrayList();
            try {
                if (specUrlOrPayload.endsWith(".json") || specUrlOrPayload.endsWith(".yaml")) {
                    SwaggerParserExtension extension;
                    specUrlOrPayload = specUrlOrPayload.replaceAll("\\\\", "/");
                    List parserExtensions = OpenAPIV3Parser.getExtensions();
                    Iterator iterator = parserExtensions.iterator();
                    while (iterator.hasNext() && (openAPI = (swaggerParseResult = (extension = (SwaggerParserExtension)iterator.next()).readLocation(specUrlOrPayload, auths, parseOptions)).getOpenAPI()) == null) {
                        errorMessage.addAll(swaggerParseResult.getMessages());
                    }
                } else {
                    swaggerParseResult = new OpenAPIV3Parser().readContents(specUrlOrPayload, auths, parseOptions);
                    openAPI = swaggerParseResult.getOpenAPI();
                    if (openAPI == null) {
                        errorMessage.addAll(swaggerParseResult.getMessages());
                    }
                }
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException(OPEN_API_LOAD_ERROR + (StringUtils.isNotBlank((CharSequence)throwable.getMessage()) ? ", " + throwable.getMessage() : ""), throwable);
            }
            if (openAPI != null) {
                try {
                    openAPI = OpenAPIParser.resolve(openAPI, auths, specUrlOrPayload);
                }
                catch (Throwable throwable) {
                    throw new IllegalArgumentException(OPEN_API_LOAD_ERROR + (StringUtils.isNotBlank((CharSequence)throwable.getMessage()) ? ", " + throwable.getMessage() : ""), throwable);
                }
            } else {
                if (swaggerParseResult != null) {
                    String message = errorMessage.stream().filter(Objects::nonNull).collect(Collectors.joining(" and ")).trim();
                    throw new IllegalArgumentException(OPEN_API_LOAD_ERROR + (StringUtils.isNotBlank((CharSequence)message) ? ", " + message : ""));
                }
                throw new IllegalArgumentException(OPEN_API_LOAD_ERROR);
            }
            OpenAPIParser.addMissingOperationIds(openAPI);
            openAPILRUCache.put(specUrlOrPayload, openAPI);
        }
        return openAPI;
    }

    private static OpenAPI resolve(OpenAPI openAPI, List<AuthorizationValue> auths, String specUrlOrPayload) {
        if (openAPI != null) {
            OpenAPIResolver.Settings settings = new OpenAPIResolver.Settings();
            settings.addParametersToEachOperation(true);
            openAPI = new OpenAPIResolver(openAPI, auths, specUrlOrPayload, settings).resolve();
            new ResolverFully().resolveFully(openAPI);
        }
        return openAPI;
    }

    private static void addMissingOperationIds(OpenAPI openAPI) {
        openAPI.getPaths().forEach((path, pathItem) -> OpenAPIParser.mapOperations(pathItem).forEach(stringOperationPair -> {
            if (StringUtils.isBlank((CharSequence)((Operation)stringOperationPair.getRight()).getOperationId())) {
                ((Operation)stringOperationPair.getRight()).setOperationId((String)stringOperationPair.getLeft() + " " + path);
            }
        }));
    }

    public static List<Pair<String, Operation>> mapOperations(PathItem pathItem) {
        ArrayList<Pair<String, Operation>> allOperations = new ArrayList<Pair<String, Operation>>();
        if (pathItem.getGet() != null) {
            allOperations.add((Pair<String, Operation>)new ImmutablePair((Object)"GET", (Object)pathItem.getGet()));
        }
        if (pathItem.getPut() != null) {
            allOperations.add((Pair<String, Operation>)new ImmutablePair((Object)"PUT", (Object)pathItem.getPut()));
        }
        if (pathItem.getPost() != null) {
            allOperations.add((Pair<String, Operation>)new ImmutablePair((Object)"POST", (Object)pathItem.getPost()));
        }
        if (pathItem.getPatch() != null) {
            allOperations.add((Pair<String, Operation>)new ImmutablePair((Object)"PATCH", (Object)pathItem.getPatch()));
        }
        if (pathItem.getDelete() != null) {
            allOperations.add((Pair<String, Operation>)new ImmutablePair((Object)"DELETE", (Object)pathItem.getDelete()));
        }
        if (pathItem.getHead() != null) {
            allOperations.add((Pair<String, Operation>)new ImmutablePair((Object)"HEAD", (Object)pathItem.getHead()));
        }
        if (pathItem.getOptions() != null) {
            allOperations.add((Pair<String, Operation>)new ImmutablePair((Object)"OPTIONS", (Object)pathItem.getOptions()));
        }
        if (pathItem.getTrace() != null) {
            allOperations.add((Pair<String, Operation>)new ImmutablePair((Object)"TRACE", (Object)pathItem.getTrace()));
        }
        return allOperations;
    }
}

