/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import org.mockserver.model.Body;
import org.mockserver.model.Cookies;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.Not;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameters;
import org.mockserver.serialization.model.BodyDTO;
import org.mockserver.serialization.model.DTO;
import org.mockserver.serialization.model.RequestDefinitionDTO;
import org.mockserver.serialization.model.SocketAddressDTO;

public class HttpRequestDTO
extends RequestDefinitionDTO
implements DTO<HttpRequest> {
    private NottableString method = NottableString.string("");
    private NottableString path = NottableString.string("");
    private Parameters pathParameters;
    private Parameters queryStringParameters;
    private BodyDTO body;
    private Cookies cookies;
    private Headers headers;
    private Boolean keepAlive;
    private Boolean secure;
    private SocketAddressDTO socketAddress;

    public HttpRequestDTO() {
        super(null);
    }

    public HttpRequestDTO(HttpRequest httpRequest) {
        super(httpRequest != null ? httpRequest.getNot() : null);
        if (httpRequest != null) {
            this.method = httpRequest.getMethod();
            this.path = httpRequest.getPath();
            this.headers = httpRequest.getHeaders();
            this.cookies = httpRequest.getCookies();
            this.pathParameters = httpRequest.getPathParameters();
            this.queryStringParameters = httpRequest.getQueryStringParameters();
            this.body = BodyDTO.createDTO(httpRequest.getBody());
            this.keepAlive = httpRequest.isKeepAlive();
            this.secure = httpRequest.isSecure();
            if (httpRequest.getSocketAddress() != null) {
                this.socketAddress = new SocketAddressDTO(httpRequest.getSocketAddress());
            }
        }
    }

    @Override
    public HttpRequest buildObject() {
        return (HttpRequest)new HttpRequest().withMethod(this.method).withPath(this.path).withPathParameters(this.pathParameters).withQueryStringParameters(this.queryStringParameters).withBody(this.body != null ? (Body)Not.not(this.body.buildObject(), this.body.getNot()) : null).withHeaders(this.headers).withCookies(this.cookies).withSecure(this.secure).withKeepAlive(this.keepAlive).withSocketAddress(this.socketAddress != null ? this.socketAddress.buildObject() : null).withNot(this.getNot());
    }

    public NottableString getMethod() {
        return this.method;
    }

    public HttpRequestDTO setMethod(NottableString method) {
        this.method = method;
        return this;
    }

    public NottableString getPath() {
        return this.path;
    }

    public HttpRequestDTO setPath(NottableString path) {
        this.path = path;
        return this;
    }

    public Parameters getPathParameters() {
        return this.pathParameters;
    }

    public HttpRequestDTO setPathParameters(Parameters pathParameters) {
        this.pathParameters = pathParameters;
        return this;
    }

    public Parameters getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public HttpRequestDTO setQueryStringParameters(Parameters queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
        return this;
    }

    public BodyDTO getBody() {
        return this.body;
    }

    public HttpRequestDTO setBody(BodyDTO body) {
        this.body = body;
        return this;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public HttpRequestDTO setHeaders(Headers headers) {
        this.headers = headers;
        return this;
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public HttpRequestDTO setCookies(Cookies cookies) {
        this.cookies = cookies;
        return this;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public HttpRequestDTO setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public HttpRequestDTO setSecure(Boolean secure) {
        this.secure = secure;
        return this;
    }

    public SocketAddressDTO getSocketAddress() {
        return this.socketAddress;
    }

    public HttpRequestDTO setSocketAddress(SocketAddressDTO socketAddress) {
        this.socketAddress = socketAddress;
        return this;
    }
}

