/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import java.util.ArrayList;
import java.util.List;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.model.OpenAPIDefinition;
import org.mockserver.model.RequestDefinition;
import org.mockserver.serialization.model.DTO;
import org.mockserver.serialization.model.HttpRequestDTO;
import org.mockserver.serialization.model.OpenAPIDefinitionDTO;
import org.mockserver.serialization.model.RequestDefinitionDTO;
import org.mockserver.verify.VerificationSequence;

public class VerificationSequenceDTO
extends ObjectWithReflectiveEqualsHashCodeToString
implements DTO<VerificationSequence> {
    private List<RequestDefinitionDTO> httpRequests = new ArrayList<RequestDefinitionDTO>();

    public VerificationSequenceDTO(VerificationSequence verification) {
        if (verification != null) {
            for (RequestDefinition httpRequest : verification.getHttpRequests()) {
                if (httpRequest instanceof HttpRequest) {
                    this.httpRequests.add(new HttpRequestDTO((HttpRequest)httpRequest));
                    continue;
                }
                if (!(httpRequest instanceof OpenAPIDefinition)) continue;
                this.httpRequests.add(new OpenAPIDefinitionDTO((OpenAPIDefinition)httpRequest));
            }
        }
    }

    public VerificationSequenceDTO() {
    }

    @Override
    public VerificationSequence buildObject() {
        ArrayList<RequestDefinition> httpRequests = new ArrayList<RequestDefinition>();
        for (RequestDefinitionDTO httpRequest : this.httpRequests) {
            httpRequests.add(httpRequest.buildObject());
        }
        return new VerificationSequence().withRequests(httpRequests);
    }

    public List<RequestDefinitionDTO> getHttpRequests() {
        return this.httpRequests;
    }

    public VerificationSequenceDTO setHttpRequests(List<RequestDefinitionDTO> httpRequests) {
        this.httpRequests = httpRequests;
        return this;
    }
}

