/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.server.initialize;

import java.lang.reflect.Constructor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.file.FileReader;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.RequestMatchers;
import org.mockserver.mock.listeners.MockServerMatcherNotifier;
import org.mockserver.serialization.ExpectationSerializer;
import org.mockserver.server.initialize.ExpectationInitializer;
import org.slf4j.event.Level;

public class ExpectationInitializerLoader {
    private final ExpectationSerializer expectationSerializer;
    private final MockServerLogger mockServerLogger;
    private final RequestMatchers requestMatchers;

    public ExpectationInitializerLoader(MockServerLogger mockServerLogger, RequestMatchers requestMatchers) {
        this.expectationSerializer = new ExpectationSerializer(mockServerLogger);
        this.mockServerLogger = mockServerLogger;
        this.requestMatchers = requestMatchers;
        this.addExpectationsFromInitializer();
    }

    private void addExpectationsFromInitializer() {
        for (Expectation expectation : this.loadExpectations()) {
            this.requestMatchers.add(expectation, MockServerMatcherNotifier.Cause.INITIALISER);
        }
    }

    private Expectation[] retrieveExpectationsFromInitializerClass() {
        try {
            String initializationClass = ConfigurationProperties.initializationClass();
            if (StringUtils.isNotBlank((CharSequence)initializationClass)) {
                Constructor<?> initializerClassConstructor;
                Object expectationInitializer;
                ClassLoader contextClassLoader;
                if (MockServerLogger.isEnabled(Level.INFO)) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.INFO).setMessageFormat("loading class initialization file:{}").setArguments(initializationClass));
                }
                if ((contextClassLoader = ExpectationInitializerLoader.class.getClassLoader()) != null && StringUtils.isNotBlank((CharSequence)initializationClass) && (expectationInitializer = (initializerClassConstructor = contextClassLoader.loadClass(initializationClass).getDeclaredConstructor(new Class[0])).newInstance(new Object[0])) instanceof ExpectationInitializer) {
                    return ((ExpectationInitializer)expectationInitializer).initializeExpectations();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new Expectation[0];
    }

    private Expectation[] retrieveExpectationsFromJson() {
        block6: {
            String initializationJsonPath = ConfigurationProperties.initializationJsonPath();
            if (StringUtils.isNotBlank((CharSequence)initializationJsonPath)) {
                if (MockServerLogger.isEnabled(Level.INFO)) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.INFO).setMessageFormat("loading JSON initialization file:{}").setArguments(initializationJsonPath));
                }
                try {
                    String jsonExpectations = FileReader.readFileFromClassPathOrPath(initializationJsonPath);
                    if (MockServerLogger.isEnabled(Level.DEBUG)) {
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.DEBUG).setMessageFormat("loaded JSON initialization file:{}content:{}").setArguments(initializationJsonPath, StringUtils.abbreviate((String)jsonExpectations, (int)1000)));
                    }
                    if (StringUtils.isNotBlank((CharSequence)jsonExpectations)) {
                        return this.expectationSerializer.deserializeArray(jsonExpectations, true);
                    }
                    return new Expectation[0];
                }
                catch (Throwable throwable) {
                    if (!MockServerLogger.isEnabled(Level.WARN)) break block6;
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.WARN).setMessageFormat("exception while loading JSON initialization file, ignoring file").setThrowable(throwable));
                }
            }
        }
        return new Expectation[0];
    }

    public Expectation[] loadExpectations() {
        Object[] expectationsFromInitializerClass = this.retrieveExpectationsFromInitializerClass();
        Object[] expectationsFromJson = this.retrieveExpectationsFromJson();
        return (Expectation[])ArrayUtils.addAll((Object[])expectationsFromInitializerClass, (Object[])expectationsFromJson);
    }
}

