/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.metrics;

import io.prometheus.client.Gauge;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.mockserver.configuration.Configuration;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.metrics.BuildInfoCollector;
import org.mockserver.model.Action;

public class Metrics {
    private static final AtomicReference<Boolean> additionalMetricsRegistered = new AtomicReference<Boolean>(false);
    private static final Map<Name, Gauge> metrics = new ConcurrentHashMap<Name, Gauge>();
    private final Boolean metricsEnabled;

    public Metrics(Configuration configuration) {
        this.metricsEnabled = configuration.metricsEnabled();
        if (this.metricsEnabled.booleanValue() && additionalMetricsRegistered.compareAndSet(false, true)) {
            new BuildInfoCollector().register();
            Arrays.stream(Name.values()).forEach(Metrics::getOrCreate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Gauge getOrCreate(Name name) {
        Name name2 = name;
        synchronized (name2) {
            Gauge gauge = metrics.get((Object)name);
            if (gauge == null) {
                try {
                    gauge = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name(name.name().toLowerCase())).help(name.description)).register();
                    metrics.put(name, gauge);
                }
                catch (Throwable throwable) {
                    new MockServerLogger().logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setMessageFormat("exception:{} creating metric:{}").setArguments(throwable.getMessage(), name.name()).setThrowable(throwable));
                }
            }
            return gauge;
        }
    }

    public static void clear() {
        metrics.forEach((name, gauge) -> gauge.set(0.0));
    }

    public static void clear(Name name) {
        Metrics.getOrCreate(name).set(0.0);
    }

    public void set(Name name, Integer value) {
        if (this.metricsEnabled.booleanValue()) {
            Metrics.getOrCreate(name).set((double)value.intValue());
        }
    }

    public static Integer get(Name name) {
        return (int)Metrics.getOrCreate(name).get();
    }

    public void increment(Name name) {
        if (this.metricsEnabled.booleanValue()) {
            Metrics.getOrCreate(name).inc();
        }
    }

    public void increment(Action.Type type) {
        if (this.metricsEnabled.booleanValue()) {
            this.increment(Name.valueOf(type.name() + "_ACTIONS_COUNT"));
        }
    }

    public void decrement(Name name) {
        if (this.metricsEnabled.booleanValue()) {
            Metrics.getOrCreate(name).dec();
        }
    }

    public void decrement(Action.Type type) {
        if (this.metricsEnabled.booleanValue()) {
            this.decrement(Name.valueOf(type.name() + "_ACTIONS_COUNT"));
        }
    }

    public static void clearRequestAndExpectationMetrics() {
        Metrics.clear(Name.REQUESTS_RECEIVED_COUNT);
        Metrics.clear(Name.EXPECTATIONS_NOT_MATCHED_COUNT);
        Metrics.clear(Name.RESPONSE_EXPECTATIONS_MATCHED_COUNT);
    }

    public static void clearActionMetrics() {
        Metrics.clear(Name.FORWARD_ACTIONS_COUNT);
        Metrics.clear(Name.FORWARD_TEMPLATE_ACTIONS_COUNT);
        Metrics.clear(Name.FORWARD_CLASS_CALLBACK_ACTIONS_COUNT);
        Metrics.clear(Name.FORWARD_OBJECT_CALLBACK_ACTIONS_COUNT);
        Metrics.clear(Name.FORWARD_REPLACE_ACTIONS_COUNT);
        Metrics.clear(Name.RESPONSE_ACTIONS_COUNT);
        Metrics.clear(Name.RESPONSE_TEMPLATE_ACTIONS_COUNT);
        Metrics.clear(Name.RESPONSE_CLASS_CALLBACK_ACTIONS_COUNT);
        Metrics.clear(Name.RESPONSE_OBJECT_CALLBACK_ACTIONS_COUNT);
        Metrics.clear(Name.ERROR_ACTIONS_COUNT);
    }

    public static void clearWebSocketMetrics() {
        Metrics.clear(Name.WEBSOCKET_CALLBACK_CLIENTS_COUNT);
        Metrics.clear(Name.WEBSOCKET_CALLBACK_RESPONSE_HANDLERS_COUNT);
        Metrics.clear(Name.WEBSOCKET_CALLBACK_FORWARD_HANDLERS_COUNT);
    }

    public static enum Name {
        REQUESTS_RECEIVED_COUNT("Expectation not matched count"),
        EXPECTATIONS_NOT_MATCHED_COUNT("Expectation not matched count"),
        RESPONSE_EXPECTATIONS_MATCHED_COUNT("Response expectation matched count"),
        FORWARD_EXPECTATIONS_MATCHED_COUNT("Forward expectation matched count"),
        FORWARD_ACTIONS_COUNT("Action forward count"),
        FORWARD_TEMPLATE_ACTIONS_COUNT("Action forward template count"),
        FORWARD_CLASS_CALLBACK_ACTIONS_COUNT("Action forward class callback count"),
        FORWARD_OBJECT_CALLBACK_ACTIONS_COUNT("Action forward object callback count"),
        FORWARD_REPLACE_ACTIONS_COUNT("Action forward replace count"),
        RESPONSE_ACTIONS_COUNT("Action response count"),
        RESPONSE_TEMPLATE_ACTIONS_COUNT("Action response template count"),
        RESPONSE_CLASS_CALLBACK_ACTIONS_COUNT("Action response class callback count"),
        RESPONSE_OBJECT_CALLBACK_ACTIONS_COUNT("Action response object callback count"),
        ERROR_ACTIONS_COUNT("Action error count"),
        WEBSOCKET_CALLBACK_CLIENTS_COUNT("Websocket callback client count"),
        WEBSOCKET_CALLBACK_RESPONSE_HANDLERS_COUNT("Websocket callback response handler count"),
        WEBSOCKET_CALLBACK_FORWARD_HANDLERS_COUNT("Websocket callback forward handler count");

        public final String description;

        private Name(String description) {
            this.description = description;
        }
    }
}

