/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.JsonBody;
import org.mockserver.model.JsonPathBody;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.RegexBody;
import org.mockserver.model.StringBody;
import org.mockserver.model.XPathBody;
import org.mockserver.model.XmlBody;
import org.mockserver.model.XmlSchemaBody;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.model.BinaryBodyDTO;
import org.mockserver.serialization.model.DTO;
import org.mockserver.serialization.model.JsonBodyDTO;
import org.mockserver.serialization.model.JsonPathBodyDTO;
import org.mockserver.serialization.model.JsonSchemaBodyDTO;
import org.mockserver.serialization.model.NotDTO;
import org.mockserver.serialization.model.ParameterBodyDTO;
import org.mockserver.serialization.model.RegexBodyDTO;
import org.mockserver.serialization.model.StringBodyDTO;
import org.mockserver.serialization.model.XPathBodyDTO;
import org.mockserver.serialization.model.XmlBodyDTO;
import org.mockserver.serialization.model.XmlSchemaBodyDTO;
import org.slf4j.event.Level;

public abstract class BodyDTO
extends NotDTO
implements DTO<Body<?>> {
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger(BodyDTO.class);
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.createObjectMapper();
    private final Body.Type type;
    private Boolean optional;

    public BodyDTO(Body.Type type, Boolean not) {
        super(not);
        this.type = type;
    }

    public static BodyDTO createDTO(Body<?> body) {
        BodyDTO result = null;
        if (body instanceof BinaryBody) {
            BinaryBody binaryBody = (BinaryBody)body;
            result = new BinaryBodyDTO(binaryBody, binaryBody.getNot());
        } else if (body instanceof JsonBody) {
            JsonBody jsonBody = (JsonBody)body;
            result = new JsonBodyDTO(jsonBody, jsonBody.getNot());
        } else if (body instanceof JsonSchemaBody) {
            JsonSchemaBody jsonSchemaBody = (JsonSchemaBody)body;
            result = new JsonSchemaBodyDTO(jsonSchemaBody, jsonSchemaBody.getNot());
        } else if (body instanceof JsonPathBody) {
            JsonPathBody jsonPathBody = (JsonPathBody)body;
            result = new JsonPathBodyDTO(jsonPathBody, jsonPathBody.getNot());
        } else if (body instanceof ParameterBody) {
            ParameterBody parameterBody = (ParameterBody)body;
            result = new ParameterBodyDTO(parameterBody, parameterBody.getNot());
        } else if (body instanceof RegexBody) {
            RegexBody regexBody = (RegexBody)body;
            result = new RegexBodyDTO(regexBody, regexBody.getNot());
        } else if (body instanceof StringBody) {
            StringBody stringBody = (StringBody)body;
            result = new StringBodyDTO(stringBody, stringBody.getNot());
        } else if (body instanceof XmlBody) {
            XmlBody xmlBody = (XmlBody)body;
            result = new XmlBodyDTO(xmlBody, xmlBody.getNot());
        } else if (body instanceof XmlSchemaBody) {
            XmlSchemaBody xmlSchemaBody = (XmlSchemaBody)body;
            result = new XmlSchemaBodyDTO(xmlSchemaBody, xmlSchemaBody.getNot());
        } else if (body instanceof XPathBody) {
            XPathBody xPathBody = (XPathBody)body;
            result = new XPathBodyDTO(xPathBody, xPathBody.getNot());
        }
        if (result != null) {
            result.withOptional(body.getOptional());
        }
        return result;
    }

    public static String toString(BodyDTO body) {
        if (body instanceof BinaryBodyDTO) {
            return Base64.encodeBase64String((byte[])((BinaryBodyDTO)body).getBase64Bytes());
        }
        if (body instanceof JsonBodyDTO) {
            return ((JsonBodyDTO)body).getJson();
        }
        if (body instanceof JsonSchemaBodyDTO) {
            return ((JsonSchemaBodyDTO)body).getJson();
        }
        if (body instanceof JsonPathBodyDTO) {
            return ((JsonPathBodyDTO)body).getJsonPath();
        }
        if (body instanceof ParameterBodyDTO) {
            try {
                return OBJECT_MAPPER.writeValueAsString((Object)((ParameterBodyDTO)body).getParameters().getMultimap().asMap());
            }
            catch (Throwable throwable) {
                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("serialising parameter body into json string for javascript template " + (StringUtils.isNotBlank((CharSequence)throwable.getMessage()) ? " " + throwable.getMessage() : "")).setThrowable(throwable));
                return "";
            }
        }
        if (body instanceof RegexBodyDTO) {
            return ((RegexBodyDTO)body).getRegex();
        }
        if (body instanceof StringBodyDTO) {
            return ((StringBodyDTO)body).getString();
        }
        if (body instanceof XmlBodyDTO) {
            return ((XmlBodyDTO)body).getXml();
        }
        if (body instanceof XmlSchemaBodyDTO) {
            return ((XmlSchemaBodyDTO)body).getXml();
        }
        if (body instanceof XPathBodyDTO) {
            return ((XPathBodyDTO)body).getXPath();
        }
        return "";
    }

    public Body.Type getType() {
        return this.type;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public BodyDTO withOptional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Override
    public abstract Body<?> buildObject();
}

