/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty.websocket;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.mockserver.client.netty.websocket.WebSocketClientHandler;
import org.mockserver.client.netty.websocket.WebSocketException;
import org.mockserver.client.serialization.WebSocketMessageSerializer;
import org.mockserver.client.serialization.model.WebSocketClientIdDTO;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.ExpectationForwardCallback;
import org.mockserver.mock.action.ExpectationResponseCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class WebSocketClient {
    private Channel channel;
    private EventLoopGroup group = new NioEventLoopGroup();
    private WebSocketMessageSerializer webSocketMessageSerializer = new WebSocketMessageSerializer(new MockServerLogger());
    private SettableFuture<String> registrationFuture = SettableFuture.create();
    private ExpectationResponseCallback expectationResponseCallback;
    private ExpectationForwardCallback expectationForwardCallback;

    public WebSocketClient(InetSocketAddress serverAddress, String contextPath) {
        try {
            final WebSocketClientHandler webSocketClientHandler = new WebSocketClientHandler(serverAddress, contextPath, this);
            this.channel = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(Integer.MAX_VALUE), webSocketClientHandler});
                }
            })).connect((SocketAddress)serverAddress).sync().channel();
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while starting web socket client", e);
        }
    }

    SettableFuture<String> registrationFuture() {
        return this.registrationFuture;
    }

    void receivedTextWebSocketFrame(TextWebSocketFrame textWebSocketFrame) {
        try {
            Object deserializedMessage = this.webSocketMessageSerializer.deserialize(textWebSocketFrame.text());
            if (deserializedMessage instanceof HttpRequest) {
                HttpRequest httpRequest = (HttpRequest)deserializedMessage;
                String webSocketCorrelationId = httpRequest.getFirstHeader("WebSocketCorrelationId");
                if (this.expectationResponseCallback != null) {
                    HttpResponse httpResponse = this.expectationResponseCallback.handle(httpRequest);
                    httpResponse.withHeader("WebSocketCorrelationId", webSocketCorrelationId);
                    this.channel.writeAndFlush((Object)new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(httpResponse)));
                }
                if (this.expectationForwardCallback != null) {
                    HttpRequest forwardedHttpRequest = this.expectationForwardCallback.handle(httpRequest);
                    forwardedHttpRequest.withHeader("WebSocketCorrelationId", webSocketCorrelationId);
                    this.channel.writeAndFlush((Object)new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(forwardedHttpRequest)));
                }
            } else if (!(deserializedMessage instanceof WebSocketClientIdDTO)) {
                throw new WebSocketException("Unsupported web socket message " + deserializedMessage);
            }
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while receiving web socket message", e);
        }
    }

    public void stopClient() {
        try {
            if (this.channel != null) {
                this.channel.closeFuture().sync();
            }
        }
        catch (InterruptedException e) {
            throw new WebSocketException("Exception while closing client", e);
        }
        this.group.shutdownGracefully();
    }

    public WebSocketClient registerExpectationCallback(ExpectationResponseCallback expectationResponseCallback) {
        if (this.expectationForwardCallback != null) {
            throw new IllegalArgumentException("It is not possible to set response callback once a forward callback has been set");
        }
        this.expectationResponseCallback = expectationResponseCallback;
        return this;
    }

    public WebSocketClient registerExpectationCallback(ExpectationForwardCallback expectationForwardCallback) {
        if (this.expectationResponseCallback != null) {
            throw new IllegalArgumentException("It is not possible to set forward callback once a response callback has been set");
        }
        this.expectationForwardCallback = expectationForwardCallback;
        return this;
    }

    public String clientId() {
        try {
            return (String)this.registrationFuture.get();
        }
        catch (Exception e) {
            if (e.getCause() instanceof WebSocketException && e.getCause().getMessage().contains("ExpectationResponseCallback and ExpectationForwardCallback is not supported")) {
                throw new WebSocketException(e.getCause().getMessage());
            }
            throw new WebSocketException("Unable to retrieve client registration id", e);
        }
    }
}

