/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.client.serialization.Serializer;
import org.mockserver.client.serialization.model.VerificationDTO;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.validator.jsonschema.JsonSchemaVerificationValidator;
import org.mockserver.verify.Verification;

public class VerificationSerializer
implements Serializer<Verification> {
    private final MockServerLogger mockServerLogger;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private JsonSchemaVerificationValidator verificationValidator;

    public VerificationSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.verificationValidator = new JsonSchemaVerificationValidator(mockServerLogger);
    }

    @Override
    public String serialize(Verification verification) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new VerificationDTO(verification));
        }
        catch (Exception e) {
            this.mockServerLogger.error("Exception while serializing verification to JSON with value " + verification, e);
            throw new RuntimeException("Exception while serializing verification to JSON with value " + verification, e);
        }
    }

    @Override
    public Verification deserialize(String jsonVerification) {
        if (Strings.isNullOrEmpty((String)jsonVerification)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a verification is required but value was \"" + String.valueOf(jsonVerification) + "\"");
        }
        String validationErrors = this.verificationValidator.isValid(jsonVerification);
        if (validationErrors.isEmpty()) {
            Verification verification = null;
            try {
                VerificationDTO verificationDTO = (VerificationDTO)this.objectMapper.readValue(jsonVerification, VerificationDTO.class);
                if (verificationDTO != null) {
                    verification = verificationDTO.buildObject();
                }
            }
            catch (Exception e) {
                this.mockServerLogger.error((HttpRequest)null, (Throwable)e, "exception while parsing {}for Verification", jsonVerification);
                throw new RuntimeException("Exception while parsing [" + jsonVerification + "] for Verification", e);
            }
            return verification;
        }
        this.mockServerLogger.info(MessageLogEntry.LogMessageType.VERIFICATION_FAILED, "validation failed:{}verification:{}", validationErrors, jsonVerification);
        throw new IllegalArgumentException(validationErrors);
    }

    @Override
    public Class<Verification> supportsType() {
        return Verification.class;
    }
}

