/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.java;

import com.google.common.base.Strings;
import org.apache.commons.text.StringEscapeUtils;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.java.DelayToJavaSerializer;
import org.mockserver.client.serialization.java.ToJavaSerializer;
import org.mockserver.model.HttpTemplate;

public class HttpTemplateToJavaSerializer
implements ToJavaSerializer<HttpTemplate> {
    @Override
    public String serialize(int numberOfSpacesToIndent, HttpTemplate httpTemplate) {
        StringBuffer output = new StringBuffer();
        if (httpTemplate != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("template(HttpTemplate.TemplateType." + httpTemplate.getTemplateType().name() + ")");
            if (!Strings.isNullOrEmpty((String)httpTemplate.getTemplate())) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withTemplate(\"").append(StringEscapeUtils.escapeJava((String)httpTemplate.getTemplate())).append("\")");
            }
            if (httpTemplate.getDelay() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withDelay(").append(new DelayToJavaSerializer().serialize(0, httpTemplate.getDelay())).append(")");
            }
        }
        return output.toString();
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(Character.NEW_LINE).append(Strings.padStart((String)"", (int)numberOfSpacesToIndent, (char)' '));
    }
}

