/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.serializers.request;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Strings;
import java.io.IOException;
import org.mockserver.model.HttpRequest;

public class HttpRequestSerializer
extends StdSerializer<HttpRequest> {
    public HttpRequestSerializer() {
        super(HttpRequest.class);
    }

    public void serialize(HttpRequest httpRequest, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (httpRequest.getNot() != null && httpRequest.getNot().booleanValue()) {
            jgen.writeBooleanField("not", httpRequest.getNot().booleanValue());
        }
        if (httpRequest.getMethod() != null && !Strings.isNullOrEmpty((String)httpRequest.getMethod().getValue())) {
            jgen.writeObjectField("method", (Object)httpRequest.getMethod());
        }
        if (httpRequest.getPath() != null && !Strings.isNullOrEmpty((String)httpRequest.getPath().getValue())) {
            jgen.writeObjectField("path", (Object)httpRequest.getPath());
        }
        if (httpRequest.getQueryStringParameterList() != null && !httpRequest.getQueryStringParameterList().isEmpty()) {
            jgen.writeObjectField("queryStringParameters", (Object)httpRequest.getQueryStringParameters());
        }
        if (httpRequest.getHeaderList() != null && !httpRequest.getHeaderList().isEmpty()) {
            jgen.writeObjectField("headers", (Object)httpRequest.getHeaders());
        }
        if (httpRequest.getCookieList() != null && !httpRequest.getCookieList().isEmpty()) {
            jgen.writeObjectField("cookies", (Object)httpRequest.getCookies());
        }
        if (httpRequest.isKeepAlive() != null) {
            jgen.writeBooleanField("keepAlive", httpRequest.isKeepAlive().booleanValue());
        }
        if (httpRequest.isSecure() != null) {
            jgen.writeBooleanField("secure", httpRequest.isSecure().booleanValue());
        }
        if (httpRequest.getBody() != null && !Strings.isNullOrEmpty((String)String.valueOf(httpRequest.getBody().getValue()))) {
            jgen.writeObjectField("body", (Object)httpRequest.getBody());
        }
        jgen.writeEndObject();
    }
}

