/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.filters;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.collections.BoundedConcurrentLinkedQueue;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.ExpectationLogEntry;
import org.mockserver.log.model.ExpectationMatchLogEntry;
import org.mockserver.log.model.LogEntry;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.log.model.RequestLogEntry;
import org.mockserver.log.model.RequestResponseLogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.ui.MockServerEventLogNotifier;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;

public class MockServerEventLog
extends MockServerEventLogNotifier {
    private static final List<Class<? extends LogEntry>> MESSAGE_LOG_TYPES = Collections.singletonList(MessageLogEntry.class);
    private static final List<Class<? extends LogEntry>> REQUEST_LOG_TYPES = Arrays.asList(RequestLogEntry.class, RequestResponseLogEntry.class, ExpectationMatchLogEntry.class);
    private static final List<Class<? extends LogEntry>> EXPECTATION_LOG_TYPES = Collections.singletonList(RequestResponseLogEntry.class);
    static Predicate<LogEntry> messageLogPredicate = new Predicate<LogEntry>(){

        public boolean apply(LogEntry input) {
            return MESSAGE_LOG_TYPES.contains(input.getClass());
        }
    };
    static Predicate<LogEntry> requestLogPredicate = new Predicate<LogEntry>(){

        public boolean apply(LogEntry input) {
            return REQUEST_LOG_TYPES.contains(input.getClass());
        }
    };
    static Predicate<LogEntry> expectationLogPredicate = new Predicate<LogEntry>(){

        public boolean apply(LogEntry input) {
            return EXPECTATION_LOG_TYPES.contains(input.getClass());
        }
    };
    private static Function<LogEntry, List<HttpRequest>> logEntryToRequest = new Function<LogEntry, List<HttpRequest>>(){

        public List<HttpRequest> apply(LogEntry logEntry) {
            return logEntry.getHttpRequests();
        }
    };
    private static Function<LogEntry, Expectation> logEntryToExpectation = new Function<LogEntry, Expectation>(){

        public Expectation apply(LogEntry logEntry) {
            return ((ExpectationLogEntry)((Object)logEntry)).getExpectation();
        }
    };
    private MockServerLogger logFormatter;
    private Queue<LogEntry> requestLog = new BoundedConcurrentLinkedQueue<LogEntry>(ConfigurationProperties.maxExpectations());
    private MatcherBuilder matcherBuilder;
    private HttpRequestSerializer httpRequestSerializer;

    public MockServerEventLog(MockServerLogger logFormatter, Scheduler scheduler) {
        super(scheduler);
        this.logFormatter = logFormatter;
        this.matcherBuilder = new MatcherBuilder(logFormatter);
        this.httpRequestSerializer = new HttpRequestSerializer(logFormatter);
    }

    public void add(LogEntry logEntry) {
        this.requestLog.add(logEntry);
        this.notifyListeners(this);
    }

    public void reset() {
        this.requestLog.clear();
        this.notifyListeners(this);
    }

    public void clear(HttpRequest httpRequest) {
        if (httpRequest != null) {
            HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (LogEntry logEntry : new LinkedList<LogEntry>(this.requestLog)) {
                List<HttpRequest> requests = logEntry.getHttpRequests();
                boolean matches = false;
                for (HttpRequest request : requests) {
                    if (!requestMatcher.matches(request)) continue;
                    matches = true;
                }
                if (!matches) continue;
                this.requestLog.remove(logEntry);
            }
        } else {
            this.reset();
        }
        this.notifyListeners(this);
    }

    public List<LogEntry> retrieveRequestLogEntries(HttpRequest httpRequest) {
        return this.retrieveLogEntries(httpRequest, requestLogPredicate, new Function<LogEntry, LogEntry>(){

            public LogEntry apply(LogEntry input) {
                return input;
            }
        });
    }

    public List<MessageLogEntry> retrieveMessageLogEntries(HttpRequest httpRequest) {
        return this.retrieveLogEntries(httpRequest, messageLogPredicate, new Function<LogEntry, MessageLogEntry>(){

            public MessageLogEntry apply(LogEntry input) {
                return (MessageLogEntry)input;
            }
        });
    }

    public List<MessageLogEntry> retrieveMessages(HttpRequest httpRequest) {
        return this.retrieveLogEntries(httpRequest, messageLogPredicate, new Function<LogEntry, MessageLogEntry>(){

            public MessageLogEntry apply(LogEntry input) {
                return (MessageLogEntry)input;
            }
        });
    }

    public List<HttpRequest> retrieveRequests(HttpRequest httpRequest) {
        ArrayList<HttpRequest> result = new ArrayList<HttpRequest>();
        for (List<HttpRequest> httpRequests : this.retrieveLogEntries(httpRequest, requestLogPredicate, logEntryToRequest)) {
            result.addAll(httpRequests);
        }
        return result;
    }

    public List<Expectation> retrieveExpectations(HttpRequest httpRequest) {
        return this.retrieveLogEntries(httpRequest, expectationLogPredicate, logEntryToExpectation);
    }

    <T> List<T> retrieveLogEntries(HttpRequest httpRequest, Predicate<LogEntry> logEntryPredicate, Function<LogEntry, T> logEntryToTypeFunction) {
        ArrayList<Object> matchingLogEntries = new ArrayList<Object>();
        HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
        for (LogEntry logEntry : new LinkedList<LogEntry>(this.requestLog)) {
            List<HttpRequest> requests = logEntry.getHttpRequests();
            boolean matched = false;
            for (HttpRequest request : requests) {
                if (!logEntryPredicate.apply((Object)logEntry) || !httpRequestMatcher.matches(request)) continue;
                matched = true;
            }
            if (!matched) continue;
            matchingLogEntries.add(logEntryToTypeFunction.apply((Object)logEntry));
        }
        return matchingLogEntries;
    }

    public String verify(Verification verification) {
        String failureMessage = "";
        if (verification != null) {
            List<HttpRequest> matchingRequests = this.retrieveRequests(verification.getHttpRequest());
            boolean verified = true;
            if (verification.getTimes().getCount() != 0 && matchingRequests.isEmpty()) {
                verified = false;
            } else if (verification.getTimes().isExact() && matchingRequests.size() != verification.getTimes().getCount()) {
                verified = false;
            } else if (matchingRequests.size() < verification.getTimes().getCount()) {
                verified = false;
            }
            if (!verified) {
                List<HttpRequest> allRequestsArray = this.retrieveRequests(null);
                String serializedRequestToBeVerified = this.httpRequestSerializer.serialize(true, verification.getHttpRequest());
                String serializedAllRequestInLog = allRequestsArray.size() == 1 ? this.httpRequestSerializer.serialize(true, allRequestsArray.get(0)) : this.httpRequestSerializer.serialize(true, allRequestsArray);
                failureMessage = "Request not found " + verification.getTimes() + ", expected:<" + serializedRequestToBeVerified + "> but was:<" + serializedAllRequestInLog + ">";
                this.logFormatter.info(MessageLogEntry.LogMessageType.VERIFICATION_FAILED, verification.getHttpRequest(), "request not found " + verification.getTimes() + ", expected:{}but was:{}", verification.getHttpRequest(), allRequestsArray.size() == 1 ? allRequestsArray.get(0) : allRequestsArray);
            }
        }
        return failureMessage;
    }

    public String verify(VerificationSequence verificationSequence) {
        LinkedList<LogEntry> requestLog = new LinkedList<LogEntry>(this.requestLog);
        String failureMessage = "";
        if (verificationSequence != null) {
            int requestLogCounter = 0;
            for (HttpRequest verificationHttpRequest : verificationSequence.getHttpRequests()) {
                if (verificationHttpRequest == null) continue;
                HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(verificationHttpRequest);
                boolean foundRequest = false;
                while (!foundRequest && requestLogCounter < requestLog.size()) {
                    LogEntry logEntry = requestLog.get(requestLogCounter);
                    List<HttpRequest> requests = logEntry.getHttpRequests();
                    for (HttpRequest request : requests) {
                        if (logEntry instanceof MessageLogEntry || !httpRequestMatcher.matches(request)) continue;
                        foundRequest = true;
                    }
                    ++requestLogCounter;
                }
                if (foundRequest) continue;
                List<HttpRequest> allRequestsArray = this.retrieveRequests(null);
                String serializedRequestToBeVerified = this.httpRequestSerializer.serialize(true, verificationSequence.getHttpRequests());
                String serializedAllRequestInLog = allRequestsArray.size() == 1 ? this.httpRequestSerializer.serialize(true, allRequestsArray.get(0)) : this.httpRequestSerializer.serialize(true, allRequestsArray);
                failureMessage = "Request sequence not found, expected:<" + serializedRequestToBeVerified + "> but was:<" + serializedAllRequestInLog + ">";
                this.logFormatter.info(MessageLogEntry.LogMessageType.VERIFICATION_FAILED, verificationSequence.getHttpRequests(), "request sequence not found, expected:{}but was:{}", verificationSequence.getHttpRequests(), allRequestsArray.size() == 1 ? allRequestsArray.get(0) : allRequestsArray);
                break;
            }
        }
        return failureMessage;
    }
}

