/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.Matcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class BooleanMatcher
extends ObjectWithReflectiveEqualsHashCodeToString
implements Matcher<Boolean> {
    private static final String[] excludedFields = new String[]{"mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final Boolean matcher;

    public BooleanMatcher(MockServerLogger mockServerLogger, Boolean matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
    }

    @Override
    public boolean matches(HttpRequest context, Boolean matched) {
        boolean result = false;
        if (this.matcher == null) {
            result = true;
        } else if (matched != null) {
            boolean bl = result = matched == this.matcher;
        }
        if (!result) {
            this.mockServerLogger.trace(context, "Failed to match [{}] with [{}]", matched, this.matcher);
        }
        return result;
    }

    @Override
    @JsonIgnore
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

