/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.net.MediaType;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.client.serialization.java.ExpectationToJavaSerializer;
import org.mockserver.client.serialization.java.HttpRequestToJavaSerializer;
import org.mockserver.filters.MockServerEventLog;
import org.mockserver.log.model.LogEntry;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.model.Action;
import org.mockserver.model.ClearType;
import org.mockserver.model.Format;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RetrieveType;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.socket.KeyAndCertificateFactory;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.LoggerFactory;

public class HttpStateHandler {
    public static final String LOG_SEPARATOR = "\n------------------------------------\n";
    public static final String PATH_PREFIX = "/mockserver";
    private final MockServerEventLog mockServerLog;
    private final Scheduler scheduler;
    private MockServerMatcher mockServerMatcher;
    private MockServerLogger mockServerLogger = new MockServerLogger(LoggerFactory.getLogger(this.getClass()), this);
    private WebSocketClientRegistry webSocketClientRegistry = new WebSocketClientRegistry();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer(this.mockServerLogger);
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer(this.mockServerLogger);
    private HttpRequestToJavaSerializer httpRequestToJavaSerializer = new HttpRequestToJavaSerializer();
    private ExpectationToJavaSerializer expectationToJavaSerializer = new ExpectationToJavaSerializer();
    private VerificationSerializer verificationSerializer = new VerificationSerializer(this.mockServerLogger);
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer(this.mockServerLogger);

    public HttpStateHandler(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.mockServerLog = new MockServerEventLog(this.mockServerLogger, scheduler);
        this.mockServerMatcher = new MockServerMatcher(this.mockServerLogger, scheduler);
    }

    public MockServerLogger getMockServerLogger() {
        return this.mockServerLogger;
    }

    public void clear(HttpRequest request) {
        HttpRequest requestMatcher = null;
        if (!Strings.isNullOrEmpty((String)request.getBodyAsString())) {
            requestMatcher = this.httpRequestSerializer.deserialize(request.getBodyAsString());
        }
        try {
            ClearType retrieveType = ClearType.valueOf((String)StringUtils.defaultIfEmpty((CharSequence)request.getFirstQueryStringParameter("type").toUpperCase(), (CharSequence)"ALL"));
            switch (retrieveType) {
                case LOG: {
                    this.mockServerLog.clear(requestMatcher);
                    this.mockServerLogger.info(MessageLogEntry.LogMessageType.CLEARED, requestMatcher, "clearing recorded requests and logs that match:{}", requestMatcher == null ? "{}" : requestMatcher);
                    break;
                }
                case EXPECTATIONS: {
                    this.mockServerMatcher.clear(requestMatcher);
                    this.mockServerLogger.info(MessageLogEntry.LogMessageType.CLEARED, requestMatcher, "clearing expectations that match:{}", requestMatcher == null ? "{}" : requestMatcher);
                    break;
                }
                case ALL: {
                    this.mockServerLog.clear(requestMatcher);
                    this.mockServerMatcher.clear(requestMatcher);
                    this.mockServerLogger.info(MessageLogEntry.LogMessageType.CLEARED, requestMatcher, "clearing expectations and request logs that match:{}", requestMatcher == null ? "{}" : requestMatcher);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("type") + "\" is not a valid value for \"type\" parameter, only the following values are supported " + Lists.transform(Arrays.asList(ClearType.values()), (Function)new Function<ClearType, String>(){

                public String apply(ClearType input) {
                    return input.name().toLowerCase();
                }
            }));
        }
    }

    public void reset() {
        this.mockServerMatcher.reset();
        this.mockServerLog.reset();
        this.mockServerLogger.info(MessageLogEntry.LogMessageType.CLEARED, "resetting all expectations and request logs", new Object[0]);
    }

    public void add(Expectation ... expectations) {
        for (Expectation expectation : expectations) {
            final String hostHeader = expectation.getHttpRequest().getFirstHeader(HttpHeaderNames.HOST.toString());
            this.scheduler.submit(new Runnable(){

                @Override
                public void run() {
                    KeyAndCertificateFactory.addSubjectAlternativeName(hostHeader);
                }
            });
            this.mockServerMatcher.add(expectation);
            this.mockServerLogger.info(MessageLogEntry.LogMessageType.CREATED_EXPECTATION, expectation.getHttpRequest(), "creating expectation:{}", expectation.clone());
        }
    }

    public Expectation firstMatchingExpectation(HttpRequest request) {
        if (this.mockServerMatcher.isEmpty()) {
            this.mockServerLogger.info(MessageLogEntry.LogMessageType.EXPECTATION_NOT_MATCHED, request, "no active expectations", new Object[0]);
            return null;
        }
        return this.mockServerMatcher.firstMatchingExpectation(request);
    }

    public void log(LogEntry logEntry) {
        if (this.mockServerLog != null) {
            this.mockServerLog.add(logEntry);
        }
    }

    public HttpResponse retrieve(HttpRequest request) {
        HttpRequest httpRequest = null;
        if (!Strings.isNullOrEmpty((String)request.getBodyAsString())) {
            httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
        }
        HttpResponse response = HttpResponse.response();
        try {
            Format format = Format.valueOf((String)StringUtils.defaultIfEmpty((CharSequence)request.getFirstQueryStringParameter("format").toUpperCase(), (CharSequence)"JSON"));
            RetrieveType retrieveType = RetrieveType.valueOf((String)StringUtils.defaultIfEmpty((CharSequence)request.getFirstQueryStringParameter("type").toUpperCase(), (CharSequence)"REQUESTS"));
            block1 : switch (retrieveType) {
                case LOGS: {
                    this.mockServerLogger.info(MessageLogEntry.LogMessageType.RETRIEVED, httpRequest, "retrieving " + retrieveType.name().toLowerCase() + " that match:{}", httpRequest == null ? HttpRequest.request() : httpRequest);
                    List<MessageLogEntry> retrievedMessages = this.mockServerLog.retrieveMessages(httpRequest);
                    StringBuilder stringBuffer = new StringBuilder();
                    for (int i = 0; i < retrievedMessages.size(); ++i) {
                        MessageLogEntry messageLogEntry = retrievedMessages.get(i);
                        stringBuffer.append(messageLogEntry.getTimeStamp()).append(" - ").append(messageLogEntry.getMessage());
                        if (i >= retrievedMessages.size() - 1) continue;
                        stringBuffer.append(LOG_SEPARATOR);
                    }
                    stringBuffer.append("\n");
                    response.withBody(stringBuffer.toString(), MediaType.PLAIN_TEXT_UTF_8);
                    break;
                }
                case REQUESTS: {
                    this.mockServerLogger.info(MessageLogEntry.LogMessageType.RETRIEVED, httpRequest, "retrieving " + retrieveType.name().toLowerCase() + " in " + format.name().toLowerCase() + " that match:{}", httpRequest == null ? HttpRequest.request() : httpRequest);
                    List<HttpRequest> httpRequests = this.mockServerLog.retrieveRequests(httpRequest);
                    switch (format) {
                        case JAVA: {
                            response.withBody(this.httpRequestToJavaSerializer.serialize(httpRequests), MediaType.create((String)"application", (String)"java").withCharset(StandardCharsets.UTF_8));
                            break block1;
                        }
                        case JSON: {
                            response.withBody(this.httpRequestSerializer.serialize(httpRequests), MediaType.JSON_UTF_8);
                        }
                    }
                    break;
                }
                case RECORDED_EXPECTATIONS: {
                    this.mockServerLogger.info(MessageLogEntry.LogMessageType.RETRIEVED, httpRequest, "retrieving " + retrieveType.name().toLowerCase() + " in " + format.name().toLowerCase() + " that match:{}", httpRequest == null ? HttpRequest.request() : httpRequest);
                    List<Expectation> expectations = this.mockServerLog.retrieveExpectations(httpRequest);
                    switch (format) {
                        case JAVA: {
                            response.withBody(this.expectationToJavaSerializer.serialize(expectations), MediaType.create((String)"application", (String)"java").withCharset(StandardCharsets.UTF_8));
                            break block1;
                        }
                        case JSON: {
                            response.withBody(this.expectationSerializer.serialize(expectations), MediaType.JSON_UTF_8);
                        }
                    }
                    break;
                }
                case ACTIVE_EXPECTATIONS: {
                    this.mockServerLogger.info(MessageLogEntry.LogMessageType.RETRIEVED, httpRequest, "retrieving " + retrieveType.name().toLowerCase() + " in " + format.name().toLowerCase() + " that match:{}", httpRequest == null ? HttpRequest.request() : httpRequest);
                    List<Expectation> expectations = this.mockServerMatcher.retrieveExpectations(httpRequest);
                    switch (format) {
                        case JAVA: {
                            response.withBody(this.expectationToJavaSerializer.serialize(expectations), MediaType.create((String)"application", (String)"java").withCharset(StandardCharsets.UTF_8));
                            break block1;
                        }
                        case JSON: {
                            response.withBody(this.expectationSerializer.serialize(expectations), MediaType.JSON_UTF_8);
                        }
                    }
                    break;
                }
            }
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage().contains(RetrieveType.class.getSimpleName())) {
                throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("type") + "\" is not a valid value for \"type\" parameter, only the following values are supported " + Lists.transform(Arrays.asList(RetrieveType.values()), (Function)new Function<RetrieveType, String>(){

                    public String apply(RetrieveType input) {
                        return input.name().toLowerCase();
                    }
                }));
            }
            throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("format") + "\" is not a valid value for \"format\" parameter, only the following values are supported " + Lists.transform(Arrays.asList(Format.values()), (Function)new Function<Format, String>(){

                public String apply(Format input) {
                    return input.name().toLowerCase();
                }
            }));
        }
        return response.withStatusCode(200);
    }

    public String verify(Verification verification) {
        return this.mockServerLog.verify(verification);
    }

    public String verify(VerificationSequence verification) {
        return this.mockServerLog.verify(verification);
    }

    public boolean handle(HttpRequest request, ResponseWriter responseWriter, boolean warDeployment) {
        this.mockServerLogger.trace(request, "received request:{}", request);
        if (request.matches("PUT", "/mockserver/expectation", "/expectation")) {
            for (Expectation expectation : this.expectationSerializer.deserializeArray(request.getBodyAsString())) {
                if (warDeployment && !this.validateSupportedFeatures(expectation, request, responseWriter)) continue;
                this.add(expectation);
            }
            responseWriter.writeResponse(request, HttpResponseStatus.CREATED);
        } else if (request.matches("PUT", "/mockserver/clear", "/clear")) {
            this.clear(request);
            responseWriter.writeResponse(request, HttpResponseStatus.OK);
        } else if (request.matches("PUT", "/mockserver/reset", "/reset")) {
            this.reset();
            responseWriter.writeResponse(request, HttpResponseStatus.OK);
        } else if (request.matches("PUT", "/mockserver/retrieve", "/retrieve")) {
            responseWriter.writeResponse(request, this.retrieve(request), true);
        } else if (request.matches("PUT", "/mockserver/verify", "/verify")) {
            Verification verification = this.verificationSerializer.deserialize(request.getBodyAsString());
            this.mockServerLogger.info(MessageLogEntry.LogMessageType.VERIFICATION, verification.getHttpRequest(), "verifying requests that match:{}", verification);
            String result = this.verify(verification);
            if (StringUtils.isEmpty((CharSequence)result)) {
                responseWriter.writeResponse(request, HttpResponseStatus.ACCEPTED);
            } else {
                responseWriter.writeResponse(request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create((String)"text", (String)"plain").toString());
            }
        } else if (request.matches("PUT", "/mockserver/verifySequence", "/verifySequence")) {
            VerificationSequence verificationSequence = this.verificationSequenceSerializer.deserialize(request.getBodyAsString());
            this.mockServerLogger.info(MessageLogEntry.LogMessageType.VERIFICATION, verificationSequence.getHttpRequests(), "verifying sequence that match:{}", verificationSequence);
            String result = this.verify(verificationSequence);
            if (StringUtils.isEmpty((CharSequence)result)) {
                responseWriter.writeResponse(request, HttpResponseStatus.ACCEPTED);
            } else {
                responseWriter.writeResponse(request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create((String)"text", (String)"plain").toString());
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean validateSupportedFeatures(Expectation expectation, HttpRequest request, ResponseWriter responseWriter) {
        boolean valid = true;
        Action action = expectation.getAction();
        String NOT_SUPPORTED_MESSAGE = " is not supported by MockServer deployed as a WAR due to limitations in the JEE specification; use mockserver-netty to enable these features";
        if (action instanceof HttpResponse && ((HttpResponse)action).getConnectionOptions() != null) {
            responseWriter.writeResponse(request, HttpResponse.response("ConnectionOptions" + NOT_SUPPORTED_MESSAGE), true);
            valid = false;
        } else if (action instanceof HttpObjectCallback) {
            responseWriter.writeResponse(request, HttpResponse.response("HttpObjectCallback" + NOT_SUPPORTED_MESSAGE), true);
            valid = false;
        } else if (action instanceof HttpError) {
            responseWriter.writeResponse(request, HttpResponse.response("HttpError" + NOT_SUPPORTED_MESSAGE), true);
            valid = false;
        }
        return valid;
    }

    public WebSocketClientRegistry getWebSocketClientRegistry() {
        return this.webSocketClientRegistry;
    }

    public MockServerMatcher getMockServerMatcher() {
        return this.mockServerMatcher;
    }

    public MockServerEventLog getMockServerLog() {
        return this.mockServerLog;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

