/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mockserver.collections.CaseInsensitiveRegexHashMap;
import org.mockserver.model.KeyAndValue;
import org.mockserver.model.NottableString;
import org.mockserver.model.ObjectWithJsonToString;

public abstract class KeysAndValues<T extends KeyAndValue, K extends KeysAndValues>
extends ObjectWithJsonToString {
    private Map<NottableString, NottableString> map = new LinkedHashMap<NottableString, NottableString>();

    public CaseInsensitiveRegexHashMap toCaseInsensitiveRegexMultiMap(List<T> entries) {
        CaseInsensitiveRegexHashMap caseInsensitiveRegexHashMap = new CaseInsensitiveRegexHashMap();
        if (entries != null) {
            for (KeyAndValue keyToMultiValue : entries) {
                caseInsensitiveRegexHashMap.put(keyToMultiValue.getName(), keyToMultiValue.getValue());
            }
        }
        return caseInsensitiveRegexHashMap;
    }

    public abstract T build(NottableString var1, NottableString var2);

    public K withEntries(List<T> cookies) {
        this.map.clear();
        if (cookies != null) {
            for (KeyAndValue cookie : cookies) {
                this.withEntry(cookie);
            }
        }
        return (K)this;
    }

    public K withEntries(T ... cookies) {
        if (cookies != null) {
            this.withEntries(Arrays.asList(cookies));
        }
        return (K)this;
    }

    public K withEntry(T cookie) {
        this.map.put(((KeyAndValue)cookie).getName(), ((KeyAndValue)cookie).getValue());
        return (K)this;
    }

    public K withEntry(String name, String value) {
        this.map.put(NottableString.string(name), NottableString.string(value));
        return (K)this;
    }

    public K withEntry(NottableString name, NottableString value) {
        this.map.put(name, value);
        return (K)this;
    }

    public List<T> getEntries() {
        ArrayList<T> cookies = new ArrayList<T>();
        for (NottableString nottableString : this.map.keySet()) {
            cookies.add(this.build(nottableString, this.map.get(nottableString)));
        }
        return cookies;
    }

    public CaseInsensitiveRegexHashMap toCaseInsensitiveRegexMultiMap() {
        return this.toCaseInsensitiveRegexMultiMap(this.getEntries());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

