/**
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

// DO NOT EDIT THIS GENERATED OUTPUT DIRECTLY!
// This file should be overwritten as part of your build process.
// If you need to extend the behavior of the generated service worker, the best approach is to write
// additional code and include it using the importScripts option:
//   https://github.com/GoogleChrome/sw-precache#importscripts-arraystring
//
// Alternatively, it's possible to make changes to the underlying template file and then use that as the
// new base for generating output, via the templateFilePath option:
//   https://github.com/GoogleChrome/sw-precache#templatefilepath-string
//
// If you go that route, make sure that whenever you update your sw-precache dependency, you reconcile any
// changes made to this original template file with your modified copy.

// This generated service worker JavaScript will precache your site's resources.
// The code needs to be saved in a .js file at the top-level of your site, and registered
// from your pages in order to be used. See
// https://github.com/googlechrome/sw-precache/blob/master/demo/app/js/service-worker-registration.js
// for an example of how you can register this script and handle various service worker events.

/* eslint-env worker, serviceworker */
/* eslint-disable indent, no-unused-vars, no-multiple-empty-lines, max-nested-callbacks, space-before-function-paren, quotes, comma-spacing */
'use strict';

var precacheConfig = [["allclasses-frame.html","2b0388d41a598285dfdec85ebeb4aa8a"],["allclasses-noframe.html","060695798db4a635eaeb326589ceb3ce"],["constant-values.html","51e527eb1598b4b508b814ca3a57b271"],["deprecated-list.html","33fb509abbbc3c1e74698206bc41db64"],["favicon.ico","05e61206186c2eee9054011bcf15b864"],["help-doc.html","4cb322c7f4e8ef817e5e020f108f3ab0"],["index-files/index-1.html","8faa5409f5ca201f826654f711955d3a"],["index-files/index-10.html","35e0f2ad4a056bbe6314320d1d4754a5"],["index-files/index-11.html","5b58b68bee7cd922a07315a24e26440f"],["index-files/index-12.html","ad62988350bbdd8f7f82142974b1a0aa"],["index-files/index-13.html","f49d85090711622557dce45cf356aa34"],["index-files/index-14.html","e23cb4d5d391c1d0212777a4b64caa7b"],["index-files/index-15.html","d67b2609bc80a8176b689ae86534b913"],["index-files/index-16.html","d74e5caa1c3ea4f4e779e3b0b6c38382"],["index-files/index-17.html","bc30809d89eedc2213322775d5b00ea5"],["index-files/index-18.html","118b1c18d428cad8f7669d1f15dd32b1"],["index-files/index-19.html","f0377ba99304d2972540488de0d5eece"],["index-files/index-2.html","2a2fca1314412fbad5ec5faee364a502"],["index-files/index-20.html","6ef1f01799e85bd53e0db95b93a7b16a"],["index-files/index-3.html","544dcedd568388369979c9257b5b4605"],["index-files/index-4.html","b13bc37a81b5293426db73c8ffe9192d"],["index-files/index-5.html","1e29cdd3982527538d25338139897e0e"],["index-files/index-6.html","6acedd7717f58244474e204304bad76a"],["index-files/index-7.html","f7b3d0a1382efb1ac3c9f185891541a4"],["index-files/index-8.html","7976bb47532e3cc63bf51543820ef2a7"],["index-files/index-9.html","0e7d4ef2566e005f9af93ef44e6d5650"],["index.html","2f6ad0c4f7f036ea942213473597c2b9"],["js/highlight-8.6-java/highlight.pack.js","deec56e4bb489b0ce943987284aac274"],["js/highlight-8.6-java/styles/obsidian.css","d60cd29c66c835762c95d2ce6da21142"],["js/index.js","dfc78156c8712ef6c546ea1037a604ef"],["js/jdk6-project-version-insert.js","ddee726b95840e7606e132d95c65ef27"],["js/jdk6-project-version-insert.min.js","a6a8d425f512ba0a8e2340504f134553"],["js/jquery-1.7.min.js","25721ced154b3a99e818431446d7506d"],["org/mockito/AdditionalAnswers.html","7887e36339c9568fedc3a3432c3c3145"],["org/mockito/AdditionalMatchers.html","904226b9e247d187cf1a5efde773e0f5"],["org/mockito/Answers.html","637d0243ef4afe48e48a2154b98bd988"],["org/mockito/ArgumentCaptor.html","a7c926ff173c25848dac5d9a61858e68"],["org/mockito/ArgumentMatcher.html","e492ed181e4bef3fee3b1d353dff2b95"],["org/mockito/ArgumentMatchers.html","6aa3842dd996019c0dfa6686fdd5b06a"],["org/mockito/BDDMockito.BDDMyOngoingStubbing.html","6251ab88e89de990fdb9211dcb37c82d"],["org/mockito/BDDMockito.BDDStubber.html","f4e98bee0d62ff04b836aa1913913d82"],["org/mockito/BDDMockito.Then.html","b866dd7536578ee0cdbfbcaee67eaf3b"],["org/mockito/BDDMockito.html","8fcc3f1672f246ae2b3cc04fcce81736"],["org/mockito/Captor.html","b706be40cb10745e1bd8bcbd7fded4d5"],["org/mockito/InOrder.html","582bc0c380dbcdf2cc24b23d3cb8a285"],["org/mockito/Incubating.html","440d453a33143f1416ffd97dd3f186c8"],["org/mockito/InjectMocks.html","da8c1d0cd47be010c764fae40858c99c"],["org/mockito/Matchers.html","a418db201fb38de7504aaae419ad1888"],["org/mockito/Mock.html","2f7d806366b2b49c568a7d637f90edef"],["org/mockito/MockSettings.html","7a6464666d44bb06794d91349a9496e4"],["org/mockito/MockingDetails.html","01642a7f57d1829663822df310fc26c3"],["org/mockito/Mockito.html","ab95c59b7b76ba714d9b3a1d2771bfc7"],["org/mockito/MockitoAnnotations.html","472e13327a39684e1a8e9e437a16e7a0"],["org/mockito/MockitoDebugger.html","fb9288df496bb78a68dcfb6f5c708253"],["org/mockito/MockitoFramework.html","742a34cc334d6228f8ec58d94683af62"],["org/mockito/MockitoSession.html","9972680647992eedd14c436e30937240"],["org/mockito/NotExtensible.html","45f5bcde802627830719b01079507074"],["org/mockito/Spy.html","52e15e6e96de8f171ffb431915c80486"],["org/mockito/class-use/AdditionalAnswers.html","b6d775e97d0052256d2ec674cfff5c85"],["org/mockito/class-use/AdditionalMatchers.html","1b9e71b9e57afb4f7a33ddc0c3ca39e6"],["org/mockito/class-use/Answers.html","bfacbffb9c30348279c6c041c5f13abc"],["org/mockito/class-use/ArgumentCaptor.html","802ee5e449f0d894cf3955ba9d95569a"],["org/mockito/class-use/ArgumentMatcher.html","c8407d3b7d028045441ecfa4c3b0253b"],["org/mockito/class-use/ArgumentMatchers.html","d589b8fea2121a7ca5c4c4ed886aaa7b"],["org/mockito/class-use/BDDMockito.BDDMyOngoingStubbing.html","c6c6195561d089b515e134f45bb4f852"],["org/mockito/class-use/BDDMockito.BDDStubber.html","53a12062421e21823df1554e33e79515"],["org/mockito/class-use/BDDMockito.Then.html","9d13812690eb4448908dc9c14319fb2d"],["org/mockito/class-use/BDDMockito.html","efb5c3a1b9c660ec0de5c42dd4f4121e"],["org/mockito/class-use/Captor.html","94a0b6418d7d1ef357e3b4b0211fa974"],["org/mockito/class-use/InOrder.html","cec7fe8932e4a5b90cea0be6c4904243"],["org/mockito/class-use/Incubating.html","b30e9263f2f5f8a0c55c6159a87c750f"],["org/mockito/class-use/InjectMocks.html","cf77539c60f8a9d0fe708a036c25ef19"],["org/mockito/class-use/Matchers.html","dca15ddce75550566504b5e54f1f0be4"],["org/mockito/class-use/Mock.html","a20559123708e2ea76265045b7345c38"],["org/mockito/class-use/MockSettings.html","dfa6a0de8bbffe779e0f06cf455afe15"],["org/mockito/class-use/MockingDetails.html","db0ca1a6e0ef9e69aa44510038d40d50"],["org/mockito/class-use/Mockito.html","a633da4b158c5cf4d67aa999aa657a63"],["org/mockito/class-use/MockitoAnnotations.html","92b6d9f78abacd3384267784bf5dff70"],["org/mockito/class-use/MockitoDebugger.html","0fac0a0f8d5b4e4cb1c264cfb48660c1"],["org/mockito/class-use/MockitoFramework.html","33fbf0b4651a6a231a0ae0d5a57e9c52"],["org/mockito/class-use/MockitoSession.html","dcfa3251385b49de1f4b44b774172b79"],["org/mockito/class-use/NotExtensible.html","85e086bf51e3ee0d65446974902c0d99"],["org/mockito/class-use/Spy.html","7cb23f665d690ce1b6e1f0b8ebf4770d"],["org/mockito/configuration/AnnotationEngine.html","421fa4edc5eab83bbfad5892626796e2"],["org/mockito/configuration/DefaultMockitoConfiguration.html","6ea13fdb48303ed545416523e90337a6"],["org/mockito/configuration/IMockitoConfiguration.html","ca87b59f44c8e16d3abae0c028a15bdf"],["org/mockito/configuration/class-use/AnnotationEngine.html","c9ee3d15ca502bb1a9d38a4d9c87ed14"],["org/mockito/configuration/class-use/DefaultMockitoConfiguration.html","faf7243c4e8759fed253fcd2651eb717"],["org/mockito/configuration/class-use/IMockitoConfiguration.html","165a3e66221b04b64bc59d818ad7c787"],["org/mockito/configuration/package-frame.html","317fcbba3a1cf4f456b191e4efaa60fb"],["org/mockito/configuration/package-summary.html","d6830efad2cdecf9197e4015a29294be"],["org/mockito/configuration/package-tree.html","ee4c9fff6a5c6c371fbc05386f2d219e"],["org/mockito/configuration/package-use.html","71ec37115595fc8fbe75a5833b14936d"],["org/mockito/exceptions/base/MockitoAssertionError.html","9726cfe2567bb46190cfc65992f5cd9b"],["org/mockito/exceptions/base/MockitoException.html","e972afc14e8a6f4396a93c9c5bf85ff8"],["org/mockito/exceptions/base/MockitoInitializationException.html","ab00150f43778f6f3c34f5077acaa75b"],["org/mockito/exceptions/base/MockitoSerializationIssue.html","281f0cbeb0ebb610dd2708f3f71116af"],["org/mockito/exceptions/base/class-use/MockitoAssertionError.html","dbb57715287087ac5bc10e939eedd2f0"],["org/mockito/exceptions/base/class-use/MockitoException.html","b14dea9fab78333f122f35ba7d703bee"],["org/mockito/exceptions/base/class-use/MockitoInitializationException.html","4efe533dbdbe7de16d066b9ff04974ee"],["org/mockito/exceptions/base/class-use/MockitoSerializationIssue.html","948ad3e66e1655e471d1452e4139272e"],["org/mockito/exceptions/base/package-frame.html","170074951912ee4ba8ae5a9d01b7c4c1"],["org/mockito/exceptions/base/package-summary.html","72ab516c9d4c4832d2e691326e0bd1c2"],["org/mockito/exceptions/base/package-tree.html","164b0a9442a4d9b5809f33de4430b520"],["org/mockito/exceptions/base/package-use.html","4ca35af7dfc3397c901dc4230b4bb9d5"],["org/mockito/exceptions/misusing/CannotStubVoidMethodWithReturnValue.html","743a8b429f6b124b76c11377b8122590"],["org/mockito/exceptions/misusing/CannotVerifyStubOnlyMock.html","0cb72c73684a75fa5b2886761eba3d10"],["org/mockito/exceptions/misusing/FriendlyReminderException.html","2e40fdd56b80df63ab95bf6a6c532dc5"],["org/mockito/exceptions/misusing/InvalidUseOfMatchersException.html","b6b1f9489103d6ce833544024acb56b1"],["org/mockito/exceptions/misusing/MissingMethodInvocationException.html","e6ac3c3a812433c22f733c46bfdd1939"],["org/mockito/exceptions/misusing/MockitoConfigurationException.html","35a615e8c1b8f44a3b00405cd764aecd"],["org/mockito/exceptions/misusing/NotAMockException.html","372be7fa7b4ffe3bf93df677a620d022"],["org/mockito/exceptions/misusing/NullInsteadOfMockException.html","8c28a350226612cefad956c68b3575b1"],["org/mockito/exceptions/misusing/PotentialStubbingProblem.html","6fbc2df1b44c4cda1dfa8f30a8698fb0"],["org/mockito/exceptions/misusing/RedundantListenerException.html","de324d5bc8d0348d9759545e6aa813bb"],["org/mockito/exceptions/misusing/UnfinishedMockingSessionException.html","9cff01d9097f4df79c8333174a798cd7"],["org/mockito/exceptions/misusing/UnfinishedStubbingException.html","0c1a93bd974aa907a44e204b9d957057"],["org/mockito/exceptions/misusing/UnfinishedVerificationException.html","2857b038cbe3d6318358631d26d8000f"],["org/mockito/exceptions/misusing/UnnecessaryStubbingException.html","03ee024474181da09e10093ffb683cfd"],["org/mockito/exceptions/misusing/WrongTypeOfReturnValue.html","9584f1044220b2f865529263b6dd53c9"],["org/mockito/exceptions/misusing/class-use/CannotStubVoidMethodWithReturnValue.html","76937dfc9061b64e7306053d0c7ed195"],["org/mockito/exceptions/misusing/class-use/CannotVerifyStubOnlyMock.html","d306cb0242e50c3591bd40f847bf7b99"],["org/mockito/exceptions/misusing/class-use/FriendlyReminderException.html","339accbc3428283853c6b2c6dc422279"],["org/mockito/exceptions/misusing/class-use/InvalidUseOfMatchersException.html","7997da1d9fdac4d690793de85d98d3af"],["org/mockito/exceptions/misusing/class-use/MissingMethodInvocationException.html","2aca1a26df9a8c98fab44afe0361ae55"],["org/mockito/exceptions/misusing/class-use/MockitoConfigurationException.html","2015c53e11acd0a40be432df0e206a1a"],["org/mockito/exceptions/misusing/class-use/NotAMockException.html","271c9d8fecbd0e7709ea60eeed81604a"],["org/mockito/exceptions/misusing/class-use/NullInsteadOfMockException.html","3dddd83930b71517de0a961f01cee513"],["org/mockito/exceptions/misusing/class-use/PotentialStubbingProblem.html","4f9825c89e2060cbf21e6bac90b63aac"],["org/mockito/exceptions/misusing/class-use/RedundantListenerException.html","5ab7c88764ed5a9adb9a52ecedb6abe5"],["org/mockito/exceptions/misusing/class-use/UnfinishedMockingSessionException.html","8ed9278faeaf00b7b0822a395af22d32"],["org/mockito/exceptions/misusing/class-use/UnfinishedStubbingException.html","e96905eab9db34a5033fcdc75d545c13"],["org/mockito/exceptions/misusing/class-use/UnfinishedVerificationException.html","f18c45509be593321c48e278dfc57396"],["org/mockito/exceptions/misusing/class-use/UnnecessaryStubbingException.html","7b2f8956d22ac0279fca98365b18ad07"],["org/mockito/exceptions/misusing/class-use/WrongTypeOfReturnValue.html","4480a357ef18f3451ee90cba6ce9fb12"],["org/mockito/exceptions/misusing/package-frame.html","a4379cf3385f8ada88e6ffff1a1ef942"],["org/mockito/exceptions/misusing/package-summary.html","af796f981b3bc90fb14448d76ccddbb2"],["org/mockito/exceptions/misusing/package-tree.html","5bfefd9349582ecf0bbd7312f3e428e8"],["org/mockito/exceptions/misusing/package-use.html","9f3b1d8b8f21cd503ac5d3a6a2af7bcc"],["org/mockito/exceptions/stacktrace/StackTraceCleaner.html","291a76391815786e251d62e8e5200440"],["org/mockito/exceptions/stacktrace/class-use/StackTraceCleaner.html","43793d2811f34598aaab95085b652d41"],["org/mockito/exceptions/stacktrace/package-frame.html","627756230a1a7ca6bcb2b2d929f76858"],["org/mockito/exceptions/stacktrace/package-summary.html","f9614db5baf84ce675d475e4cb0100e8"],["org/mockito/exceptions/stacktrace/package-tree.html","c76f57ba0307580440ca424e93c8b4d0"],["org/mockito/exceptions/stacktrace/package-use.html","cd281de88b21fada0df44dd0bd08e62b"],["org/mockito/exceptions/verification/ArgumentsAreDifferent.html","2361d62bc07906f5f681ce11997a8c74"],["org/mockito/exceptions/verification/NeverWantedButInvoked.html","4ff44fb3646a0e1dee58974080d4218c"],["org/mockito/exceptions/verification/NoInteractionsWanted.html","da94aa77d5ab58f070eaa792d7b151aa"],["org/mockito/exceptions/verification/SmartNullPointerException.html","b17ade4000b2b798b9f146cfccc0b563"],["org/mockito/exceptions/verification/TooLittleActualInvocations.html","d42394d4117c7ea4c33b6f2eb2d82177"],["org/mockito/exceptions/verification/TooManyActualInvocations.html","c5389d234561faa0b99563e9968d0c24"],["org/mockito/exceptions/verification/VerificationInOrderFailure.html","d3ce378aeb9f08719b1bfbabbbf55e8f"],["org/mockito/exceptions/verification/WantedButNotInvoked.html","091156aecbb9ee5738dd8364ef32ec9c"],["org/mockito/exceptions/verification/class-use/ArgumentsAreDifferent.html","08481d7245baae4b0d6af622cfa5a940"],["org/mockito/exceptions/verification/class-use/NeverWantedButInvoked.html","e194d5652ff82d9e15f35813a10ccda5"],["org/mockito/exceptions/verification/class-use/NoInteractionsWanted.html","0e036d47613d8ee6af89ea66cbf9c55a"],["org/mockito/exceptions/verification/class-use/SmartNullPointerException.html","b1e87e1fa05f4dfe6703d750afce257a"],["org/mockito/exceptions/verification/class-use/TooLittleActualInvocations.html","a631b17da09597f0eb8e8b13ff3e8655"],["org/mockito/exceptions/verification/class-use/TooManyActualInvocations.html","4ebffb8008b5b8d5600d4dccb6fef7bc"],["org/mockito/exceptions/verification/class-use/VerificationInOrderFailure.html","c292079b23f89244d49feae494e549f6"],["org/mockito/exceptions/verification/class-use/WantedButNotInvoked.html","bfd5905d1d7439977d70f00ded903479"],["org/mockito/exceptions/verification/junit/ArgumentsAreDifferent.html","46ea41be1b26be4986fd849aca5549d0"],["org/mockito/exceptions/verification/junit/class-use/ArgumentsAreDifferent.html","34fe8952546024a2031f121302df5780"],["org/mockito/exceptions/verification/junit/package-frame.html","4249dd8ad13de18c807d2722a770b545"],["org/mockito/exceptions/verification/junit/package-summary.html","cac15acaf753cbe6dc3d66cb472117ec"],["org/mockito/exceptions/verification/junit/package-tree.html","d45055cbb77f226bc13c2c601bb189ab"],["org/mockito/exceptions/verification/junit/package-use.html","dce0adac8e079585af0bdd4138a3b4ab"],["org/mockito/exceptions/verification/package-frame.html","bf92d2f71892f9242e84923e373d47c1"],["org/mockito/exceptions/verification/package-summary.html","1b1d5a676c7e4060b703efdf2ffdadc4"],["org/mockito/exceptions/verification/package-tree.html","297c2bb30d7efd9c99ad346d6af5992e"],["org/mockito/exceptions/verification/package-use.html","6fcbbc8a6f2b41fbea1886591f18c016"],["org/mockito/hamcrest/MockitoHamcrest.html","04534584acfe4de7952c1b48585c746b"],["org/mockito/hamcrest/class-use/MockitoHamcrest.html","b0f60f219a2a9035eb72baaf4308f9e2"],["org/mockito/hamcrest/package-frame.html","3e9f482f397dabf6c524e70bd2ef6ae6"],["org/mockito/hamcrest/package-summary.html","102c3ae8a96bc7460a15884a7db7b3aa"],["org/mockito/hamcrest/package-tree.html","39968b7df960015997036ce4d9c90182"],["org/mockito/hamcrest/package-use.html","c811323ab20f482580536b39049c6d82"],["org/mockito/invocation/DescribedInvocation.html","f80c54b326ccdf2e9757947c2c2c0c18"],["org/mockito/invocation/Invocation.html","b5dd88d817b445fa02f5511bc18a7d92"],["org/mockito/invocation/InvocationContainer.html","a261db5eb120e20ca66b46d998b0a122"],["org/mockito/invocation/InvocationFactory.html","548e7221ec2226ff1c076144d9a125cf"],["org/mockito/invocation/InvocationOnMock.html","f6c1e533e9b2bb31be9980d250f241fa"],["org/mockito/invocation/Location.html","1a96afbd8f853c4f4a69819c1cc62cb0"],["org/mockito/invocation/MatchableInvocation.html","0c27b0ea8c45d1ed537aa542ac696380"],["org/mockito/invocation/MockHandler.html","a3cdc7b146c4b4bd530a8ca5f7147e86"],["org/mockito/invocation/StubInfo.html","5b276fee85905995ce35316425c1ce68"],["org/mockito/invocation/class-use/DescribedInvocation.html","8c15891789b18cc0f19d7b4b9bcf7f62"],["org/mockito/invocation/class-use/Invocation.html","2f91cb4fe897fb8454cfd470a2fb2d37"],["org/mockito/invocation/class-use/InvocationContainer.html","bb71863cbb17a899fff6c0fb44eda327"],["org/mockito/invocation/class-use/InvocationFactory.html","a9d908400904ec905c8c2ce69f722393"],["org/mockito/invocation/class-use/InvocationOnMock.html","bf896e804a150139c8780046ac279a7e"],["org/mockito/invocation/class-use/Location.html","a3f77fc656b6edcf4ea8ac880a262fee"],["org/mockito/invocation/class-use/MatchableInvocation.html","29d7ab434374c0e4125355b3eec63e95"],["org/mockito/invocation/class-use/MockHandler.html","92c069240a09d2df120083a093b67183"],["org/mockito/invocation/class-use/StubInfo.html","9cde56aa2adde4c23b88a20c1fde4a54"],["org/mockito/invocation/package-frame.html","68729b16f6fe3b4960223d30f49f153e"],["org/mockito/invocation/package-summary.html","0a971b4593d84be1113f48aa2b47392c"],["org/mockito/invocation/package-tree.html","866baa9aba742381f27a31fdb89213af"],["org/mockito/invocation/package-use.html","efccdaa7cd729fde67485385500517cd"],["org/mockito/junit/MockitoJUnit.html","47be6e02fbbe29d7d6b63923775cdbd3"],["org/mockito/junit/MockitoJUnitRunner.Silent.html","6ededcedc0a9b0c1db474e080d80a688"],["org/mockito/junit/MockitoJUnitRunner.Strict.html","b81a2cd3f13ed2b7ffedd4a5556d6bce"],["org/mockito/junit/MockitoJUnitRunner.StrictStubs.html","4c376d66f56359ad61ea33d82ceaf106"],["org/mockito/junit/MockitoJUnitRunner.html","9ce83272db2d763afd0190ac8b8297da"],["org/mockito/junit/MockitoRule.html","2fb97c697844d7fb461481978710ff48"],["org/mockito/junit/VerificationCollector.html","a70cc9715384de2dc3be05b530412f23"],["org/mockito/junit/class-use/MockitoJUnit.html","de154436a42e7622f3e5132c2093eabe"],["org/mockito/junit/class-use/MockitoJUnitRunner.Silent.html","597e4bb5dd478979ec566f25c8783d64"],["org/mockito/junit/class-use/MockitoJUnitRunner.Strict.html","68355003d9e4d722eeea9a1eb0346afd"],["org/mockito/junit/class-use/MockitoJUnitRunner.StrictStubs.html","15d1f4f57171747c724b4a69cd064633"],["org/mockito/junit/class-use/MockitoJUnitRunner.html","37e3eb1a4c2c6cf976b248d5feb22a0e"],["org/mockito/junit/class-use/MockitoRule.html","461569eda785ae4322f85ef915ad6f42"],["org/mockito/junit/class-use/VerificationCollector.html","7195e0aa674585e7344f1b7dad7e9ae7"],["org/mockito/junit/package-frame.html","6ac6688ee61952056c8d7556bb255d61"],["org/mockito/junit/package-summary.html","52c0e6a13a700f21d6703351a0372d89"],["org/mockito/junit/package-tree.html","d8b05bd6bf34596f4e54d612ac58d755"],["org/mockito/junit/package-use.html","1148885cbbf585dacb6640310f2e0384"],["org/mockito/listeners/InvocationListener.html","222a4a1d8e0c0ed973b45cfdb1de8e4b"],["org/mockito/listeners/MethodInvocationReport.html","0fc54e8d6b9156dcf7ed8ed918698e70"],["org/mockito/listeners/MockCreationListener.html","14067128c11eb69838a6b9d31cc19163"],["org/mockito/listeners/MockitoListener.html","c8f9ef03c40206ea585a25cfe973dd37"],["org/mockito/listeners/VerificationListener.html","74114e80ee6c6684dd23495ac3960b4c"],["org/mockito/listeners/class-use/InvocationListener.html","233a30258ff82ed5d7ce051deb26825a"],["org/mockito/listeners/class-use/MethodInvocationReport.html","af27e1f7e3788845effa6a47e141bba3"],["org/mockito/listeners/class-use/MockCreationListener.html","c9f747cff1bd03ed3edb79e282afca26"],["org/mockito/listeners/class-use/MockitoListener.html","7b237afec0b1f0d12db8f6e0ca58a83b"],["org/mockito/listeners/class-use/VerificationListener.html","2dd79c782e97fa77fbc84bb66c05a404"],["org/mockito/listeners/package-frame.html","c05a5af1d7976111b56a61383da62740"],["org/mockito/listeners/package-summary.html","385a5f3e6d827f484e0ca98d5495d71c"],["org/mockito/listeners/package-tree.html","44929135f027a9facf7e8ad2f0337ba8"],["org/mockito/listeners/package-use.html","3e8b8a6479b89c991a8f246b52723efe"],["org/mockito/mock/MockCreationSettings.html","38b88347da141b755b70b78a1206ea0d"],["org/mockito/mock/MockName.html","9170e767c68549d5611232d2653cdb5f"],["org/mockito/mock/SerializableMode.html","c760ecdd2b4099fdb71fc7f5c0d0ac2b"],["org/mockito/mock/class-use/MockCreationSettings.html","9c7636928b55cc6a5a802c76f5a0e394"],["org/mockito/mock/class-use/MockName.html","d8a8caf6532877e2a870afebe4a9fe36"],["org/mockito/mock/class-use/SerializableMode.html","46db9af13075e69db25c90b922fbc021"],["org/mockito/mock/package-frame.html","884935a34a1e0ab230a4676fbd14896d"],["org/mockito/mock/package-summary.html","3d1b82cf0d81ebb0af31a6c246e8808d"],["org/mockito/mock/package-tree.html","33cf32005ffda309c590e76d64140416"],["org/mockito/mock/package-use.html","aa5f59bf426765b89a1c77a2ac269a54"],["org/mockito/package-frame.html","5f200f3a389b9ae2a34038432353426c"],["org/mockito/package-summary.html","b4f96e4e18cb3683309773df7a8f9f92"],["org/mockito/package-tree.html","696f61c51d6c1bdd22391d15f45b9ef3"],["org/mockito/package-use.html","a04361139ac350d8ea841b5cf05e200d"],["org/mockito/plugins/AnnotationEngine.html","93fcdff16cc1e974a27a8a331112ff12"],["org/mockito/plugins/InstantiatorProvider.html","d6ce7fe6bf4a9b3e5dd7a9e8f8ff9d74"],["org/mockito/plugins/MockMaker.TypeMockability.html","245c1b11333433df4c70bb541e3f62a4"],["org/mockito/plugins/MockMaker.html","1b98e3c8b58fe9e1d681630866da1b5a"],["org/mockito/plugins/MockitoPlugins.html","0f27466615916867917dc7e524846a1a"],["org/mockito/plugins/PluginSwitch.html","a57cbe2f9c8172ddd1369deda2188f55"],["org/mockito/plugins/StackTraceCleanerProvider.html","e152fe26d2becc20d87ab8ec03d09414"],["org/mockito/plugins/class-use/AnnotationEngine.html","fdfdb410221e847221f3df0961b29139"],["org/mockito/plugins/class-use/InstantiatorProvider.html","49d427d06983481afee3f9366125e4a2"],["org/mockito/plugins/class-use/MockMaker.TypeMockability.html","c9d1fc934237760311b4aa0277d7b70d"],["org/mockito/plugins/class-use/MockMaker.html","f977a5e2261fe6696fb62cb3a483a38a"],["org/mockito/plugins/class-use/MockitoPlugins.html","1ad4b18b43c6ab550d67f3827b86d17a"],["org/mockito/plugins/class-use/PluginSwitch.html","92a91c6b1e963854a851a327165d13f1"],["org/mockito/plugins/class-use/StackTraceCleanerProvider.html","4ee994d93fefe32d270250dc488172c8"],["org/mockito/plugins/package-frame.html","670453af8c234a9bdeceae5954c29daf"],["org/mockito/plugins/package-summary.html","505e41df06196bd7110d988b84f73746"],["org/mockito/plugins/package-tree.html","8fdcb6aa62965eae94ab117b5395c777"],["org/mockito/plugins/package-use.html","60b5c7ec3ef34eee10a3b3972689d3f0"],["org/mockito/quality/MockitoHint.html","3e99c82f17521f36b5e2de0394ee28bd"],["org/mockito/quality/Strictness.html","0442dfdf26443ed36050712d97856b7c"],["org/mockito/quality/class-use/MockitoHint.html","a137651a762ad1a9dd2e12946935520e"],["org/mockito/quality/class-use/Strictness.html","5769c7b31004d25169de7da779d2a4ff"],["org/mockito/quality/package-frame.html","d8b6a093a824de6dc05d47da820841d4"],["org/mockito/quality/package-summary.html","6dfd544affe0f95e0cab9de2cf967c90"],["org/mockito/quality/package-tree.html","077fe58e084d5b2ac0e500c34b9a45d2"],["org/mockito/quality/package-use.html","8ff3bfd953a2c1a9d9346d89a8f18eca"],["org/mockito/runners/ConsoleSpammingMockitoJUnitRunner.html","fe2b4df609f33782d8fbd48f0bc8a9e8"],["org/mockito/runners/MockitoJUnitRunner.Silent.html","bbb8e1ca904118afe345568285a2f4ce"],["org/mockito/runners/MockitoJUnitRunner.Strict.html","7cb502a7995d0ab0b3d147be86bfca2a"],["org/mockito/runners/MockitoJUnitRunner.html","504cf8b444f8f075fe1cdab04980129d"],["org/mockito/runners/VerboseMockitoJUnitRunner.html","addc0abd4a5d63f846e9fa2549ba9d2c"],["org/mockito/runners/class-use/ConsoleSpammingMockitoJUnitRunner.html","8352ed8b213cca886bea39e491e031d2"],["org/mockito/runners/class-use/MockitoJUnitRunner.Silent.html","a480475e40194c1ba1fe7d31b5292c24"],["org/mockito/runners/class-use/MockitoJUnitRunner.Strict.html","3f1aa24a87c77574c4488e9a4e0dbd93"],["org/mockito/runners/class-use/MockitoJUnitRunner.html","3e1f48843a6fdb74b1656da7949ffde0"],["org/mockito/runners/class-use/VerboseMockitoJUnitRunner.html","26dcb13a52c560daac2338b63d7a32b1"],["org/mockito/runners/package-frame.html","48602382d1cc26b26c9424218b2a7f79"],["org/mockito/runners/package-summary.html","621227e996ff24ea44336db4ac1b393d"],["org/mockito/runners/package-tree.html","812541dc3eecdf9f1dfa4a44384c0dc6"],["org/mockito/runners/package-use.html","1ce9bbf8041b68aefcbe4e575b635a87"],["org/mockito/session/MockitoSessionBuilder.html","890b36e009d841c764ae354065117fbe"],["org/mockito/session/class-use/MockitoSessionBuilder.html","511beba7ec9449c678ce15fd38c38036"],["org/mockito/session/package-frame.html","329ad0169a839a14f835b119bac9160c"],["org/mockito/session/package-summary.html","6d06eb31fc1f831efbed19eebd509159"],["org/mockito/session/package-tree.html","f8fbbf70c35ecffacdb115348cf63841"],["org/mockito/session/package-use.html","4d6815ae67c93aff68eaa8e6418cbedf"],["org/mockito/stubbing/Answer.html","49d4ffd494d4bddf634230eab0e40a2d"],["org/mockito/stubbing/Answer1.html","e4f9806ec5619a351672ef5e4bf63a93"],["org/mockito/stubbing/Answer2.html","ec0b972a9f46296cba0537701d5983e7"],["org/mockito/stubbing/Answer3.html","360c24a3a02b0fe23ca554c164fc5578"],["org/mockito/stubbing/Answer4.html","1f2f7e5beda95ac4ed8a81fc3b06d7c2"],["org/mockito/stubbing/Answer5.html","f2ad07f895063716bb7371dd0b910cb8"],["org/mockito/stubbing/OngoingStubbing.html","2476092bc0d06975bc09ca10d629fd95"],["org/mockito/stubbing/Stubber.html","c4c7eec62cffef32bdf5402a41cb04b6"],["org/mockito/stubbing/Stubbing.html","e7a1029e89248d0f98d32af9db30b7f1"],["org/mockito/stubbing/ValidableAnswer.html","061ac2363d734624c49f5a68663fe0f7"],["org/mockito/stubbing/VoidAnswer1.html","8ef8fb38f44bae44a677d6786ccd45f7"],["org/mockito/stubbing/VoidAnswer2.html","b24f86ed73aa70bb743bd2bfa0d2519b"],["org/mockito/stubbing/VoidAnswer3.html","b3027fb9811cca90ed502166ede3fd6c"],["org/mockito/stubbing/VoidAnswer4.html","914f8b4fa4859a05c22bc26e5884b868"],["org/mockito/stubbing/VoidAnswer5.html","01dfe8d3bf463ddfb9dbcad4eba9c3c9"],["org/mockito/stubbing/class-use/Answer.html","1bac953e1a0175559830bceeb2509382"],["org/mockito/stubbing/class-use/Answer1.html","8955e9aa0cddebbce3ae961d14ce8e1f"],["org/mockito/stubbing/class-use/Answer2.html","6e53b4de47730f6cffd29ac8097bddcf"],["org/mockito/stubbing/class-use/Answer3.html","49d633af54b8057b8a51e619bc9a3e09"],["org/mockito/stubbing/class-use/Answer4.html","cd77effeabde53aca881851bbccd2bef"],["org/mockito/stubbing/class-use/Answer5.html","c9140e6cd25b691559100848d01ef3cf"],["org/mockito/stubbing/class-use/OngoingStubbing.html","c4b295417b26fe54cde16fda923d4229"],["org/mockito/stubbing/class-use/Stubber.html","aa746b022139104d9b40fb1a710b69ef"],["org/mockito/stubbing/class-use/Stubbing.html","dc2a1eacb51ab9313f7e868f5e71e323"],["org/mockito/stubbing/class-use/ValidableAnswer.html","60517db67ac1934d86550ae00d036150"],["org/mockito/stubbing/class-use/VoidAnswer1.html","7a04db1beaf42e32ca476776096f7e4b"],["org/mockito/stubbing/class-use/VoidAnswer2.html","1bb1404ac1a4e900c151306212a18b72"],["org/mockito/stubbing/class-use/VoidAnswer3.html","247a86c57e21bc0c0f26ed970cb98912"],["org/mockito/stubbing/class-use/VoidAnswer4.html","d5609bb6084c5a094228ed53d1ba49e0"],["org/mockito/stubbing/class-use/VoidAnswer5.html","0f1c59c58a73d478ad2e48e05cb40e90"],["org/mockito/stubbing/package-frame.html","a439184b17b9dadc7ac3f8ae89a443c6"],["org/mockito/stubbing/package-summary.html","e3ab8438ba686c2573238030ca58a165"],["org/mockito/stubbing/package-tree.html","4c28c6ef7f5c435e135043b676ed38ad"],["org/mockito/stubbing/package-use.html","fe87c1d217777f0f9da203fa75fc52c7"],["org/mockito/verification/After.html","204169593c5b956207568fcb890e91f3"],["org/mockito/verification/Timeout.html","287a4a86ed39e991ce50fd0469f2e6d0"],["org/mockito/verification/VerificationAfterDelay.html","a5ebd6d355e43ad485297ea4b24d31ba"],["org/mockito/verification/VerificationEvent.html","d3cf03c5bebe72f05af0e17787673d4d"],["org/mockito/verification/VerificationMode.html","4ef5aa7623c1cf428c8e06974bb7bac9"],["org/mockito/verification/VerificationStrategy.html","d2f0c2f1804dbf0909304b782450a12a"],["org/mockito/verification/VerificationWithTimeout.html","241b91acfd4ac48b32b16442c1c24f0c"],["org/mockito/verification/class-use/After.html","44ae8cda7fe69afdb7d8180e13286b5e"],["org/mockito/verification/class-use/Timeout.html","33074141a0d3ccf6ff90c5b4a7a144a1"],["org/mockito/verification/class-use/VerificationAfterDelay.html","160fe3e5318c758531d3b3d376a9ad24"],["org/mockito/verification/class-use/VerificationEvent.html","2b2983b05b3c126624e9b92ab10d7644"],["org/mockito/verification/class-use/VerificationMode.html","1654bba7d13ebcb32fc0c8f71361cd50"],["org/mockito/verification/class-use/VerificationStrategy.html","0a7cf76f759adf8a18a0a23c3ccc7d17"],["org/mockito/verification/class-use/VerificationWithTimeout.html","75c843e2c3836417672c566985c8a089"],["org/mockito/verification/package-frame.html","49495374287b530be67b4e0c6cc2baf8"],["org/mockito/verification/package-summary.html","fc6409a2b05b99b3325968350c01edc4"],["org/mockito/verification/package-tree.html","d5971ff1fc597f7efe8b75a3fbc3053e"],["org/mockito/verification/package-use.html","f40796f35f718c3a24f2594938a45cc5"],["overview-frame.html","35f9f0d662f8c151de251be572b0354f"],["overview-summary.html","4c07d7ca771e0829073e48121ca7d169"],["overview-tree.html","10c053efb2735f6389ccb4f72501dc2f"],["script.js","4a010b8264c9873452f055748133bb29"],["serialized-form.html","14979d2c50b6466786d841f3c7191ad5"],["stylesheet.css","3dd9013d4309436be79cba586b6e5454"]];
var cacheName = 'sw-precache-v3-sw-precache-' + (self.registration ? self.registration.scope : '');


var ignoreUrlParametersMatching = [/^utm_/];



var addDirectoryIndex = function (originalUrl, index) {
    var url = new URL(originalUrl);
    if (url.pathname.slice(-1) === '/') {
      url.pathname += index;
    }
    return url.toString();
  };

var cleanResponse = function (originalResponse) {
    // If this is not a redirected response, then we don't have to do anything.
    if (!originalResponse.redirected) {
      return Promise.resolve(originalResponse);
    }

    // Firefox 50 and below doesn't support the Response.body stream, so we may
    // need to read the entire body to memory as a Blob.
    var bodyPromise = 'body' in originalResponse ?
      Promise.resolve(originalResponse.body) :
      originalResponse.blob();

    return bodyPromise.then(function(body) {
      // new Response() is happy when passed either a stream or a Blob.
      return new Response(body, {
        headers: originalResponse.headers,
        status: originalResponse.status,
        statusText: originalResponse.statusText
      });
    });
  };

var createCacheKey = function (originalUrl, paramName, paramValue,
                           dontCacheBustUrlsMatching) {
    // Create a new URL object to avoid modifying originalUrl.
    var url = new URL(originalUrl);

    // If dontCacheBustUrlsMatching is not set, or if we don't have a match,
    // then add in the extra cache-busting URL parameter.
    if (!dontCacheBustUrlsMatching ||
        !(url.pathname.match(dontCacheBustUrlsMatching))) {
      url.search += (url.search ? '&' : '') +
        encodeURIComponent(paramName) + '=' + encodeURIComponent(paramValue);
    }

    return url.toString();
  };

var isPathWhitelisted = function (whitelist, absoluteUrlString) {
    // If the whitelist is empty, then consider all URLs to be whitelisted.
    if (whitelist.length === 0) {
      return true;
    }

    // Otherwise compare each path regex to the path of the URL passed in.
    var path = (new URL(absoluteUrlString)).pathname;
    return whitelist.some(function(whitelistedPathRegex) {
      return path.match(whitelistedPathRegex);
    });
  };

var stripIgnoredUrlParameters = function (originalUrl,
    ignoreUrlParametersMatching) {
    var url = new URL(originalUrl);
    // Remove the hash; see https://github.com/GoogleChrome/sw-precache/issues/290
    url.hash = '';

    url.search = url.search.slice(1) // Exclude initial '?'
      .split('&') // Split into an array of 'key=value' strings
      .map(function(kv) {
        return kv.split('='); // Split each 'key=value' string into a [key, value] array
      })
      .filter(function(kv) {
        return ignoreUrlParametersMatching.every(function(ignoredRegex) {
          return !ignoredRegex.test(kv[0]); // Return true iff the key doesn't match any of the regexes.
        });
      })
      .map(function(kv) {
        return kv.join('='); // Join each [key, value] array into a 'key=value' string
      })
      .join('&'); // Join the array of 'key=value' strings into a string with '&' in between each

    return url.toString();
  };


var hashParamName = '_sw-precache';
var urlsToCacheKeys = new Map(
  precacheConfig.map(function(item) {
    var relativeUrl = item[0];
    var hash = item[1];
    var absoluteUrl = new URL(relativeUrl, self.location);
    var cacheKey = createCacheKey(absoluteUrl, hashParamName, hash, false);
    return [absoluteUrl.toString(), cacheKey];
  })
);

function setOfCachedUrls(cache) {
  return cache.keys().then(function(requests) {
    return requests.map(function(request) {
      return request.url;
    });
  }).then(function(urls) {
    return new Set(urls);
  });
}

self.addEventListener('install', function(event) {
  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return setOfCachedUrls(cache).then(function(cachedUrls) {
        return Promise.all(
          Array.from(urlsToCacheKeys.values()).map(function(cacheKey) {
            // If we don't have a key matching url in the cache already, add it.
            if (!cachedUrls.has(cacheKey)) {
              var request = new Request(cacheKey, {credentials: 'same-origin'});
              return fetch(request).then(function(response) {
                // Bail out of installation unless we get back a 200 OK for
                // every request.
                if (!response.ok) {
                  throw new Error('Request for ' + cacheKey + ' returned a ' +
                    'response with status ' + response.status);
                }

                return cleanResponse(response).then(function(responseToCache) {
                  return cache.put(cacheKey, responseToCache);
                });
              });
            }
          })
        );
      });
    }).then(function() {
      
      // Force the SW to transition from installing -> active state
      return self.skipWaiting();
      
    })
  );
});

self.addEventListener('activate', function(event) {
  var setOfExpectedUrls = new Set(urlsToCacheKeys.values());

  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return cache.keys().then(function(existingRequests) {
        return Promise.all(
          existingRequests.map(function(existingRequest) {
            if (!setOfExpectedUrls.has(existingRequest.url)) {
              return cache.delete(existingRequest);
            }
          })
        );
      });
    }).then(function() {
      
      return self.clients.claim();
      
    })
  );
});


self.addEventListener('fetch', function(event) {
  if (event.request.method === 'GET') {
    // Should we call event.respondWith() inside this fetch event handler?
    // This needs to be determined synchronously, which will give other fetch
    // handlers a chance to handle the request if need be.
    var shouldRespond;

    // First, remove all the ignored parameters and hash fragment, and see if we
    // have that URL in our cache. If so, great! shouldRespond will be true.
    var url = stripIgnoredUrlParameters(event.request.url, ignoreUrlParametersMatching);
    shouldRespond = urlsToCacheKeys.has(url);

    // If shouldRespond is false, check again, this time with 'index.html'
    // (or whatever the directoryIndex option is set to) at the end.
    var directoryIndex = 'index.html';
    if (!shouldRespond && directoryIndex) {
      url = addDirectoryIndex(url, directoryIndex);
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond is still false, check to see if this is a navigation
    // request, and if so, whether the URL matches navigateFallbackWhitelist.
    var navigateFallback = '';
    if (!shouldRespond &&
        navigateFallback &&
        (event.request.mode === 'navigate') &&
        isPathWhitelisted([], event.request.url)) {
      url = new URL(navigateFallback, self.location).toString();
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond was set to true at any point, then call
    // event.respondWith(), using the appropriate cache key.
    if (shouldRespond) {
      event.respondWith(
        caches.open(cacheName).then(function(cache) {
          return cache.match(urlsToCacheKeys.get(url)).then(function(response) {
            if (response) {
              return response;
            }
            throw Error('The cached response that was expected is missing.');
          });
        }).catch(function(e) {
          // Fall back to just fetch()ing the request if some unexpected error
          // prevented the cached response from being valid.
          console.warn('Couldn\'t serve response for "%s" from cache: %O', event.request.url, e);
          return fetch(event.request);
        })
      );
    }
  }
});







