/**
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

// DO NOT EDIT THIS GENERATED OUTPUT DIRECTLY!
// This file should be overwritten as part of your build process.
// If you need to extend the behavior of the generated service worker, the best approach is to write
// additional code and include it using the importScripts option:
//   https://github.com/GoogleChrome/sw-precache#importscripts-arraystring
//
// Alternatively, it's possible to make changes to the underlying template file and then use that as the
// new base for generating output, via the templateFilePath option:
//   https://github.com/GoogleChrome/sw-precache#templatefilepath-string
//
// If you go that route, make sure that whenever you update your sw-precache dependency, you reconcile any
// changes made to this original template file with your modified copy.

// This generated service worker JavaScript will precache your site's resources.
// The code needs to be saved in a .js file at the top-level of your site, and registered
// from your pages in order to be used. See
// https://github.com/googlechrome/sw-precache/blob/master/demo/app/js/service-worker-registration.js
// for an example of how you can register this script and handle various service worker events.

/* eslint-env worker, serviceworker */
/* eslint-disable indent, no-unused-vars, no-multiple-empty-lines, max-nested-callbacks, space-before-function-paren, quotes, comma-spacing */
'use strict';

var precacheConfig = [["allclasses-frame.html","96eb93e3882a2068e3c1045fada0575f"],["allclasses-noframe.html","827eb00e83b8c624d76289bcf4fb4f52"],["constant-values.html","35d3c38eb6356c83b946c055703cf445"],["deprecated-list.html","2bc15eba5788e324126db44844e7aef4"],["favicon.ico","05e61206186c2eee9054011bcf15b864"],["help-doc.html","be2b7fe6527fe9e4d3a8f7882c2e9f4b"],["index-files/index-1.html","43305f37bc504680f7df252ec6ec3afe"],["index-files/index-10.html","c57a41a4b18212bc31ef750c9905c295"],["index-files/index-11.html","3c559451cca552575f261f4033f30c8f"],["index-files/index-12.html","f8dddef85f61bbce956a6650a6af3798"],["index-files/index-13.html","6eb07c77c59d5193fba0129eab9cd54e"],["index-files/index-14.html","37390bb88b6ea386bd83fd4d6527a618"],["index-files/index-15.html","e4a35e4bcf7e52520257422522b6372e"],["index-files/index-16.html","15e76c1ccec36ab55df7eaa7fab532af"],["index-files/index-17.html","836894b481938b032ccf809fff88fa26"],["index-files/index-18.html","93df475ff25f829e0fd7a3238eb43248"],["index-files/index-19.html","dcce69650bfbbb9282885ec4eb7d98f9"],["index-files/index-2.html","ed739463220ea82ac087bfc3b2199669"],["index-files/index-20.html","72492871d40b487fe3650d48b58a4050"],["index-files/index-3.html","7c8060d3d4a43146fd1996a4d2c7ed7d"],["index-files/index-4.html","f004480c19aa9535946623dce1acedff"],["index-files/index-5.html","399ef48039c5c99b71aab32ba556a143"],["index-files/index-6.html","d9c66eb0e613d9e84c31884d6df2da86"],["index-files/index-7.html","5c93f55bb48d9b9431ca29f39b619599"],["index-files/index-8.html","7bc2325654d12be76891efd20b72079e"],["index-files/index-9.html","f37ece87a86635b90f939cd2d7ff6e54"],["index.html","c8769cbc7f6bb87ce1ea9dcfa1919c00"],["js/highlight-8.6-java/highlight.pack.js","deec56e4bb489b0ce943987284aac274"],["js/highlight-8.6-java/styles/obsidian.css","d60cd29c66c835762c95d2ce6da21142"],["js/index.js","dfc78156c8712ef6c546ea1037a604ef"],["js/jdk6-project-version-insert.js","ddee726b95840e7606e132d95c65ef27"],["js/jdk6-project-version-insert.min.js","a6a8d425f512ba0a8e2340504f134553"],["js/jquery-1.7.min.js","25721ced154b3a99e818431446d7506d"],["org/mockito/AdditionalAnswers.html","92a713ab5aeccde158ab1210f8697e14"],["org/mockito/AdditionalMatchers.html","3c84633abcab279a6ac9bb53040cf312"],["org/mockito/Answers.html","b12af457a07a5ad66fecb378cd64d089"],["org/mockito/ArgumentCaptor.html","0e4c92ccec324123faec2a2312c92db0"],["org/mockito/ArgumentMatcher.html","23fd43ab7a45a901a49ca0b0f0b152bf"],["org/mockito/ArgumentMatchers.html","9cbb5ed05001fb5e44a227830dfe8c89"],["org/mockito/BDDMockito.BDDMyOngoingStubbing.html","0deb1c91d37eecc84ae5ac81d96a6580"],["org/mockito/BDDMockito.BDDStubber.html","2cddc5cc10548a03ab024c9e9e89e1fb"],["org/mockito/BDDMockito.Then.html","b78fa48b41fe6a72927992a5e95b04b8"],["org/mockito/BDDMockito.html","6177bafe14242df7ffc1a2da5845b2f7"],["org/mockito/Captor.html","19aca80d1221b0a107583d7f84d6f6d3"],["org/mockito/InOrder.html","0b1a78c415b03ff1aee4430c3e2e3c24"],["org/mockito/Incubating.html","8919b9e6439b5f500ce02cdecc2d45fe"],["org/mockito/InjectMocks.html","3fc7c4c1c56707a2534ceace691e8c43"],["org/mockito/Matchers.html","d7b49cafbc9de1238724f12a6c303687"],["org/mockito/Mock.html","775f44088097bd0a0c9e6b61128c9283"],["org/mockito/MockSettings.html","b295f7e0e9e42487b944aa27582ec270"],["org/mockito/MockingDetails.html","f1bdabbde5d0dc7ad76d8009d60bdba3"],["org/mockito/Mockito.html","792adceb7715231e3b7433eef3ce6672"],["org/mockito/MockitoAnnotations.html","eba6db4de0b77cbeafbd2be9553ca645"],["org/mockito/MockitoDebugger.html","9c83eafc8fe74c8cb5b6d75ceed6ee9c"],["org/mockito/MockitoFramework.html","cdcdbf5c051876705b3068089a2c4f00"],["org/mockito/MockitoSession.html","56abfaa387468f9272f1f96fdc129c61"],["org/mockito/NotExtensible.html","538fe5749bfee543cbeedef866d16445"],["org/mockito/Spy.html","5d96564bf42d4907971b1748b9809216"],["org/mockito/class-use/AdditionalAnswers.html","8be9a9a8cd6fadd03d62963f22fdacc3"],["org/mockito/class-use/AdditionalMatchers.html","c34004a2f690d2c51f8c5cf571e755be"],["org/mockito/class-use/Answers.html","bc6eca0aabdd8c4d94917e0511239cc8"],["org/mockito/class-use/ArgumentCaptor.html","40eaed84c2d2f979d11ddc5128e2062d"],["org/mockito/class-use/ArgumentMatcher.html","ae5937c02ec7ef4f5229d38c6c193e5a"],["org/mockito/class-use/ArgumentMatchers.html","42f4ca4fd29d649a22dfe7bdbd622555"],["org/mockito/class-use/BDDMockito.BDDMyOngoingStubbing.html","02e058e63cdfbac03964e05f107d566c"],["org/mockito/class-use/BDDMockito.BDDStubber.html","bbb13234a2942a6bcd797877ff9cecee"],["org/mockito/class-use/BDDMockito.Then.html","b663577e1f6b33563f5b55299519a1ca"],["org/mockito/class-use/BDDMockito.html","e04cba97029dacf4b78f215d1d93e6de"],["org/mockito/class-use/Captor.html","f4ca11466fd1a27b881627277d3a9d6e"],["org/mockito/class-use/InOrder.html","ffb4c2c2da1f88bd64e9bc284476b194"],["org/mockito/class-use/Incubating.html","df4a1704f9ded99c8acb65e8111be186"],["org/mockito/class-use/InjectMocks.html","dcb24c8a31c70f473e58c638fde871cd"],["org/mockito/class-use/Matchers.html","d9e6974d75d904d59b74060c36db9a9a"],["org/mockito/class-use/Mock.html","47057237be6036499d196e0dbd6ba22d"],["org/mockito/class-use/MockSettings.html","c0c0964994188a879b8077667341d277"],["org/mockito/class-use/MockingDetails.html","0cfcb2ee25cd1bc3b328d16a0f7a6d93"],["org/mockito/class-use/Mockito.html","9a898b3943d44df6896072034288204c"],["org/mockito/class-use/MockitoAnnotations.html","8fe6853ea570e3ccf57d109f29bc05c4"],["org/mockito/class-use/MockitoDebugger.html","fa19eee83a330556e27448769c31a5c2"],["org/mockito/class-use/MockitoFramework.html","e284a4559c65dae76e6742221af8a721"],["org/mockito/class-use/MockitoSession.html","234df3528ae7b6e6476e127297882d26"],["org/mockito/class-use/NotExtensible.html","f4c7061e64d230025fd341a329d34d84"],["org/mockito/class-use/Spy.html","882fa2b1fcd31c6dbb09e016649280b7"],["org/mockito/configuration/AnnotationEngine.html","f863c51f58d6f4b26ee35374b7bca25d"],["org/mockito/configuration/DefaultMockitoConfiguration.html","a9c7bdc04719eedc9ca5ab1507bbeb28"],["org/mockito/configuration/IMockitoConfiguration.html","e3256dcb8e54f5c4b288c19bd271a97b"],["org/mockito/configuration/class-use/AnnotationEngine.html","2fd636ff8a8d68841c5e7a4e958619fa"],["org/mockito/configuration/class-use/DefaultMockitoConfiguration.html","8be6915c6f57932b4c3232c46b9860ee"],["org/mockito/configuration/class-use/IMockitoConfiguration.html","59085154f3fd01919c893e0731e3301f"],["org/mockito/configuration/package-frame.html","3d6799e70e4004ccd268e3136dbe5613"],["org/mockito/configuration/package-summary.html","37c3fd820242b8b621b3633a1b402972"],["org/mockito/configuration/package-tree.html","39179d5a9bb72271afd44fd7459d1dc6"],["org/mockito/configuration/package-use.html","661177d7c938d0c2692613c97786cf8d"],["org/mockito/exceptions/base/MockitoAssertionError.html","bf0b22d09e5d8baa51d4fbe07444c9f2"],["org/mockito/exceptions/base/MockitoException.html","6a16c3140d42c27f9a34d075dca63010"],["org/mockito/exceptions/base/MockitoInitializationException.html","e287496d70cea0aa803f8907cae4b3d0"],["org/mockito/exceptions/base/MockitoSerializationIssue.html","84cf9b55541b269f1822b5a02bf2b5f6"],["org/mockito/exceptions/base/class-use/MockitoAssertionError.html","483fd1c0fc5a9ff06bc4493fa4876829"],["org/mockito/exceptions/base/class-use/MockitoException.html","093fdd0c2eb4b2d1d1639d0480d95381"],["org/mockito/exceptions/base/class-use/MockitoInitializationException.html","e315fb4232a7a017a0ab50dcfb5e554a"],["org/mockito/exceptions/base/class-use/MockitoSerializationIssue.html","c999f683005d02842b3716f7e2a296b1"],["org/mockito/exceptions/base/package-frame.html","84e9ae156d7efceb72d96dea15bc6872"],["org/mockito/exceptions/base/package-summary.html","a8c27a041a32027b4b08f96c2d39edbb"],["org/mockito/exceptions/base/package-tree.html","35dc2c68f80b861a3775576cda977881"],["org/mockito/exceptions/base/package-use.html","42d50c23f21f0a4996d7a7dc4b222aa3"],["org/mockito/exceptions/misusing/CannotStubVoidMethodWithReturnValue.html","971bcdd80c42dee5b2866b80cb5760e6"],["org/mockito/exceptions/misusing/CannotVerifyStubOnlyMock.html","3bf07123f6e6a26b7507e1aa35470f75"],["org/mockito/exceptions/misusing/FriendlyReminderException.html","4c8fa9f8611f1a91d11b0e1b2dca1896"],["org/mockito/exceptions/misusing/InvalidUseOfMatchersException.html","2fe5f3e44e56162b4a7663184c37cfad"],["org/mockito/exceptions/misusing/MissingMethodInvocationException.html","226aa38cd8d178c45928abe2bc1bf425"],["org/mockito/exceptions/misusing/MockitoConfigurationException.html","aa5a3de78cbe8fa3fc836ee41bc7fba5"],["org/mockito/exceptions/misusing/NotAMockException.html","d73cff2593fb8889ffc2cd898f5f1ad3"],["org/mockito/exceptions/misusing/NullInsteadOfMockException.html","5dacc1feb19c10455129a0dc8c35f853"],["org/mockito/exceptions/misusing/PotentialStubbingProblem.html","e21fd7a09fd5381db48ddc53b486d0e9"],["org/mockito/exceptions/misusing/RedundantListenerException.html","6aaab31b233f11669d477557cf1e518f"],["org/mockito/exceptions/misusing/UnfinishedMockingSessionException.html","08e3c52d8be6d9422b61e9718c995fef"],["org/mockito/exceptions/misusing/UnfinishedStubbingException.html","5bbece768d3f9a170c03c73c58b97596"],["org/mockito/exceptions/misusing/UnfinishedVerificationException.html","9adee86eeb112f7f4f212b63fe62c597"],["org/mockito/exceptions/misusing/UnnecessaryStubbingException.html","ec53245ceb5fe3fe61207002c79b5997"],["org/mockito/exceptions/misusing/WrongTypeOfReturnValue.html","13e74c052807b4d5296ee51b33a9012c"],["org/mockito/exceptions/misusing/class-use/CannotStubVoidMethodWithReturnValue.html","ee5654cb4c645e23e48fae87840df648"],["org/mockito/exceptions/misusing/class-use/CannotVerifyStubOnlyMock.html","9a2eb55846f8eeba47bfc18cfa510d62"],["org/mockito/exceptions/misusing/class-use/FriendlyReminderException.html","97ca0a7ee9d91ade2f81d45f39d4bd91"],["org/mockito/exceptions/misusing/class-use/InvalidUseOfMatchersException.html","5c0e770fa56393d494c5e4a5b14ccbae"],["org/mockito/exceptions/misusing/class-use/MissingMethodInvocationException.html","fdac35af827a5904c9b8cdeb98602afd"],["org/mockito/exceptions/misusing/class-use/MockitoConfigurationException.html","f25b0580c24198e9d7a0ce243965d4ec"],["org/mockito/exceptions/misusing/class-use/NotAMockException.html","9e654262da6ad34273c5bbee9fb9c16f"],["org/mockito/exceptions/misusing/class-use/NullInsteadOfMockException.html","be574e6a81d131ba9873c220c2b5af82"],["org/mockito/exceptions/misusing/class-use/PotentialStubbingProblem.html","620419f306886d36bb1a5681233e2030"],["org/mockito/exceptions/misusing/class-use/RedundantListenerException.html","069c823a59df9ae779e4b831ab1dd586"],["org/mockito/exceptions/misusing/class-use/UnfinishedMockingSessionException.html","61f7211905b1c6a36591f8c8f53c8910"],["org/mockito/exceptions/misusing/class-use/UnfinishedStubbingException.html","c922f59e24fb4810eccfb134f754fb8f"],["org/mockito/exceptions/misusing/class-use/UnfinishedVerificationException.html","c346d94235afd703f58ca08a773e4d59"],["org/mockito/exceptions/misusing/class-use/UnnecessaryStubbingException.html","e65d4b573ae313ce76f779b7070ba258"],["org/mockito/exceptions/misusing/class-use/WrongTypeOfReturnValue.html","9b062a529aaa3f41bfd787c66df210a2"],["org/mockito/exceptions/misusing/package-frame.html","f9c6b7d8c73307ee903b3a21e2e6ca4d"],["org/mockito/exceptions/misusing/package-summary.html","6c630d36aa791188acbc80adf5996cba"],["org/mockito/exceptions/misusing/package-tree.html","493430fef19af51638814c385d8b029a"],["org/mockito/exceptions/misusing/package-use.html","92092b59bed4d26190f159028371948b"],["org/mockito/exceptions/stacktrace/StackTraceCleaner.html","de124ed4c75aeb3d0749696055f5aa5c"],["org/mockito/exceptions/stacktrace/class-use/StackTraceCleaner.html","0e10a45db48e3f8a8587767de8a987b9"],["org/mockito/exceptions/stacktrace/package-frame.html","82f6ac5830827e0cda13d5c444cecfa8"],["org/mockito/exceptions/stacktrace/package-summary.html","65f7d1112e3fc677ff13aa7f43deaf86"],["org/mockito/exceptions/stacktrace/package-tree.html","4d257efbfba24712d7695b227a37f7a4"],["org/mockito/exceptions/stacktrace/package-use.html","da1a31619377d50cfa5e3cd287852a55"],["org/mockito/exceptions/verification/ArgumentsAreDifferent.html","33e29fa11229b8aaeb29f10c7ca437ab"],["org/mockito/exceptions/verification/NeverWantedButInvoked.html","199c330a3ae73046d1086ff16123c122"],["org/mockito/exceptions/verification/NoInteractionsWanted.html","0238a3c5d840b30c6dad446a830f7307"],["org/mockito/exceptions/verification/SmartNullPointerException.html","406b77a804b46e93188d9163aa94b93d"],["org/mockito/exceptions/verification/TooLittleActualInvocations.html","7468ee2854ef6bd88ad0b69ec99f8853"],["org/mockito/exceptions/verification/TooManyActualInvocations.html","e015297c3d5204d521020e8284636a3b"],["org/mockito/exceptions/verification/VerificationInOrderFailure.html","dd25848cc44d4788d63aed981ecacc73"],["org/mockito/exceptions/verification/WantedButNotInvoked.html","1d82a6d7da3718582e5c0743d3aed529"],["org/mockito/exceptions/verification/class-use/ArgumentsAreDifferent.html","34553f2ecd3ae8a0c3f3dc66a40ce1e0"],["org/mockito/exceptions/verification/class-use/NeverWantedButInvoked.html","37b8ee12fa998201947d9134c9f33414"],["org/mockito/exceptions/verification/class-use/NoInteractionsWanted.html","8a565f3482bfdb0fe30294647b890234"],["org/mockito/exceptions/verification/class-use/SmartNullPointerException.html","4ba17c1788280612080577f082178077"],["org/mockito/exceptions/verification/class-use/TooLittleActualInvocations.html","32b75af86ca3988631678328192994da"],["org/mockito/exceptions/verification/class-use/TooManyActualInvocations.html","cce08ad412af71d6e097a4649cadc781"],["org/mockito/exceptions/verification/class-use/VerificationInOrderFailure.html","1689eb18d50aa7c928e8124e8c4d318f"],["org/mockito/exceptions/verification/class-use/WantedButNotInvoked.html","e3ab6a709186b0f9367fedc601e12a77"],["org/mockito/exceptions/verification/junit/ArgumentsAreDifferent.html","1fb0c159567144b4a977eea673d750d7"],["org/mockito/exceptions/verification/junit/class-use/ArgumentsAreDifferent.html","4310762ae7c41a3b31190c925b32ae03"],["org/mockito/exceptions/verification/junit/package-frame.html","fde3098af75a559c453370504e0bfda0"],["org/mockito/exceptions/verification/junit/package-summary.html","c351d23b7660537db1f069c4c3235182"],["org/mockito/exceptions/verification/junit/package-tree.html","3f64eff1fadd099e7f44bbba13b5b6fe"],["org/mockito/exceptions/verification/junit/package-use.html","66a14f8b45decd4489b699d075ff86a7"],["org/mockito/exceptions/verification/package-frame.html","3d1412dff9fbc3bbe98abc296a8d00f6"],["org/mockito/exceptions/verification/package-summary.html","2e084cdb964099aeb0ccec996b8ecbb8"],["org/mockito/exceptions/verification/package-tree.html","6a0e39f45d0ccbf8e23031a804ac42ee"],["org/mockito/exceptions/verification/package-use.html","338ca3c0fa2b397910ecd066a26e5b0d"],["org/mockito/hamcrest/MockitoHamcrest.html","2709f57c90ff3e1821669b641e8f1e36"],["org/mockito/hamcrest/class-use/MockitoHamcrest.html","eebd369c37a210092d05b1ea6f5f722a"],["org/mockito/hamcrest/package-frame.html","ca13774aa131885d769150a6bffc0411"],["org/mockito/hamcrest/package-summary.html","64e841c3358e1432aed3f0a13dd092a6"],["org/mockito/hamcrest/package-tree.html","64a001816fce29d2de5e5919c6a178de"],["org/mockito/hamcrest/package-use.html","2ffba0138510767eb6e6cc9b6469c54b"],["org/mockito/invocation/DescribedInvocation.html","423e53c16e3a938dc0477b806319bd8e"],["org/mockito/invocation/Invocation.html","21c17289c153476bdfd85f4ad9e852b7"],["org/mockito/invocation/InvocationContainer.html","64a0459bc85f7c98a5ad4c0c1b663bad"],["org/mockito/invocation/InvocationFactory.html","896e968d7105ecb680a9e5d7cf1c7df3"],["org/mockito/invocation/InvocationOnMock.html","f1443f41b21d190335afde08be505a61"],["org/mockito/invocation/Location.html","def03baa6c515512937183af3cec705e"],["org/mockito/invocation/MatchableInvocation.html","81af86f0040a805f38b1dfe79fb16cbc"],["org/mockito/invocation/MockHandler.html","90b3137befb70191070f19a7f93f79e0"],["org/mockito/invocation/StubInfo.html","822fe48cfac32c2706c0729cac2586c8"],["org/mockito/invocation/class-use/DescribedInvocation.html","b203c7fa74bb63e67448c7b152048573"],["org/mockito/invocation/class-use/Invocation.html","6833678cb73926c43ecf41b740b27353"],["org/mockito/invocation/class-use/InvocationContainer.html","23b517768263b706fe3a51f1863f8219"],["org/mockito/invocation/class-use/InvocationFactory.html","7f45b9bad4c7df8e6844e52771005bc2"],["org/mockito/invocation/class-use/InvocationOnMock.html","aba31d5a709c4884a9b98a9ee7b585e7"],["org/mockito/invocation/class-use/Location.html","783288661e2b7cf53521146396151a18"],["org/mockito/invocation/class-use/MatchableInvocation.html","1a6adc6195b6795f50bf10a56c7b11fe"],["org/mockito/invocation/class-use/MockHandler.html","2ce86faa91487234942e10a262446d6e"],["org/mockito/invocation/class-use/StubInfo.html","9553ee4672523ec3ec065a20e40dc93e"],["org/mockito/invocation/package-frame.html","058df6bffc8888991696270fb37affe4"],["org/mockito/invocation/package-summary.html","3126d70b32029d8a98223b945f28ba35"],["org/mockito/invocation/package-tree.html","316e9e7c9288ad9708b16e0207d58e95"],["org/mockito/invocation/package-use.html","dc2be40acc7fc08a7b1a23240d648dc2"],["org/mockito/junit/MockitoJUnit.html","95de2d99adafe164892b1dc3a0adfc4f"],["org/mockito/junit/MockitoJUnitRunner.Silent.html","5214c12e685a365f461788f3701efe0f"],["org/mockito/junit/MockitoJUnitRunner.Strict.html","292f799161376d5ca8fa5613a0414ff7"],["org/mockito/junit/MockitoJUnitRunner.StrictStubs.html","93b2d4fd6a842151e13e1eec238c3d6a"],["org/mockito/junit/MockitoJUnitRunner.html","d8ec5c55add2afcacdb739c3f9036f4a"],["org/mockito/junit/MockitoRule.html","776ac2d6df4027c9c10364237176471a"],["org/mockito/junit/VerificationCollector.html","08748a2333e2ee082e20ab95320e1fca"],["org/mockito/junit/class-use/MockitoJUnit.html","e428d8998511fce22e9e3a1c1f0954b4"],["org/mockito/junit/class-use/MockitoJUnitRunner.Silent.html","f787799ee7a4cc3ff65db1968e105474"],["org/mockito/junit/class-use/MockitoJUnitRunner.Strict.html","10601850c3044cbcfa09f57463ca4891"],["org/mockito/junit/class-use/MockitoJUnitRunner.StrictStubs.html","601598d5dc49dfa8300768b92bdc1e5e"],["org/mockito/junit/class-use/MockitoJUnitRunner.html","53da745814786ebd380ffae57beee16d"],["org/mockito/junit/class-use/MockitoRule.html","8b2fbb3c88c8726b800c6483896bec60"],["org/mockito/junit/class-use/VerificationCollector.html","085894047f57c5b6f8c3bb5a7ee38e91"],["org/mockito/junit/package-frame.html","4362422776da9ae068e64b46f434678f"],["org/mockito/junit/package-summary.html","13105efcc60c232695c1153349663bbf"],["org/mockito/junit/package-tree.html","3f15dc57178d79f10d28ae1bda3e53e7"],["org/mockito/junit/package-use.html","2957aa2c502a670b1a9c703b2ae8a3bd"],["org/mockito/listeners/InvocationListener.html","838ad85624f780ad1e3541804728b6e3"],["org/mockito/listeners/MethodInvocationReport.html","3f0addc2faead4c094bdd4db6a9779f0"],["org/mockito/listeners/MockCreationListener.html","f92de229346f9e314efa45a0756a2a07"],["org/mockito/listeners/MockitoListener.html","05c84d7bbe0f60df680a1a77ac68176c"],["org/mockito/listeners/VerificationListener.html","e827e3cbbbdc2fc87a2efbb61da4a6d7"],["org/mockito/listeners/VerificationStartedEvent.html","b94ce31747eb3da00eda8e109c07cf64"],["org/mockito/listeners/VerificationStartedListener.html","389d677575d227a01d0a286201560cb1"],["org/mockito/listeners/class-use/InvocationListener.html","66505c089de7352f2f9acffd1c3651d0"],["org/mockito/listeners/class-use/MethodInvocationReport.html","2eb06382073930b2364b48ace04519fa"],["org/mockito/listeners/class-use/MockCreationListener.html","b211d1585c0a97eaff1ebb866abb1e33"],["org/mockito/listeners/class-use/MockitoListener.html","afa285697f1dac6f6ae97b4ddd39efde"],["org/mockito/listeners/class-use/VerificationListener.html","39290cfce93347a5d5d1d43181b48eb9"],["org/mockito/listeners/class-use/VerificationStartedEvent.html","7b38f6a7183c367bb5ad5ea8f57efc3a"],["org/mockito/listeners/class-use/VerificationStartedListener.html","250ef59d95d0dbbb2cd8d3708a21c511"],["org/mockito/listeners/package-frame.html","e8377df0f23480bece1fe228ff4d00eb"],["org/mockito/listeners/package-summary.html","fd8c3598a45762ca7957744bc5076df7"],["org/mockito/listeners/package-tree.html","c1dda7e5c0b9c815428254653f404031"],["org/mockito/listeners/package-use.html","a6ae2694c71479e0475d68f28425bf86"],["org/mockito/mock/MockCreationSettings.html","e6ca67201ec994801a1b751d3e18662b"],["org/mockito/mock/MockName.html","6ed58d7026ab61cc66f01c082e90c72f"],["org/mockito/mock/SerializableMode.html","57ec23705b83d12c894b699a291d92d1"],["org/mockito/mock/class-use/MockCreationSettings.html","adad02bdde7151a21382092e8702c4d6"],["org/mockito/mock/class-use/MockName.html","aa786f6dc98fdc06920d7f0867054878"],["org/mockito/mock/class-use/SerializableMode.html","1adf849ed33c39984a1a457601585858"],["org/mockito/mock/package-frame.html","94be44fa354a4031fc0567b7167b239b"],["org/mockito/mock/package-summary.html","6ea4b86985d11bd63835cb2c551c620a"],["org/mockito/mock/package-tree.html","ac14c760e18b4f14882de8bb8b6e2c33"],["org/mockito/mock/package-use.html","40c758bd5c4bd0d528725174087deed2"],["org/mockito/package-frame.html","ff46092bd9b59f36ddac7d774660c073"],["org/mockito/package-summary.html","9d446399346e55f69ad3db86c66cb6e8"],["org/mockito/package-tree.html","90432264939c0c89f01a4038be14f2d5"],["org/mockito/package-use.html","69ea5f7caca98b9aed5b133d8ee0369c"],["org/mockito/plugins/AnnotationEngine.html","afd9a487dfcf84ac7ffc05bb0b1118e7"],["org/mockito/plugins/InstantiatorProvider.html","197e9134107a91720e1141d688696b2e"],["org/mockito/plugins/MockMaker.TypeMockability.html","d173d7b35b32015aff383e6f2c000e26"],["org/mockito/plugins/MockMaker.html","42f0ce155934b2440083d49fffeb8e94"],["org/mockito/plugins/MockitoPlugins.html","24b085e2fb02f9b63b7c56a2871979fd"],["org/mockito/plugins/PluginSwitch.html","f392c8e8280a7e55b6019ddb27034d11"],["org/mockito/plugins/StackTraceCleanerProvider.html","6f685f13b9fb43b91843be533e1be73c"],["org/mockito/plugins/class-use/AnnotationEngine.html","ae3b1718a019a0c72fbf743b22363c83"],["org/mockito/plugins/class-use/InstantiatorProvider.html","f5592efd7fdbcc8f83522ebdd81d411e"],["org/mockito/plugins/class-use/MockMaker.TypeMockability.html","381b3e151fe9e8b656020168886d8a39"],["org/mockito/plugins/class-use/MockMaker.html","3536c664bd43eabd74c4782ef3b08e72"],["org/mockito/plugins/class-use/MockitoPlugins.html","ee895d456f9b48c31a0c8c4a35fed51b"],["org/mockito/plugins/class-use/PluginSwitch.html","1d56bd92109eb6d5fe1bae2b158ea993"],["org/mockito/plugins/class-use/StackTraceCleanerProvider.html","75efe4ec1de06042c47c503abc61ac18"],["org/mockito/plugins/package-frame.html","68d554b714e69e08284f056e52478b60"],["org/mockito/plugins/package-summary.html","743e33a06d7ffbbc11665d657621f8da"],["org/mockito/plugins/package-tree.html","fef85750041afa20c932c4bd0039df34"],["org/mockito/plugins/package-use.html","bd6a20df3c067bf5bccfd41df9d08bb3"],["org/mockito/quality/MockitoHint.html","117bab83d64ce79306e67032ad4f9f4d"],["org/mockito/quality/Strictness.html","069f78d522ed6f936694444c18497865"],["org/mockito/quality/class-use/MockitoHint.html","185f14e1d96683fb5a207fedb8cc5491"],["org/mockito/quality/class-use/Strictness.html","7eb9ebe0e05ae3d586a0dd54e12a71d8"],["org/mockito/quality/package-frame.html","a4c342241652f756d632ecec3141e68f"],["org/mockito/quality/package-summary.html","a04686e45d60089ddafafe07f48ac6ad"],["org/mockito/quality/package-tree.html","890b2608369c1eb0632cdd4fd5a05853"],["org/mockito/quality/package-use.html","2975f0b26ca7042c6a530255033b42cf"],["org/mockito/runners/ConsoleSpammingMockitoJUnitRunner.html","71d40f87c2cff6436a3e4d24464e4e8b"],["org/mockito/runners/MockitoJUnitRunner.Silent.html","6e9beae281b11eb01213f0338258d6b2"],["org/mockito/runners/MockitoJUnitRunner.Strict.html","1c8f7c226f62e947994432cb6eae7da2"],["org/mockito/runners/MockitoJUnitRunner.html","ee7006099f1683526c99c28a351ce473"],["org/mockito/runners/VerboseMockitoJUnitRunner.html","0da0ec116006779edd918ce90cd71bf9"],["org/mockito/runners/class-use/ConsoleSpammingMockitoJUnitRunner.html","9fd726b9c258d8cf7871a13dfcaba827"],["org/mockito/runners/class-use/MockitoJUnitRunner.Silent.html","ea2e6971fdb15d575152ff1a7624b17e"],["org/mockito/runners/class-use/MockitoJUnitRunner.Strict.html","6aea9bdbc612ba099f6b665d451646d5"],["org/mockito/runners/class-use/MockitoJUnitRunner.html","fb145a1be6bfe34d35e22a82e7dec09b"],["org/mockito/runners/class-use/VerboseMockitoJUnitRunner.html","c1adff04dd861101758f7799ea7c3bdd"],["org/mockito/runners/package-frame.html","4c8da31d200bf29237a655b0b561ffd7"],["org/mockito/runners/package-summary.html","0908337bbc6d3e7058df6a5c0e969fe5"],["org/mockito/runners/package-tree.html","62db77cd9a43757d4074e81ab122eb7f"],["org/mockito/runners/package-use.html","bc0bcd81733ddc0f20361b4fa24db5e8"],["org/mockito/session/MockitoSessionBuilder.html","2b3b858bf56332aae53052d881ab27c7"],["org/mockito/session/class-use/MockitoSessionBuilder.html","21b969c5e4fa68c8f97d3e7e650848c6"],["org/mockito/session/package-frame.html","d27e3f1e235789905750b126b09defff"],["org/mockito/session/package-summary.html","4e08e32afa13aa236be2b7782841e8ee"],["org/mockito/session/package-tree.html","3d784d9cb8ba5c0252aca363dabd8a31"],["org/mockito/session/package-use.html","b39bc3bcd5a0cfb016d904bb90ae920f"],["org/mockito/stubbing/Answer.html","8c87f398ac9fd7fc7ab7e7cdce1e57d8"],["org/mockito/stubbing/Answer1.html","2dbbefb65d9a8a9bb2cd85019ebdadb7"],["org/mockito/stubbing/Answer2.html","f8d3dc1a841bf46e5f16b847be7220e3"],["org/mockito/stubbing/Answer3.html","2c53a134f5bc34b62afed3e701f0bfc4"],["org/mockito/stubbing/Answer4.html","9cda18867c70b9dfaca199bd7b97dbdf"],["org/mockito/stubbing/Answer5.html","0db95eb859c8d7c65acff9adc36e1bcd"],["org/mockito/stubbing/OngoingStubbing.html","db8668f34b6cde2204382f70bcb217f8"],["org/mockito/stubbing/Stubber.html","8382026b6df9085cb03ebc5386d7fc3f"],["org/mockito/stubbing/Stubbing.html","8246ae2f796706fc9e4941d12be6dfae"],["org/mockito/stubbing/ValidableAnswer.html","aa8e37695b0454f81b02fbd38b5381aa"],["org/mockito/stubbing/VoidAnswer1.html","36ad8fcbb3c69db75bb39f134ab4bd20"],["org/mockito/stubbing/VoidAnswer2.html","a019045b971393ea06e1169bce7108f3"],["org/mockito/stubbing/VoidAnswer3.html","1aaa33f7e768c56968795fe5145d9381"],["org/mockito/stubbing/VoidAnswer4.html","19483cc43a4976d5269697dece18d23b"],["org/mockito/stubbing/VoidAnswer5.html","46ec2b0c3425d88748b5d409d34a0e3e"],["org/mockito/stubbing/class-use/Answer.html","7c33a6c0af4e0632dd59f6298b436689"],["org/mockito/stubbing/class-use/Answer1.html","f6d2609e02bef94286c489acde1362d5"],["org/mockito/stubbing/class-use/Answer2.html","eacd7f817234858103c5a35a5dad0d7f"],["org/mockito/stubbing/class-use/Answer3.html","ac44925dcbf8489a1f5b6d83b5c140cc"],["org/mockito/stubbing/class-use/Answer4.html","a9a8c064984836185d648415e0154ee5"],["org/mockito/stubbing/class-use/Answer5.html","230c79af10660898dc49220bc884e7d0"],["org/mockito/stubbing/class-use/OngoingStubbing.html","674ff57dd420d0f86ebc414b4a0ae3b2"],["org/mockito/stubbing/class-use/Stubber.html","41d238b2c7eedf5f43579024aaebdb8e"],["org/mockito/stubbing/class-use/Stubbing.html","b684273bae486e54a1262dcb971b53fd"],["org/mockito/stubbing/class-use/ValidableAnswer.html","63f84e2224a95194ad0f3f97f0bab8d6"],["org/mockito/stubbing/class-use/VoidAnswer1.html","1dfff92259cefcf2548d9a28355fe9bf"],["org/mockito/stubbing/class-use/VoidAnswer2.html","14824ebe626280f526ae2b91373f2704"],["org/mockito/stubbing/class-use/VoidAnswer3.html","5c04e4529c5a38f40ca46c8625db1cf8"],["org/mockito/stubbing/class-use/VoidAnswer4.html","c49e0ec76d5ff80693a9591a6df25ed5"],["org/mockito/stubbing/class-use/VoidAnswer5.html","97090c94d937dc34e721dd814cfb2118"],["org/mockito/stubbing/package-frame.html","0a54fa90ebd3c599099e085343764019"],["org/mockito/stubbing/package-summary.html","05c120b6758c2b20c60e405524f73f1e"],["org/mockito/stubbing/package-tree.html","3421cfbbae433d1fffc23e7cc55131aa"],["org/mockito/stubbing/package-use.html","2bc7b339d1ad19d07b18a1fbaa6aec34"],["org/mockito/verification/After.html","c741f6560eb0edecd0ed75bed55e4515"],["org/mockito/verification/Timeout.html","70dc88a29e4734a163b3c75c43272bf9"],["org/mockito/verification/VerificationAfterDelay.html","4c64ab6a680c547e0728548b60e54c3a"],["org/mockito/verification/VerificationEvent.html","0ccd9b4a2818ae8eb67431c09c1c3891"],["org/mockito/verification/VerificationMode.html","4361a54ddb92ceb3a0543902f9bbd4e5"],["org/mockito/verification/VerificationStrategy.html","1b9913d3704b39e333b19af8c2ca8c6b"],["org/mockito/verification/VerificationWithTimeout.html","2005058102ec6223f4c4f72ff688bc6b"],["org/mockito/verification/class-use/After.html","cc6e1dfd2c9065970d61a2cb8511ce94"],["org/mockito/verification/class-use/Timeout.html","493bc288613bfed35db6a64844150a1c"],["org/mockito/verification/class-use/VerificationAfterDelay.html","916cf764b5a905398b7ca766a3f3b212"],["org/mockito/verification/class-use/VerificationEvent.html","4c88b373c686866ce3a982e938e3bfba"],["org/mockito/verification/class-use/VerificationMode.html","29eb4284c99c262a2fb7894b0695de61"],["org/mockito/verification/class-use/VerificationStrategy.html","c83e2c82276b0fb30ad5b0d307da91e7"],["org/mockito/verification/class-use/VerificationWithTimeout.html","9002ca325ac26b0993719c49f77b1dad"],["org/mockito/verification/package-frame.html","bb2e3d109a519c0252abad88f28c4d92"],["org/mockito/verification/package-summary.html","fd3ffe931cf101599309342e2d268bef"],["org/mockito/verification/package-tree.html","b857db7146f7df15bf170b99a56c7a0d"],["org/mockito/verification/package-use.html","fd9801c863598bc1aa8926fcd9e8709d"],["overview-frame.html","d4a70d2addbd8737e3453fb2e6624681"],["overview-summary.html","d3e0416fdc767cd39c88c3e96a92143e"],["overview-tree.html","ab5861c91d412315c604b6c59ec6f62d"],["script.js","4a010b8264c9873452f055748133bb29"],["serialized-form.html","63fc2ca2676da9b5ae474a64296463a2"],["stylesheet.css","3dd9013d4309436be79cba586b6e5454"]];
var cacheName = 'sw-precache-v3-sw-precache-' + (self.registration ? self.registration.scope : '');


var ignoreUrlParametersMatching = [/^utm_/];



var addDirectoryIndex = function (originalUrl, index) {
    var url = new URL(originalUrl);
    if (url.pathname.slice(-1) === '/') {
      url.pathname += index;
    }
    return url.toString();
  };

var cleanResponse = function (originalResponse) {
    // If this is not a redirected response, then we don't have to do anything.
    if (!originalResponse.redirected) {
      return Promise.resolve(originalResponse);
    }

    // Firefox 50 and below doesn't support the Response.body stream, so we may
    // need to read the entire body to memory as a Blob.
    var bodyPromise = 'body' in originalResponse ?
      Promise.resolve(originalResponse.body) :
      originalResponse.blob();

    return bodyPromise.then(function(body) {
      // new Response() is happy when passed either a stream or a Blob.
      return new Response(body, {
        headers: originalResponse.headers,
        status: originalResponse.status,
        statusText: originalResponse.statusText
      });
    });
  };

var createCacheKey = function (originalUrl, paramName, paramValue,
                           dontCacheBustUrlsMatching) {
    // Create a new URL object to avoid modifying originalUrl.
    var url = new URL(originalUrl);

    // If dontCacheBustUrlsMatching is not set, or if we don't have a match,
    // then add in the extra cache-busting URL parameter.
    if (!dontCacheBustUrlsMatching ||
        !(url.pathname.match(dontCacheBustUrlsMatching))) {
      url.search += (url.search ? '&' : '') +
        encodeURIComponent(paramName) + '=' + encodeURIComponent(paramValue);
    }

    return url.toString();
  };

var isPathWhitelisted = function (whitelist, absoluteUrlString) {
    // If the whitelist is empty, then consider all URLs to be whitelisted.
    if (whitelist.length === 0) {
      return true;
    }

    // Otherwise compare each path regex to the path of the URL passed in.
    var path = (new URL(absoluteUrlString)).pathname;
    return whitelist.some(function(whitelistedPathRegex) {
      return path.match(whitelistedPathRegex);
    });
  };

var stripIgnoredUrlParameters = function (originalUrl,
    ignoreUrlParametersMatching) {
    var url = new URL(originalUrl);
    // Remove the hash; see https://github.com/GoogleChrome/sw-precache/issues/290
    url.hash = '';

    url.search = url.search.slice(1) // Exclude initial '?'
      .split('&') // Split into an array of 'key=value' strings
      .map(function(kv) {
        return kv.split('='); // Split each 'key=value' string into a [key, value] array
      })
      .filter(function(kv) {
        return ignoreUrlParametersMatching.every(function(ignoredRegex) {
          return !ignoredRegex.test(kv[0]); // Return true iff the key doesn't match any of the regexes.
        });
      })
      .map(function(kv) {
        return kv.join('='); // Join each [key, value] array into a 'key=value' string
      })
      .join('&'); // Join the array of 'key=value' strings into a string with '&' in between each

    return url.toString();
  };


var hashParamName = '_sw-precache';
var urlsToCacheKeys = new Map(
  precacheConfig.map(function(item) {
    var relativeUrl = item[0];
    var hash = item[1];
    var absoluteUrl = new URL(relativeUrl, self.location);
    var cacheKey = createCacheKey(absoluteUrl, hashParamName, hash, false);
    return [absoluteUrl.toString(), cacheKey];
  })
);

function setOfCachedUrls(cache) {
  return cache.keys().then(function(requests) {
    return requests.map(function(request) {
      return request.url;
    });
  }).then(function(urls) {
    return new Set(urls);
  });
}

self.addEventListener('install', function(event) {
  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return setOfCachedUrls(cache).then(function(cachedUrls) {
        return Promise.all(
          Array.from(urlsToCacheKeys.values()).map(function(cacheKey) {
            // If we don't have a key matching url in the cache already, add it.
            if (!cachedUrls.has(cacheKey)) {
              var request = new Request(cacheKey, {credentials: 'same-origin'});
              return fetch(request).then(function(response) {
                // Bail out of installation unless we get back a 200 OK for
                // every request.
                if (!response.ok) {
                  throw new Error('Request for ' + cacheKey + ' returned a ' +
                    'response with status ' + response.status);
                }

                return cleanResponse(response).then(function(responseToCache) {
                  return cache.put(cacheKey, responseToCache);
                });
              });
            }
          })
        );
      });
    }).then(function() {
      
      // Force the SW to transition from installing -> active state
      return self.skipWaiting();
      
    })
  );
});

self.addEventListener('activate', function(event) {
  var setOfExpectedUrls = new Set(urlsToCacheKeys.values());

  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return cache.keys().then(function(existingRequests) {
        return Promise.all(
          existingRequests.map(function(existingRequest) {
            if (!setOfExpectedUrls.has(existingRequest.url)) {
              return cache.delete(existingRequest);
            }
          })
        );
      });
    }).then(function() {
      
      return self.clients.claim();
      
    })
  );
});


self.addEventListener('fetch', function(event) {
  if (event.request.method === 'GET') {
    // Should we call event.respondWith() inside this fetch event handler?
    // This needs to be determined synchronously, which will give other fetch
    // handlers a chance to handle the request if need be.
    var shouldRespond;

    // First, remove all the ignored parameters and hash fragment, and see if we
    // have that URL in our cache. If so, great! shouldRespond will be true.
    var url = stripIgnoredUrlParameters(event.request.url, ignoreUrlParametersMatching);
    shouldRespond = urlsToCacheKeys.has(url);

    // If shouldRespond is false, check again, this time with 'index.html'
    // (or whatever the directoryIndex option is set to) at the end.
    var directoryIndex = 'index.html';
    if (!shouldRespond && directoryIndex) {
      url = addDirectoryIndex(url, directoryIndex);
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond is still false, check to see if this is a navigation
    // request, and if so, whether the URL matches navigateFallbackWhitelist.
    var navigateFallback = '';
    if (!shouldRespond &&
        navigateFallback &&
        (event.request.mode === 'navigate') &&
        isPathWhitelisted([], event.request.url)) {
      url = new URL(navigateFallback, self.location).toString();
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond was set to true at any point, then call
    // event.respondWith(), using the appropriate cache key.
    if (shouldRespond) {
      event.respondWith(
        caches.open(cacheName).then(function(cache) {
          return cache.match(urlsToCacheKeys.get(url)).then(function(response) {
            if (response) {
              return response;
            }
            throw Error('The cached response that was expected is missing.');
          });
        }).catch(function(e) {
          // Fall back to just fetch()ing the request if some unexpected error
          // prevented the cached response from being valid.
          console.warn('Couldn\'t serve response for "%s" from cache: %O', event.request.url, e);
          return fetch(event.request);
        })
      );
    }
  }
});







