/**
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

// DO NOT EDIT THIS GENERATED OUTPUT DIRECTLY!
// This file should be overwritten as part of your build process.
// If you need to extend the behavior of the generated service worker, the best approach is to write
// additional code and include it using the importScripts option:
//   https://github.com/GoogleChrome/sw-precache#importscripts-arraystring
//
// Alternatively, it's possible to make changes to the underlying template file and then use that as the
// new base for generating output, via the templateFilePath option:
//   https://github.com/GoogleChrome/sw-precache#templatefilepath-string
//
// If you go that route, make sure that whenever you update your sw-precache dependency, you reconcile any
// changes made to this original template file with your modified copy.

// This generated service worker JavaScript will precache your site's resources.
// The code needs to be saved in a .js file at the top-level of your site, and registered
// from your pages in order to be used. See
// https://github.com/googlechrome/sw-precache/blob/master/demo/app/js/service-worker-registration.js
// for an example of how you can register this script and handle various service worker events.

/* eslint-env worker, serviceworker */
/* eslint-disable indent, no-unused-vars, no-multiple-empty-lines, max-nested-callbacks, space-before-function-paren, quotes, comma-spacing */
'use strict';

var precacheConfig = [["allclasses-frame.html","bec3ec7d667ad2074b4a26cbef0e4d59"],["allclasses-noframe.html","1c12f9326009db1589f8b64f162639cb"],["constant-values.html","d5902312ef69322676e21874da54d239"],["deprecated-list.html","80842b116f116572e34464b9e20af869"],["favicon.ico","05e61206186c2eee9054011bcf15b864"],["help-doc.html","46870686e63995e2b07ac83175fc59ed"],["index-files/index-1.html","1050e5d1c6a52a7931e5d7fd368566e9"],["index-files/index-10.html","cb87c329ed9e60e68bfcaf2d06fd3f05"],["index-files/index-11.html","032fd55fac5c767b6d7912cecbc55173"],["index-files/index-12.html","3ec0949b7fbf289cc2c16dcabc68694b"],["index-files/index-13.html","f43aa7e2cd6f29f9359e9e914bdb11f3"],["index-files/index-14.html","90048494faef0ac9e1d20dc5e679157b"],["index-files/index-15.html","6896da22e060ab0d9a8d1f5713733f0b"],["index-files/index-16.html","0861b41e3ec4ce4c9710866a883502e7"],["index-files/index-17.html","c27c9acafc7ef0436f2376aa0cc934d1"],["index-files/index-18.html","44fba77748fa549c867acb786d765d55"],["index-files/index-19.html","c386a8cd373c9f7851974ef87a44e95c"],["index-files/index-2.html","0e734eaf540d2633dfdde1eacdd2783f"],["index-files/index-20.html","509e9b4def8d3467266fad31a537d7bd"],["index-files/index-3.html","48352cda7d860dd0855e1b5b3cae7b70"],["index-files/index-4.html","7c480bbdc4b2f7091a0c4a59737b3807"],["index-files/index-5.html","d967f0f36bd4ef8c1909bb1ef4cb936e"],["index-files/index-6.html","54d13633dea8f46418b7ab05fb0c1fa1"],["index-files/index-7.html","beb6cde96bbb3ae92952536e1cdb42b2"],["index-files/index-8.html","5314f87d0b4def91b79d5888075336c6"],["index-files/index-9.html","ab273f07f8f10da0bf801621312cf950"],["index.html","6424c441560d4a7fb33a001b5dcc88f5"],["js/highlight-8.6-java/highlight.pack.js","deec56e4bb489b0ce943987284aac274"],["js/highlight-8.6-java/styles/obsidian.css","d60cd29c66c835762c95d2ce6da21142"],["js/index.js","dfc78156c8712ef6c546ea1037a604ef"],["js/jdk6-project-version-insert.js","ddee726b95840e7606e132d95c65ef27"],["js/jdk6-project-version-insert.min.js","a6a8d425f512ba0a8e2340504f134553"],["js/jquery-1.7.min.js","25721ced154b3a99e818431446d7506d"],["org/mockito/AdditionalAnswers.html","afac8e86a990a8962a0a6c78d1dd4056"],["org/mockito/AdditionalMatchers.html","1e7657934328b8a1eb12e52453208187"],["org/mockito/Answers.html","5fec48b00cbbcf2d6fa622147afae64a"],["org/mockito/ArgumentCaptor.html","c784d1d8a6f4366694f518c40b3e91b7"],["org/mockito/ArgumentMatcher.html","6565f7aceea04680c6ae073cc72711e9"],["org/mockito/ArgumentMatchers.html","1d9cd80c8d650a07db1b24b962446950"],["org/mockito/BDDMockito.BDDMyOngoingStubbing.html","35a1f65b4ab373ebc57cd178ee7fbed0"],["org/mockito/BDDMockito.BDDStubber.html","50a8b6845369bf552d90f031c82b22ce"],["org/mockito/BDDMockito.Then.html","ce2be6ff62f8d2d76bc76451f2aecfa6"],["org/mockito/BDDMockito.html","c2bfcfa5b9d82f42d68b59201e721296"],["org/mockito/Captor.html","ed74acb58c6fa74dea40e835a180ad58"],["org/mockito/InOrder.html","e32d2ee1c81ceb09e198b234078cb434"],["org/mockito/Incubating.html","7198d02aa3ca3e33328ddd234081979f"],["org/mockito/InjectMocks.html","595e060a85aab31e14bc03308eb5a5e9"],["org/mockito/Matchers.html","bbd9e5348f9f1eb2e81b6ef43f78fbb9"],["org/mockito/Mock.html","5bc3f36e2ea98a89a04e586f6cdb46cb"],["org/mockito/MockSettings.html","9432b5e88449c9c37c7cff2678859bed"],["org/mockito/MockingDetails.html","5da23476ba2c83d71db42b0c7f413d2d"],["org/mockito/Mockito.html","7857c4a7d071c08c4bb2f9533c5fc0d3"],["org/mockito/MockitoAnnotations.html","b9f9bf1918552b59a8ec8e793187b3cd"],["org/mockito/MockitoDebugger.html","4b83f7caf5a226ac882e8c18c1ec7758"],["org/mockito/MockitoFramework.html","8702472db1688280507626cf8cc72c70"],["org/mockito/Spy.html","67d2c354d25f4e1320197f0d14d08fe3"],["org/mockito/class-use/AdditionalAnswers.html","2f1a62a2a68ba3d868505de46c8c7064"],["org/mockito/class-use/AdditionalMatchers.html","39d2a949d6f3a8f1ceeaa787bef8d1a8"],["org/mockito/class-use/Answers.html","5ddc0814a3f267bac013aa7c7ee93e9d"],["org/mockito/class-use/ArgumentCaptor.html","f48635086980fc9d1687feb0e649910e"],["org/mockito/class-use/ArgumentMatcher.html","1e232c5899df9d0848bf417e2c0d7db4"],["org/mockito/class-use/ArgumentMatchers.html","64ab1af1c27d36b515b0c1b71f18d4a1"],["org/mockito/class-use/BDDMockito.BDDMyOngoingStubbing.html","58886cc98063985ceccc12958cc70f0a"],["org/mockito/class-use/BDDMockito.BDDStubber.html","9fe3dc4a08d4ca8b34becf5cdafbbc15"],["org/mockito/class-use/BDDMockito.Then.html","406058e4f1617734b67504fee4671505"],["org/mockito/class-use/BDDMockito.html","fc5cf4508adb54c9250f9a7e7a647e28"],["org/mockito/class-use/Captor.html","bc080541ae65e6a1a3834bc1e13cdd85"],["org/mockito/class-use/InOrder.html","08dcfb50726f7fbecb3c4f1ddcdbd271"],["org/mockito/class-use/Incubating.html","6cfb2190d7ea81ff3fc6e014ac37d713"],["org/mockito/class-use/InjectMocks.html","8a33f502a1439b5f12dc6cabd2b27a44"],["org/mockito/class-use/Matchers.html","668c009d1bc712708c537145f6752eda"],["org/mockito/class-use/Mock.html","0176411e11256584956b32831de49be6"],["org/mockito/class-use/MockSettings.html","b38bd0392503d86145831ffdb70e7a01"],["org/mockito/class-use/MockingDetails.html","c10ff67fc45b896e3fc18089ffacd876"],["org/mockito/class-use/Mockito.html","7f9eb677d41f3bfabd303139cb3a4ece"],["org/mockito/class-use/MockitoAnnotations.html","f5c9f7d58d40850a0d63d17b1138dea5"],["org/mockito/class-use/MockitoDebugger.html","6ff014e7d4a71b446ee388f8a1485148"],["org/mockito/class-use/MockitoFramework.html","568a0c82bf2b2e62e539c4394840ab9f"],["org/mockito/class-use/Spy.html","e84c5010aa27f4e93eb6684d16cdd0b1"],["org/mockito/configuration/AnnotationEngine.html","3a1580f55e5e03770df0f0a20988b68e"],["org/mockito/configuration/DefaultMockitoConfiguration.html","3d14ea8002501da8d64bfd3991ec7e5f"],["org/mockito/configuration/IMockitoConfiguration.html","716a2ac911bdab2e4512fe1131815d84"],["org/mockito/configuration/class-use/AnnotationEngine.html","03aee4e0cbe8b4a0c1779f0ba814be29"],["org/mockito/configuration/class-use/DefaultMockitoConfiguration.html","b33149f504141616f8733d19d3dac557"],["org/mockito/configuration/class-use/IMockitoConfiguration.html","8f9af45ed7bb197814e029d31a434e5b"],["org/mockito/configuration/package-frame.html","6c19172b0f0aa7d188a765503a4e55ff"],["org/mockito/configuration/package-summary.html","95d2662e9df7188bb1dc1c53547fbc1e"],["org/mockito/configuration/package-tree.html","140df943e04ec0ecd04da06d8bd35744"],["org/mockito/configuration/package-use.html","2d3f4ec9ba410dd1c805f849c8817ab5"],["org/mockito/exceptions/base/MockitoAssertionError.html","08678fc6847ada1c14b899055cbab978"],["org/mockito/exceptions/base/MockitoException.html","f7527059d23115b1cb9c85a4ac971f9d"],["org/mockito/exceptions/base/MockitoInitializationException.html","fb9e88b8b5d9efb8f064072724191fab"],["org/mockito/exceptions/base/MockitoSerializationIssue.html","74b1810a9bd0bffd503e4a7bdd891d9c"],["org/mockito/exceptions/base/class-use/MockitoAssertionError.html","0ea54967eef2aa93f9dc4905afc1991f"],["org/mockito/exceptions/base/class-use/MockitoException.html","aa01b42ef413c5a2122effd07820a07b"],["org/mockito/exceptions/base/class-use/MockitoInitializationException.html","529c30b19abde98ff979171dbb84240f"],["org/mockito/exceptions/base/class-use/MockitoSerializationIssue.html","1e9415c1fb5ab6255e98d1d1b147097e"],["org/mockito/exceptions/base/package-frame.html","1c53a62682a93c6c505da9e4efdc5b62"],["org/mockito/exceptions/base/package-summary.html","8753ed4caaf81b818466a6d79f7d452d"],["org/mockito/exceptions/base/package-tree.html","cf6455dc278be3d73c177c584ed4fc25"],["org/mockito/exceptions/base/package-use.html","af72f255b08672f8a3c3174975d1ba73"],["org/mockito/exceptions/misusing/CannotStubVoidMethodWithReturnValue.html","49cf7991f3ac10664e93c6fb222c2992"],["org/mockito/exceptions/misusing/CannotVerifyStubOnlyMock.html","b6c366890e9952621b7941244f8bd738"],["org/mockito/exceptions/misusing/FriendlyReminderException.html","dc9df8f53cf2fca704d5b1f4445c3a4e"],["org/mockito/exceptions/misusing/InvalidUseOfMatchersException.html","faa0244b2463394725f542e7d8746961"],["org/mockito/exceptions/misusing/MissingMethodInvocationException.html","17d3113f530c510ab7f7ee3e86525228"],["org/mockito/exceptions/misusing/MockitoConfigurationException.html","0a7361909e9935818896353aed50c7c1"],["org/mockito/exceptions/misusing/NotAMockException.html","1c7ac06c2a95ab5ca3f04ba9d1391a19"],["org/mockito/exceptions/misusing/NullInsteadOfMockException.html","361b83841b0565c1f0aeac15ef338863"],["org/mockito/exceptions/misusing/PotentialStubbingProblem.html","de382cadbc255ec5893c5028afa47d64"],["org/mockito/exceptions/misusing/RedundantListenerException.html","d931eb1683f703a2c6751bb09121f82d"],["org/mockito/exceptions/misusing/UnfinishedStubbingException.html","b9a5733577b293f3e7efed28027c1e02"],["org/mockito/exceptions/misusing/UnfinishedVerificationException.html","095d9475ccbcbbb744d7768b54550831"],["org/mockito/exceptions/misusing/UnnecessaryStubbingException.html","7a1ed6ccb5de7edbe4203365b72f3bb0"],["org/mockito/exceptions/misusing/WrongTypeOfReturnValue.html","b2172d64a74ce49124a0a0a638adb556"],["org/mockito/exceptions/misusing/class-use/CannotStubVoidMethodWithReturnValue.html","b11bbd193e5963d256803ba2c6285862"],["org/mockito/exceptions/misusing/class-use/CannotVerifyStubOnlyMock.html","5d35862789a3ef1949e67a6cce9e29c6"],["org/mockito/exceptions/misusing/class-use/FriendlyReminderException.html","5d57d0ae7a3b4da42ec71d601df6013d"],["org/mockito/exceptions/misusing/class-use/InvalidUseOfMatchersException.html","d0d165047618408acf045f13d6912a32"],["org/mockito/exceptions/misusing/class-use/MissingMethodInvocationException.html","6193b5ed0fabb61646e0fde7c3deee76"],["org/mockito/exceptions/misusing/class-use/MockitoConfigurationException.html","50e0fd5ca70f5dce8a9752f76b523671"],["org/mockito/exceptions/misusing/class-use/NotAMockException.html","dac8c7344cd3ef74f4e2db92b3758ce3"],["org/mockito/exceptions/misusing/class-use/NullInsteadOfMockException.html","5a9c5cb1b8b751247763fc924856d4ce"],["org/mockito/exceptions/misusing/class-use/PotentialStubbingProblem.html","93f343820b6a1b9c1f2914d4d820a05d"],["org/mockito/exceptions/misusing/class-use/RedundantListenerException.html","96f8fe8e635803b4cfd7ad8c532e7bff"],["org/mockito/exceptions/misusing/class-use/UnfinishedStubbingException.html","70b0f2d6c238244693baa7ebce3ac190"],["org/mockito/exceptions/misusing/class-use/UnfinishedVerificationException.html","af2df697e1a1bad3d2d0ed593568e61c"],["org/mockito/exceptions/misusing/class-use/UnnecessaryStubbingException.html","e6b96c979a1b7b0a7a5a7c286d52ffe6"],["org/mockito/exceptions/misusing/class-use/WrongTypeOfReturnValue.html","a092b50fe8dfc8701d94433010c07fbb"],["org/mockito/exceptions/misusing/package-frame.html","45dc0f0459a7c9d18ef37eb4c5911feb"],["org/mockito/exceptions/misusing/package-summary.html","2e07a7513412d68f94ac88eb0d3ceed9"],["org/mockito/exceptions/misusing/package-tree.html","9b2cd5f643872b4443c768451386d947"],["org/mockito/exceptions/misusing/package-use.html","9e1d985f77b2364da3268ce4e58d1bae"],["org/mockito/exceptions/stacktrace/StackTraceCleaner.html","d826da221756f207e4eaa8111e564ddb"],["org/mockito/exceptions/stacktrace/class-use/StackTraceCleaner.html","d99bb13ba6d1ff859f8b8292e9097f3c"],["org/mockito/exceptions/stacktrace/package-frame.html","bc5b8280dbd890e938a68b7a4cfba06c"],["org/mockito/exceptions/stacktrace/package-summary.html","6377f298a003f8a2c17b0303535d950a"],["org/mockito/exceptions/stacktrace/package-tree.html","ee8aa71ba707a546334f8e37216c967f"],["org/mockito/exceptions/stacktrace/package-use.html","7bdb63776a9736177edbfdcb092e8580"],["org/mockito/exceptions/verification/ArgumentsAreDifferent.html","987c38cd5f26a796f737bac33d2574ef"],["org/mockito/exceptions/verification/NeverWantedButInvoked.html","01f22bebb48d70a3a99340c64fc4730f"],["org/mockito/exceptions/verification/NoInteractionsWanted.html","6379a5b3ecc67bcfb93846ffe4752de5"],["org/mockito/exceptions/verification/SmartNullPointerException.html","629c534e095ea12f109b022cb2ae58a2"],["org/mockito/exceptions/verification/TooLittleActualInvocations.html","5742eb89e7b1e7b8cc5617c602e02750"],["org/mockito/exceptions/verification/TooManyActualInvocations.html","4a77959b684f9f804878e8cf537c6718"],["org/mockito/exceptions/verification/VerificationInOrderFailure.html","9e73c6d4b6b5a5c6730d9cd8616007b3"],["org/mockito/exceptions/verification/WantedButNotInvoked.html","2c0a05e06779a3443b2f8149be1df426"],["org/mockito/exceptions/verification/class-use/ArgumentsAreDifferent.html","46e1d5ac2794ce5159c0b9cb7aa873cb"],["org/mockito/exceptions/verification/class-use/NeverWantedButInvoked.html","332ecd12fbabcddd0cb22d2ee01ce723"],["org/mockito/exceptions/verification/class-use/NoInteractionsWanted.html","33c4dd9928373a38868dbf979f6a9d31"],["org/mockito/exceptions/verification/class-use/SmartNullPointerException.html","bb7f27746ae13803dbe364d6bc9bce67"],["org/mockito/exceptions/verification/class-use/TooLittleActualInvocations.html","40dec20ca2cfb8fc27a71b5d05839ecb"],["org/mockito/exceptions/verification/class-use/TooManyActualInvocations.html","f9f27eaf160173f25f724b4769d22b85"],["org/mockito/exceptions/verification/class-use/VerificationInOrderFailure.html","1c36a076ba7778cb3a91faa5149bf23c"],["org/mockito/exceptions/verification/class-use/WantedButNotInvoked.html","a838ce411865cd799e0b8ed6dd6114de"],["org/mockito/exceptions/verification/junit/ArgumentsAreDifferent.html","58d03b9f4cbc7922907bcef5bcd9c89f"],["org/mockito/exceptions/verification/junit/class-use/ArgumentsAreDifferent.html","ac199bfccd7c26d6197ff281f5abdd9b"],["org/mockito/exceptions/verification/junit/package-frame.html","dc1106b0cc15e0b0321402530a50fb74"],["org/mockito/exceptions/verification/junit/package-summary.html","e5a98a35bfa543b9cad2f36215310986"],["org/mockito/exceptions/verification/junit/package-tree.html","3f9cac3ed24b08dcb3f2d9692c32e514"],["org/mockito/exceptions/verification/junit/package-use.html","62cb9a16a4d1b64d36b18805b339c519"],["org/mockito/exceptions/verification/package-frame.html","c61dce312a0cfa0b879df408ab1ccad5"],["org/mockito/exceptions/verification/package-summary.html","097daef3d37ee70028a404323f1bd73c"],["org/mockito/exceptions/verification/package-tree.html","724a4ae987c4264afe3f1fe5e4ccfd2c"],["org/mockito/exceptions/verification/package-use.html","f9308935bbc90903621c6bba68eceb65"],["org/mockito/hamcrest/MockitoHamcrest.html","1097093f8c768761c4a4e89494e3a7d2"],["org/mockito/hamcrest/class-use/MockitoHamcrest.html","aa16d41081430e3daddd9d9951d78a3e"],["org/mockito/hamcrest/package-frame.html","5beb74a8638d13a074557766c16519a3"],["org/mockito/hamcrest/package-summary.html","e83fcfa10a529a69846bd2f561145ac4"],["org/mockito/hamcrest/package-tree.html","336c17b001a5519bb2bda3287ef1c8cd"],["org/mockito/hamcrest/package-use.html","5c0a1dbb487027a5fad318695dac1f50"],["org/mockito/invocation/DescribedInvocation.html","73118ca1ec08306bad095e295f9c5c68"],["org/mockito/invocation/Invocation.html","289611ef97311f52777b0f78294921d4"],["org/mockito/invocation/InvocationOnMock.html","9a52efd9fce9bc0c7f46a05c86a7d6dc"],["org/mockito/invocation/Location.html","fdeccee88b5838441971d3085d9b34d7"],["org/mockito/invocation/MatchableInvocation.html","a6b0564f132826e81c059a6efeb501f7"],["org/mockito/invocation/MockHandler.html","ace6f167439ba3020d94c03ab5f2ff07"],["org/mockito/invocation/StubInfo.html","dbb3ade56dd1e937f82b6940cb2c2775"],["org/mockito/invocation/class-use/DescribedInvocation.html","996dfb8d85cbcabe206dc4cd2f27c1e3"],["org/mockito/invocation/class-use/Invocation.html","09e15a596938a0c941722df1b0f6efd2"],["org/mockito/invocation/class-use/InvocationOnMock.html","34c4878e41641f3229f0570331a39bb1"],["org/mockito/invocation/class-use/Location.html","84792c3ec10cbe890e3b1531daf8e907"],["org/mockito/invocation/class-use/MatchableInvocation.html","5d21959dce29019a1ff247709a5cd89f"],["org/mockito/invocation/class-use/MockHandler.html","648b83e5ec2474fd8958e554b9ce75bb"],["org/mockito/invocation/class-use/StubInfo.html","3a11b26f9fabed5713e3cab8aaa791cf"],["org/mockito/invocation/package-frame.html","c18d68cc9fcdc8ccc8bce84421d869c9"],["org/mockito/invocation/package-summary.html","61e83cf2f77f94d1c56e46fc988d6687"],["org/mockito/invocation/package-tree.html","0c5ae12e2ad886d67d1124a83074dd92"],["org/mockito/invocation/package-use.html","1495a90c7200b5466e6479ca4145e88c"],["org/mockito/junit/MockitoJUnit.html","08d3184fca22354658e02475bdea7bf5"],["org/mockito/junit/MockitoJUnitRunner.Silent.html","ce9a3a6cc3ca0a3e75092b9e29844821"],["org/mockito/junit/MockitoJUnitRunner.Strict.html","6c095c8c60a187b789bc731a990737f6"],["org/mockito/junit/MockitoJUnitRunner.StrictStubs.html","9e36073097da48e045a0c68646736c7a"],["org/mockito/junit/MockitoJUnitRunner.html","916c2a439e4eefcf2cd9924b72c8f6fe"],["org/mockito/junit/MockitoRule.html","d66616932b71e4b80aab6bba08d32cc6"],["org/mockito/junit/VerificationCollector.html","d5493852e37ea3b74ecf017e15a43566"],["org/mockito/junit/class-use/MockitoJUnit.html","5ef3fedf0544b8ed3620ff0c2859b29a"],["org/mockito/junit/class-use/MockitoJUnitRunner.Silent.html","f6c1fec93738315256f64522ca54f123"],["org/mockito/junit/class-use/MockitoJUnitRunner.Strict.html","9ad52f2b2629fdacdfc59beba65d3b7d"],["org/mockito/junit/class-use/MockitoJUnitRunner.StrictStubs.html","3591cca737d6052e9fb1959d2e9bc8c3"],["org/mockito/junit/class-use/MockitoJUnitRunner.html","79fa95bb659cbdd0922a98ca003f49aa"],["org/mockito/junit/class-use/MockitoRule.html","e64b8a00712a857748c96f95d4071ea4"],["org/mockito/junit/class-use/VerificationCollector.html","38eb151808be2cc52a0859bbbb5c8a26"],["org/mockito/junit/package-frame.html","735f0055834438cc640f17c785fac00d"],["org/mockito/junit/package-summary.html","71c52a139d5a4dca46b82b1c5c52f33c"],["org/mockito/junit/package-tree.html","2cfc92fcc4c454f6a8546c7e9f398fd3"],["org/mockito/junit/package-use.html","475f01b1f5b311c270e48d59b31ac4ab"],["org/mockito/listeners/InvocationListener.html","78c73a4d04d97fa6d90bb22d04d7a21a"],["org/mockito/listeners/MethodInvocationReport.html","823b903ab2c72295b4d530460f496ae1"],["org/mockito/listeners/MockCreationListener.html","4202a38665e6b6ee41834b85f3316180"],["org/mockito/listeners/MockitoListener.html","e0e411b1f40beb1baa8d66135c7474ee"],["org/mockito/listeners/VerificationListener.html","0a77a4b506781454e299e9b57518ceed"],["org/mockito/listeners/class-use/InvocationListener.html","e194eb19ba60b349e4e34ad171a10ee8"],["org/mockito/listeners/class-use/MethodInvocationReport.html","20c6ef26dcc2515dcf3c30b04c24bebc"],["org/mockito/listeners/class-use/MockCreationListener.html","b6469aa912d3a71bd4b0472328186aec"],["org/mockito/listeners/class-use/MockitoListener.html","13f8a9e440bcfead4d0629d667f22686"],["org/mockito/listeners/class-use/VerificationListener.html","7e080181a905a3643517683de952bef5"],["org/mockito/listeners/package-frame.html","fbfe3ebf2c66d85bd70f33039d471ee6"],["org/mockito/listeners/package-summary.html","bed88855776a39dad4953953f29c671d"],["org/mockito/listeners/package-tree.html","7b71d9ad515dad982b9630269dccf34f"],["org/mockito/listeners/package-use.html","9bcd962455d092a080b643d60eadec88"],["org/mockito/mock/MockCreationSettings.html","c09274a2fa57628612a306f5e1559f3e"],["org/mockito/mock/MockName.html","e66a842a54d45646977867f666316816"],["org/mockito/mock/SerializableMode.html","59ac97cbee0727d271c89fa7fb8db79b"],["org/mockito/mock/class-use/MockCreationSettings.html","092605893675106af0b3c462ff9e550b"],["org/mockito/mock/class-use/MockName.html","e0b7f749d8e57dfb35338db4080c772c"],["org/mockito/mock/class-use/SerializableMode.html","d4cedccbe467e490cf3b07b0d1a551eb"],["org/mockito/mock/package-frame.html","471be883cd76213396c1bbb8fc15efe3"],["org/mockito/mock/package-summary.html","787ae16d3b621abea1b367670e9b6304"],["org/mockito/mock/package-tree.html","dfffe73f4c4ea2831ee21d503b750bde"],["org/mockito/mock/package-use.html","5635f09c6bef6221f8e23249a9488257"],["org/mockito/package-frame.html","5ade562ded06f46a501c8fb8043228bd"],["org/mockito/package-summary.html","677b2ff4761427e4da1d4bb3ab896dc7"],["org/mockito/package-tree.html","ce1b3474c381bab8f3e34ce7ab031e1e"],["org/mockito/package-use.html","57d0a51b88f9a74ed9a87c6a7e922eae"],["org/mockito/plugins/AnnotationEngine.html","2930c2a02c6013f3b1da4e9fd76d9cae"],["org/mockito/plugins/InstantiatorProvider.html","1ed7638f1bed7dda11f881bfd1b3ab30"],["org/mockito/plugins/MockMaker.TypeMockability.html","2ca89bacaf2989fca4f4a66a53060843"],["org/mockito/plugins/MockMaker.html","2cb69c00c37f8a0bcda3be4cf4c36311"],["org/mockito/plugins/PluginSwitch.html","3c282fa9549e40854c4f520b0d134730"],["org/mockito/plugins/StackTraceCleanerProvider.html","5a21e69d287b5cc3bb81ee450a7cf882"],["org/mockito/plugins/class-use/AnnotationEngine.html","a558ca044112dffe01a31587698611d6"],["org/mockito/plugins/class-use/InstantiatorProvider.html","8552f9ddd1efd6a1b0bf1890e30cdcaf"],["org/mockito/plugins/class-use/MockMaker.TypeMockability.html","615e41358ce1dec3a87cfc03a1d4ae8d"],["org/mockito/plugins/class-use/MockMaker.html","10f709588ca411ad44c9039db6ca0db8"],["org/mockito/plugins/class-use/PluginSwitch.html","08fa2716f77bc2fc26310c5e94fc55b7"],["org/mockito/plugins/class-use/StackTraceCleanerProvider.html","95133113e3b8493adb80473aa5dcafae"],["org/mockito/plugins/package-frame.html","0ca388727b642628c62aea28858c981a"],["org/mockito/plugins/package-summary.html","48aadcc746a93998c2e6ab17c1b58ecb"],["org/mockito/plugins/package-tree.html","145648965a5f7041926775d6f4b1ef82"],["org/mockito/plugins/package-use.html","0707c79719b51c6d18aec70d44431562"],["org/mockito/quality/MockitoHint.html","3aa164ef1898b203a04b1dad3e74be46"],["org/mockito/quality/Strictness.html","dccbc65b83b769bc3f5be8d2007efdc3"],["org/mockito/quality/class-use/MockitoHint.html","0b20e5ef77acf52ae38cfdc71832b475"],["org/mockito/quality/class-use/Strictness.html","e7fece9076d744518167fb6c1082f714"],["org/mockito/quality/package-frame.html","6b1505d718791b59d9312fe6786e6eee"],["org/mockito/quality/package-summary.html","562d3dd9b64c84f35f56dde54e7a82fe"],["org/mockito/quality/package-tree.html","ec8941c411e73de448f461811a7d108f"],["org/mockito/quality/package-use.html","2d23f892cad54f252856890d6c73a681"],["org/mockito/runners/ConsoleSpammingMockitoJUnitRunner.html","f474cefddfa5ddf9295fcc7b0fcf9298"],["org/mockito/runners/MockitoJUnitRunner.Silent.html","7397c13b6e56cc713a5d287d99541aef"],["org/mockito/runners/MockitoJUnitRunner.Strict.html","449344d415ea7d49b10e886fce02a4e2"],["org/mockito/runners/MockitoJUnitRunner.html","58abc39e94e4cebaaffeb71ea01ed7f0"],["org/mockito/runners/VerboseMockitoJUnitRunner.html","daf7283850440d91766b5de82fb1c450"],["org/mockito/runners/class-use/ConsoleSpammingMockitoJUnitRunner.html","a22bd176d505b90e3ab217d590598493"],["org/mockito/runners/class-use/MockitoJUnitRunner.Silent.html","0fe516d31788457bfbb32452ecceaea3"],["org/mockito/runners/class-use/MockitoJUnitRunner.Strict.html","adc83bd05656518c3d2de0be5b16b599"],["org/mockito/runners/class-use/MockitoJUnitRunner.html","ff6ff6b63de27755b1e1ef7d7e24c37c"],["org/mockito/runners/class-use/VerboseMockitoJUnitRunner.html","2578978d38a4033f095dc9122c8faceb"],["org/mockito/runners/package-frame.html","982ee8e1d67c95c36763fc7d460a9570"],["org/mockito/runners/package-summary.html","a84d97abe6f86aa34d248820bb3f5b1d"],["org/mockito/runners/package-tree.html","9077b2ff875363fc8b153ba4b1df01bf"],["org/mockito/runners/package-use.html","3d4c8414a690025afda7244cae0e1968"],["org/mockito/stubbing/Answer.html","4172d086e5c40a5597c2b7f7feb8743c"],["org/mockito/stubbing/Answer1.html","0aca2eb7d248eb3de7fd76b6842ac2e4"],["org/mockito/stubbing/Answer2.html","c8f4a45370705ec7f22592e22bb4e132"],["org/mockito/stubbing/Answer3.html","678384e0fe16b11893c790289caed719"],["org/mockito/stubbing/Answer4.html","635a150c9a5f431100c39410208cd2a8"],["org/mockito/stubbing/Answer5.html","48f7b0d070674221a0729d4279d9b689"],["org/mockito/stubbing/OngoingStubbing.html","19bd4709595b6393db5559fb20987e7f"],["org/mockito/stubbing/Stubber.html","914e3c3e1cafc9695277dee5ec3b339f"],["org/mockito/stubbing/Stubbing.html","5bbccc38352be57d2b526ad89f3ab173"],["org/mockito/stubbing/ValidableAnswer.html","fa9647fec880149af8b15febc1cba14e"],["org/mockito/stubbing/VoidAnswer1.html","6cf14678c935eabaf9c0758ed26d1924"],["org/mockito/stubbing/VoidAnswer2.html","512194a00de5d639795b36228cc9a3ae"],["org/mockito/stubbing/VoidAnswer3.html","14daf4ee0dddf645ea6f2e36355c4b41"],["org/mockito/stubbing/VoidAnswer4.html","14f7b1c9c4c5f45fc4c5f00ceec17d4d"],["org/mockito/stubbing/VoidAnswer5.html","6d245c2b19fb068b832059650b9827aa"],["org/mockito/stubbing/class-use/Answer.html","e872ac765216cf29e45c449bb1d2515d"],["org/mockito/stubbing/class-use/Answer1.html","36d88d5a885cabd49b1b4b5eb99373dd"],["org/mockito/stubbing/class-use/Answer2.html","7b17f47bc1c17db4c0b368e801e774df"],["org/mockito/stubbing/class-use/Answer3.html","32921d3a06b000973a915a2d08cb43e7"],["org/mockito/stubbing/class-use/Answer4.html","d5774b49794d5fb1523f4865135b1764"],["org/mockito/stubbing/class-use/Answer5.html","0f14ce4225884d6d5a4dc803173b2f6f"],["org/mockito/stubbing/class-use/OngoingStubbing.html","0e626489a16dc0de8d381f92735d0bc4"],["org/mockito/stubbing/class-use/Stubber.html","8b8a74dbe1cf9fd3e10d8fd42cadb49e"],["org/mockito/stubbing/class-use/Stubbing.html","c5e157a7293fef282f8f615eecdb169b"],["org/mockito/stubbing/class-use/ValidableAnswer.html","028c4709613131622063f08af5d0ed01"],["org/mockito/stubbing/class-use/VoidAnswer1.html","513779c6f4a2dd15de39b6d5530b4d26"],["org/mockito/stubbing/class-use/VoidAnswer2.html","6a1f1789e843aad00302200cb7ad4abb"],["org/mockito/stubbing/class-use/VoidAnswer3.html","d97e1b21afa22e01bdc17ca799b60d5b"],["org/mockito/stubbing/class-use/VoidAnswer4.html","5e3d3c0dce4dbee764930ce03545b9d6"],["org/mockito/stubbing/class-use/VoidAnswer5.html","1fc2590c5c5a2b3d3df981ebfddaf243"],["org/mockito/stubbing/package-frame.html","a67b1417e5d957955a8305230088ca62"],["org/mockito/stubbing/package-summary.html","cfdf51306118a0dc5062268fc3a01528"],["org/mockito/stubbing/package-tree.html","39e95e80a00aff0c8251d4d9c61c2f8b"],["org/mockito/stubbing/package-use.html","5aac1523d14bb9bffebbad2fcde6d156"],["org/mockito/verification/After.html","283d9c53079fb210d6d9b1d25dd85bed"],["org/mockito/verification/Timeout.html","1b7d133af239e9cf05013c9e75b840e1"],["org/mockito/verification/VerificationAfterDelay.html","e8631cddda8992fc6fb162a4aae6c6a8"],["org/mockito/verification/VerificationEvent.html","d267031d57af50b5e70a5bcff96bfdc7"],["org/mockito/verification/VerificationMode.html","fadaa03543e49f357ba2eb819202bdad"],["org/mockito/verification/VerificationStrategy.html","5a414e3618029f4bb725c9e52b786643"],["org/mockito/verification/VerificationWithTimeout.html","c301e3f83e8256bf1c32a9f2823e5d71"],["org/mockito/verification/class-use/After.html","f7579acb6c8dc20750d04813ae9551b8"],["org/mockito/verification/class-use/Timeout.html","584f3e4a2a997b94c4b53fdd91cc0a83"],["org/mockito/verification/class-use/VerificationAfterDelay.html","99ea9d8af9c7022cc9fdc3fd98ee2d65"],["org/mockito/verification/class-use/VerificationEvent.html","74fa4f3ba14c66e81ed3f4497aaa9fbd"],["org/mockito/verification/class-use/VerificationMode.html","78e76ea231eadaf14de4adf8a39f4590"],["org/mockito/verification/class-use/VerificationStrategy.html","9ffcf6cadc19d1d8076753191361225b"],["org/mockito/verification/class-use/VerificationWithTimeout.html","57802c3de3a0bec0b6a1ff85900b2db4"],["org/mockito/verification/package-frame.html","d57da537ab92dfbe562b4a85b6075b96"],["org/mockito/verification/package-summary.html","64da4926f42223f977385fc3516b2123"],["org/mockito/verification/package-tree.html","e9d718d5faaada9c31cd71fbb629fdd3"],["org/mockito/verification/package-use.html","9a5327d8d2b8d5fda97ffa7fbf1b310b"],["overview-frame.html","4b7996183dc95b1eb5a690862df4612e"],["overview-summary.html","439a4dd04bfc3bf9683e2272155ebe9c"],["overview-tree.html","908b9874ba14b24892529599b7f1237f"],["serialized-form.html","d310acc4fb85e6ae5db8fe8c5ee04510"],["stylesheet.css","3dd9013d4309436be79cba586b6e5454"]];
var cacheName = 'sw-precache-v2-sw-precache-' + (self.registration ? self.registration.scope : '');


var ignoreUrlParametersMatching = [/^utm_/];



var addDirectoryIndex = function (originalUrl, index) {
    var url = new URL(originalUrl);
    if (url.pathname.slice(-1) === '/') {
      url.pathname += index;
    }
    return url.toString();
  };

var createCacheKey = function (originalUrl, paramName, paramValue,
                           dontCacheBustUrlsMatching) {
    // Create a new URL object to avoid modifying originalUrl.
    var url = new URL(originalUrl);

    // If dontCacheBustUrlsMatching is not set, or if we don't have a match,
    // then add in the extra cache-busting URL parameter.
    if (!dontCacheBustUrlsMatching ||
        !(url.toString().match(dontCacheBustUrlsMatching))) {
      url.search += (url.search ? '&' : '') +
        encodeURIComponent(paramName) + '=' + encodeURIComponent(paramValue);
    }

    return url.toString();
  };

var isPathWhitelisted = function (whitelist, absoluteUrlString) {
    // If the whitelist is empty, then consider all URLs to be whitelisted.
    if (whitelist.length === 0) {
      return true;
    }

    // Otherwise compare each path regex to the path of the URL passed in.
    var path = (new URL(absoluteUrlString)).pathname;
    return whitelist.some(function(whitelistedPathRegex) {
      return path.match(whitelistedPathRegex);
    });
  };

var stripIgnoredUrlParameters = function (originalUrl,
    ignoreUrlParametersMatching) {
    var url = new URL(originalUrl);

    url.search = url.search.slice(1) // Exclude initial '?'
      .split('&') // Split into an array of 'key=value' strings
      .map(function(kv) {
        return kv.split('='); // Split each 'key=value' string into a [key, value] array
      })
      .filter(function(kv) {
        return ignoreUrlParametersMatching.every(function(ignoredRegex) {
          return !ignoredRegex.test(kv[0]); // Return true iff the key doesn't match any of the regexes.
        });
      })
      .map(function(kv) {
        return kv.join('='); // Join each [key, value] array into a 'key=value' string
      })
      .join('&'); // Join the array of 'key=value' strings into a string with '&' in between each

    return url.toString();
  };


var hashParamName = '_sw-precache';
var urlsToCacheKeys = new Map(
  precacheConfig.map(function(item) {
    var relativeUrl = item[0];
    var hash = item[1];
    var absoluteUrl = new URL(relativeUrl, self.location);
    var cacheKey = createCacheKey(absoluteUrl, hashParamName, hash, false);
    return [absoluteUrl.toString(), cacheKey];
  })
);

function setOfCachedUrls(cache) {
  return cache.keys().then(function(requests) {
    return requests.map(function(request) {
      return request.url;
    });
  }).then(function(urls) {
    return new Set(urls);
  });
}

self.addEventListener('install', function(event) {
  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return setOfCachedUrls(cache).then(function(cachedUrls) {
        return Promise.all(
          Array.from(urlsToCacheKeys.values()).map(function(cacheKey) {
            // If we don't have a key matching url in the cache already, add it.
            if (!cachedUrls.has(cacheKey)) {
              return cache.add(new Request(cacheKey, {
                credentials: 'same-origin',
                redirect: 'follow'
              }));
            }
          })
        );
      });
    }).then(function() {
      
      // Force the SW to transition from installing -> active state
      return self.skipWaiting();
      
    })
  );
});

self.addEventListener('activate', function(event) {
  var setOfExpectedUrls = new Set(urlsToCacheKeys.values());

  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return cache.keys().then(function(existingRequests) {
        return Promise.all(
          existingRequests.map(function(existingRequest) {
            if (!setOfExpectedUrls.has(existingRequest.url)) {
              return cache.delete(existingRequest);
            }
          })
        );
      });
    }).then(function() {
      
      return self.clients.claim();
      
    })
  );
});


self.addEventListener('fetch', function(event) {
  if (event.request.method === 'GET') {
    // Should we call event.respondWith() inside this fetch event handler?
    // This needs to be determined synchronously, which will give other fetch
    // handlers a chance to handle the request if need be.
    var shouldRespond;

    // First, remove all the ignored parameter and see if we have that URL
    // in our cache. If so, great! shouldRespond will be true.
    var url = stripIgnoredUrlParameters(event.request.url, ignoreUrlParametersMatching);
    shouldRespond = urlsToCacheKeys.has(url);

    // If shouldRespond is false, check again, this time with 'index.html'
    // (or whatever the directoryIndex option is set to) at the end.
    var directoryIndex = 'index.html';
    if (!shouldRespond && directoryIndex) {
      url = addDirectoryIndex(url, directoryIndex);
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond is still false, check to see if this is a navigation
    // request, and if so, whether the URL matches navigateFallbackWhitelist.
    var navigateFallback = '';
    if (!shouldRespond &&
        navigateFallback &&
        (event.request.mode === 'navigate') &&
        isPathWhitelisted([], event.request.url)) {
      url = new URL(navigateFallback, self.location).toString();
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond was set to true at any point, then call
    // event.respondWith(), using the appropriate cache key.
    if (shouldRespond) {
      event.respondWith(
        caches.open(cacheName).then(function(cache) {
          return cache.match(urlsToCacheKeys.get(url)).then(function(response) {
            if (response) {
              return response;
            }
            throw Error('The cached response that was expected is missing.');
          });
        }).catch(function(e) {
          // Fall back to just fetch()ing the request if some unexpected error
          // prevented the cached response from being valid.
          console.warn('Couldn\'t serve response for "%s" from cache: %O', event.request.url, e);
          return fetch(event.request);
        })
      );
    }
  }
});







