/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.record;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import org.modelmapper.internal.Errors;
import org.modelmapper.spi.ValueReader;

public class RecordValueReader
implements ValueReader<Record> {
    public Object get(Record record, String memberName) {
        Field field = this.matchField(record, memberName);
        if (field != null) {
            try {
                return field.get(record);
            }
            catch (IllegalAccessException e) {
                throw new Errors().addMessage((Throwable)e, "Cannot get the member", new Object[0]).toMappingException();
            }
        }
        return null;
    }

    public ValueReader.Member<Record> getMember(Record record, String memberName) {
        Field field = this.matchField(record, memberName);
        Class<?> type = field != null ? field.getType() : null;
        return new ValueReader.Member<Record>(type){

            public Object get(Record source, String memberName) {
                return RecordValueReader.this.get(source, memberName);
            }
        };
    }

    public Collection<String> memberNames(Record record) {
        Field[] fields = record.getClass().getDeclaredFields();
        ArrayList<String> memberNames = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            field.setAccessible(true);
            memberNames.add(field.getName());
        }
        return memberNames;
    }

    private Field matchField(Record source, String memberName) {
        for (Field field : source.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!memberName.equalsIgnoreCase(field.getName())) continue;
            return field;
        }
        return null;
    }
}

