/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import java.util.Set;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ReferenceValue
implements DynamicOperand {
    private static final long serialVersionUID = 1L;
    private final Set<SelectorName> selectorNames;
    private final String propertyName;
    private final int hc;
    private final boolean includeWeakReferences;

    public ReferenceValue(SelectorName selectorName) {
        this.selectorNames = SelectorName.nameSetFrom(selectorName);
        this.propertyName = null;
        this.hc = HashCode.compute((Object[])new Object[]{selectorName, this.propertyName});
        this.includeWeakReferences = true;
    }

    public ReferenceValue(SelectorName selectorName, String propertyName, boolean includeWeakReferences) {
        this.selectorNames = SelectorName.nameSetFrom(selectorName);
        this.propertyName = propertyName;
        this.hc = HashCode.compute((Object[])new Object[]{selectorName, this.propertyName});
        this.includeWeakReferences = includeWeakReferences;
    }

    public ReferenceValue(SelectorName selectorName, String propertyName) {
        this.selectorNames = SelectorName.nameSetFrom(selectorName);
        this.propertyName = propertyName;
        this.hc = HashCode.compute((Object[])new Object[]{selectorName, this.propertyName});
        this.includeWeakReferences = true;
    }

    public SelectorName selectorName() {
        return this.selectorNames().iterator().next();
    }

    @Override
    public Set<SelectorName> selectorNames() {
        return this.selectorNames;
    }

    public final String propertyName() {
        return this.propertyName;
    }

    public boolean includesWeakReferences() {
        return this.includeWeakReferences;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ReferenceValue) {
            ReferenceValue that = (ReferenceValue)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (!((Object)this.selectorNames()).equals(that.selectorNames())) {
                return false;
            }
            if (this.propertyName != null) {
                return this.propertyName.equals(that.propertyName);
            }
            return that.propertyName == null;
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

