/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector;

import com.mongodb.spark.sql.connector.config.MongoConfig;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.config.WriteConfig;
import com.mongodb.spark.sql.connector.read.MongoScanBuilder;
import com.mongodb.spark.sql.connector.write.MongoWriteBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MongoTable
implements Table,
SupportsWrite,
SupportsRead {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoTable.class);
    private static final Set<TableCapability> TABLE_CAPABILITY_SET = new HashSet<TableCapability>(Arrays.asList(TableCapability.BATCH_WRITE, TableCapability.TRUNCATE, TableCapability.STREAMING_WRITE, TableCapability.ACCEPT_ANY_SCHEMA, TableCapability.BATCH_READ, TableCapability.MICRO_BATCH_READ, TableCapability.CONTINUOUS_READ));
    private final StructType schema;
    private final Transform[] partitioning;
    private final MongoConfig mongoConfig;

    MongoTable(MongoConfig mongoConfig) {
        this(new StructType(), mongoConfig);
    }

    MongoTable(StructType schema, MongoConfig mongoConfig) {
        this(schema, new Transform[0], mongoConfig);
    }

    MongoTable(StructType schema, Transform[] partitioning, MongoConfig mongoConfig) {
        LOGGER.info("Creating MongoTable: {}-{}", (Object)"mongo-spark-connector", (Object)"10.1.1");
        this.schema = schema;
        this.partitioning = partitioning;
        this.mongoConfig = mongoConfig;
    }

    public String name() {
        if (this.mongoConfig instanceof ReadConfig || this.mongoConfig instanceof WriteConfig) {
            return "MongoTable(" + this.mongoConfig.getNamespace() + ")";
        }
        return "MongoTable()";
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo info) {
        return new MongoWriteBuilder(info, this.mongoConfig.toWriteConfig());
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        return new MongoScanBuilder(this.schema, (ReadConfig)this.mongoConfig.toReadConfig().withOptions(options.asCaseSensitiveMap()));
    }

    public StructType schema() {
        return this.schema;
    }

    public Transform[] partitioning() {
        return this.partitioning;
    }

    public Map<String, String> properties() {
        return this.mongoConfig.getOriginals();
    }

    public Set<TableCapability> capabilities() {
        return TABLE_CAPABILITY_SET;
    }

    public String toString() {
        return "MongoTable{schema=" + this.schema + ", partitioning=" + Arrays.toString(this.partitioning) + ", mongoConfig=" + this.mongoConfig + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoTable that = (MongoTable)o;
        return Objects.equals(this.schema, that.schema) && Arrays.equals(this.partitioning, that.partitioning) && Objects.equals(this.mongoConfig, that.mongoConfig);
    }

    public int hashCode() {
        int result = Objects.hash(this.schema, this.mongoConfig);
        result = 31 * result + Arrays.hashCode(this.partitioning);
        return result;
    }
}

