/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.assertions;

import com.mongodb.spark.sql.connector.exceptions.ConfigException;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Assertions {
    public static void ensureState(Supplier<Boolean> stateCheck, Supplier<String> errorMessageSupplier) {
        if (!stateCheck.get().booleanValue()) {
            throw new IllegalStateException(errorMessageSupplier.get());
        }
    }

    public static void ensureArgument(Supplier<Boolean> argumentCheck, Supplier<String> errorMessageSupplier) {
        if (!argumentCheck.get().booleanValue()) {
            throw new IllegalArgumentException(errorMessageSupplier.get());
        }
    }

    public static <T> T validateConfig(T value, Predicate<T> predicate, Supplier<String> errorMessageSupplier) {
        if (!predicate.test(value)) {
            throw new ConfigException(errorMessageSupplier.get());
        }
        return value;
    }

    public static <T> T validateConfig(Supplier<T> valueSupplier, Supplier<String> errorMessageSupplier) {
        try {
            return valueSupplier.get();
        }
        catch (RuntimeException ex) {
            throw new ConfigException(errorMessageSupplier.get(), ex);
        }
    }

    private Assertions() {
    }
}

