/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.config;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.spark.sql.connector.assertions.Assertions;
import com.mongodb.spark.sql.connector.config.ClassHelper;
import com.mongodb.spark.sql.connector.config.MongoConfig;
import com.mongodb.spark.sql.connector.connection.LazyMongoClientCache;
import com.mongodb.spark.sql.connector.connection.MongoClientFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.bson.BsonDocument;
import org.jetbrains.annotations.TestOnly;
import scala.Tuple2;

abstract class AbstractMongoConfig
implements MongoConfig {
    private final Map<String, String> originals;
    private final Map<String, String> options;
    private final UsageMode usageMode;
    private transient MongoClientFactory mongoClientFactory;
    private transient CaseInsensitiveStringMap caseInsensitiveOptions;

    AbstractMongoConfig(Map<String, String> originals, UsageMode usageMode) {
        this.originals = Collections.unmodifiableMap(originals);
        this.usageMode = usageMode;
        Map configOptions = (Map)SparkSession.getActiveSession().map(s -> Arrays.stream(s.sparkContext().getConf().getAll()).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2))).map(m -> AbstractMongoConfig.createUsageOptions(m, usageMode)).getOrElse(HashMap::new);
        configOptions.putAll(AbstractMongoConfig.createUsageOptions(originals, usageMode));
        this.options = Collections.unmodifiableMap(configOptions);
    }

    @Override
    public Map<String, String> getOriginals() {
        return this.originals;
    }

    @Override
    public Map<String, String> getOptions() {
        if (this.caseInsensitiveOptions == null) {
            this.caseInsensitiveOptions = new CaseInsensitiveStringMap(this.options);
        }
        return this.caseInsensitiveOptions;
    }

    @Override
    public String getDatabaseName() {
        return Assertions.validateConfig(this.get("database"), Objects::nonNull, () -> "Missing configuration for: database");
    }

    @Override
    public String getCollectionName() {
        return Assertions.validateConfig(this.get("collection"), Objects::nonNull, () -> "Missing configuration for: collection");
    }

    public MongoClient getMongoClient() {
        return LazyMongoClientCache.getMongoClient(this.getMongoClientFactory());
    }

    public <T> T withClient(Function<MongoClient, T> function) {
        try (MongoClient client = this.getMongoClient();){
            T t = function.apply(client);
            return t;
        }
    }

    public void doWithClient(Consumer<MongoClient> consumer) {
        this.withClient(client -> {
            consumer.accept((MongoClient)client);
            return null;
        });
    }

    public <T> T withCollection(Function<MongoCollection<BsonDocument>, T> function) {
        try (MongoClient client = this.getMongoClient();){
            T t = function.apply((MongoCollection<BsonDocument>)client.getDatabase(this.getDatabaseName()).getCollection(this.getCollectionName(), BsonDocument.class));
            return t;
        }
    }

    public void doWithCollection(Consumer<MongoCollection<BsonDocument>> consumer) {
        this.withCollection(collection -> {
            consumer.accept((MongoCollection<BsonDocument>)collection);
            return null;
        });
    }

    public String toString() {
        String cleanedOptions = this.getOptions().entrySet().stream().map(e -> {
            String value = (String)e.getValue();
            if (((String)e.getKey()).contains("connection.uri")) {
                value = "<hidden>";
            }
            return (String)e.getKey() + "=" + value;
        }).collect(Collectors.joining(", "));
        return "MongoConfig{options=" + cleanedOptions + ", usageMode=" + (Object)((Object)this.usageMode) + '}';
    }

    @TestOnly
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMongoConfig that = (AbstractMongoConfig)o;
        return Objects.equals(this.getOptions(), that.getOptions()) && this.usageMode == that.usageMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getOptions(), this.usageMode});
    }

    Map<String, String> withOverrides(String context, Map<String, String> overrides) {
        HashMap<String, String> newOptions = new HashMap<String, String>(this.originals);
        overrides.forEach((k, v) -> {
            if (!k.startsWith(context)) {
                newOptions.put(context + k, (String)v);
            } else {
                newOptions.put((String)k, (String)v);
            }
        });
        newOptions.putAll(overrides);
        return newOptions;
    }

    private MongoClientFactory getMongoClientFactory() {
        if (this.mongoClientFactory == null) {
            String mongoClientFactoryName = this.getOptions().getOrDefault("mongoClientFactory", CLIENT_FACTORY_DEFAULT);
            this.mongoClientFactory = ClassHelper.createInstance("mongoClientFactory", mongoClientFactoryName, MongoClientFactory.class, this);
        }
        return this.mongoClientFactory;
    }

    private static Map<String, String> createUsageOptions(Map<String, String> options, UsageMode usageMode) {
        String ignorePrefix;
        String overridePrefix;
        switch (usageMode) {
            case READ: {
                overridePrefix = "spark.mongodb.read.";
                ignorePrefix = "spark.mongodb.write.";
                break;
            }
            case WRITE: {
                overridePrefix = "spark.mongodb.write.";
                ignorePrefix = "spark.mongodb.read.";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported usage mode");
            }
        }
        CaseInsensitiveStringMap localCaseInsensitiveOptions = new CaseInsensitiveStringMap(options);
        ArrayList defaults = new ArrayList();
        ArrayList overrides = new ArrayList();
        localCaseInsensitiveOptions.keySet().stream().filter(k -> k.startsWith("spark.mongodb.")).forEach(k -> {
            if (k.startsWith(overridePrefix)) {
                overrides.add(k);
            } else if (!k.startsWith(ignorePrefix)) {
                defaults.add(k);
            }
        });
        HashMap<String, String> usageSpecificOptions = new HashMap<String, String>();
        AbstractMongoConfig.addConnectionStringDatabaseAndCollection("spark.mongodb.", localCaseInsensitiveOptions, usageSpecificOptions);
        defaults.forEach(k -> usageSpecificOptions.put(k.substring("spark.mongodb.".length()), localCaseInsensitiveOptions.get(k)));
        AbstractMongoConfig.addConnectionStringDatabaseAndCollection(overridePrefix, localCaseInsensitiveOptions, usageSpecificOptions);
        overrides.forEach(k -> usageSpecificOptions.put(k.substring(overridePrefix.length()), localCaseInsensitiveOptions.get(k)));
        return usageSpecificOptions;
    }

    private static void addConnectionStringDatabaseAndCollection(String prefix, CaseInsensitiveStringMap options, Map<String, String> usageSpecificOptions) {
        if (options.containsKey((Object)(prefix + "connection.uri"))) {
            String collectionName;
            String rawConnectionString = options.get((Object)(prefix + "connection.uri"));
            ConnectionString connectionString = Assertions.validateConfig(() -> new ConnectionString(rawConnectionString), () -> String.format("Invalid connection string: '%s'", rawConnectionString));
            String databaseName = connectionString.getDatabase();
            if (databaseName != null) {
                usageSpecificOptions.put("database", databaseName);
            }
            if ((collectionName = connectionString.getCollection()) != null) {
                usageSpecificOptions.put("collection", collectionName);
            }
        }
    }

    static enum UsageMode {
        READ,
        WRITE;

    }
}

