/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.config;

import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.spark.sql.connector.config.AbstractMongoConfig;
import com.mongodb.spark.sql.connector.config.ClassHelper;
import com.mongodb.spark.sql.connector.config.MongoConfig;
import com.mongodb.spark.sql.connector.exceptions.ConfigException;
import com.mongodb.spark.sql.connector.read.partitioner.Partitioner;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;

public final class ReadConfig
extends AbstractMongoConfig {
    private static final long serialVersionUID = 1L;
    public static final String PARTITIONER_CONFIG = "partitioner";
    public static final String PARTITIONER_DEFAULT = "com.mongodb.spark.sql.connector.read.partitioner.SamplePartitioner";
    public static final String PARTITIONER_OPTIONS_PREFIX = "partitioner.options.";
    public static final String INFER_SCHEMA_SAMPLE_SIZE_CONFIG = "sampleSize";
    private static final int INFER_SCHEMA_SAMPLE_SIZE_DEFAULT = 1000;
    public static final String INFER_SCHEMA_MAP_TYPE_ENABLED_CONFIG = "sql.inferSchema.mapTypes.enabled";
    private static final boolean INFER_SCHEMA_MAP_TYPE_ENABLED_DEFAULT = true;
    public static final String INFER_SCHEMA_MAP_TYPE_MINIMUM_KEY_SIZE_CONFIG = "sql.inferSchema.mapTypes.minimum.key.size";
    private static final int INFER_SCHEMA_MAP_TYPE_MINIMUM_KEY_SIZE_DEFAULT = 250;
    public static final String AGGREGATION_PIPELINE_CONFIG = "aggregation.pipeline";
    public static final String AGGREGATION_PIPELINE_DEFAULT = "";
    public static final String AGGREGATION_ALLOW_DISK_USE_CONFIG = "aggregation.allowDiskUse";
    private static final boolean AGGREGATION_ALLOW_DISK_USE_DEFAULT = true;
    public static final String STREAM_PUBLISH_FULL_DOCUMENT_ONLY_CONFIG = "change.stream.publish.full.document.only";
    private static final boolean STREAM_PUBLISH_FULL_DOCUMENT_ONLY_DEFAULT = false;
    public static final String STREAM_LOOKUP_FULL_DOCUMENT_CONFIG = "change.stream.lookup.full.document";
    private static final String STREAM_LOOKUP_FULL_DOCUMENT_DEFAULT = FullDocument.DEFAULT.getValue();
    public static final String OUTPUT_EXTENDED_JSON_CONFIG = "outputExtendedJson";
    private static final boolean OUTPUT_EXTENDED_JSON_DEFAULT = false;
    private final List<BsonDocument> aggregationPipeline = this.generateAggregationPipeline();

    ReadConfig(Map<String, String> options) {
        super(options, AbstractMongoConfig.UsageMode.READ);
    }

    @Override
    public ReadConfig withOption(String key, String value) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(key, value);
        return this.withOptions(options);
    }

    @Override
    public ReadConfig withOptions(Map<String, String> options) {
        if (options.isEmpty()) {
            return this;
        }
        return new ReadConfig(this.withOverrides("spark.mongodb.read.", options));
    }

    public int getInferSchemaSampleSize() {
        return this.getInt(INFER_SCHEMA_SAMPLE_SIZE_CONFIG, 1000);
    }

    public boolean inferSchemaMapType() {
        return this.getBoolean(INFER_SCHEMA_MAP_TYPE_ENABLED_CONFIG, true);
    }

    public int getInferSchemaMapTypeMinimumKeySize() {
        return this.getInt(INFER_SCHEMA_MAP_TYPE_MINIMUM_KEY_SIZE_CONFIG, 250);
    }

    public Partitioner getPartitioner() {
        return ClassHelper.createInstance(PARTITIONER_CONFIG, this.getOrDefault(PARTITIONER_CONFIG, PARTITIONER_DEFAULT), Partitioner.class, this);
    }

    public MongoConfig getPartitionerOptions() {
        return this.subConfiguration(PARTITIONER_OPTIONS_PREFIX);
    }

    public List<BsonDocument> getAggregationPipeline() {
        return this.aggregationPipeline;
    }

    public boolean getAggregationAllowDiskUse() {
        return this.getBoolean(AGGREGATION_ALLOW_DISK_USE_CONFIG, true);
    }

    public boolean streamPublishFullDocumentOnly() {
        return this.getBoolean(STREAM_PUBLISH_FULL_DOCUMENT_ONLY_CONFIG, false);
    }

    public FullDocument getStreamFullDocument() {
        if (this.streamPublishFullDocumentOnly()) {
            return FullDocument.UPDATE_LOOKUP;
        }
        try {
            return FullDocument.fromString((String)this.getOrDefault(STREAM_LOOKUP_FULL_DOCUMENT_CONFIG, STREAM_LOOKUP_FULL_DOCUMENT_DEFAULT));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(e);
        }
    }

    public boolean outputExtendedJson() {
        return this.getBoolean(OUTPUT_EXTENDED_JSON_CONFIG, false);
    }

    private List<BsonDocument> generateAggregationPipeline() {
        String pipelineJson = this.getOrDefault(AGGREGATION_PIPELINE_CONFIG, AGGREGATION_PIPELINE_DEFAULT);
        if (pipelineJson.isEmpty()) {
            return Collections.emptyList();
        }
        BsonValue pipeline = BsonDocument.parse((String)String.format("{pipeline: %s}", pipelineJson)).get((Object)"pipeline");
        switch (pipeline.getBsonType()) {
            case ARRAY: {
                BsonArray bsonValues = pipeline.asArray();
                if (bsonValues.isEmpty()) {
                    return Collections.emptyList();
                }
                if (bsonValues.stream().anyMatch(b -> b.getBsonType() != BsonType.DOCUMENT)) {
                    throw new ConfigException("Invalid aggregation pipeline: " + pipelineJson);
                }
                return Collections.unmodifiableList(bsonValues.stream().map(BsonValue::asDocument).collect(Collectors.toList()));
            }
            case DOCUMENT: {
                return Collections.singletonList(pipeline.asDocument());
            }
        }
        throw new ConfigException("Invalid aggregation pipeline: " + pipelineJson);
    }
}

