/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.spark.sql.connector.assertions.Assertions;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.read.MongoContinuousInputPartition;
import com.mongodb.spark.sql.connector.read.MongoContinuousPartitionReader;
import com.mongodb.spark.sql.connector.schema.BsonDocumentToRowConverter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.streaming.ContinuousPartitionReader;
import org.apache.spark.sql.connector.read.streaming.ContinuousPartitionReaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MongoContinuousPartitionReaderFactory
implements ContinuousPartitionReaderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoContinuousPartitionReaderFactory.class);
    private static final long serialVersionUID = 1L;
    private final BsonDocumentToRowConverter bsonDocumentToRowConverter;
    private final ReadConfig readConfig;

    MongoContinuousPartitionReaderFactory(BsonDocumentToRowConverter bsonDocumentToRowConverter, ReadConfig readConfig) {
        this.bsonDocumentToRowConverter = bsonDocumentToRowConverter;
        this.readConfig = readConfig;
    }

    public ContinuousPartitionReader<InternalRow> createReader(InputPartition partition) {
        Assertions.ensureState(() -> partition instanceof MongoContinuousInputPartition, () -> String.format("Unsupported InputPartition type, a MongoContinuousInputPartition instance is required. Got: %s", partition.getClass()));
        LOGGER.debug("Creating MongoStreamPartitionReader for {}", (Object)partition);
        return new MongoContinuousPartitionReader((MongoContinuousInputPartition)partition, this.bsonDocumentToRowConverter, this.readConfig);
    }
}

