/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.spark.sql.connector.read.MongoInputPartition;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

final class MongoMicroBatchInputPartition
extends MongoInputPartition {
    private static final long serialVersionUID = 1L;
    private final LongOffset startOffset;
    private final LongOffset endOffset;

    MongoMicroBatchInputPartition(int partitionId, List<BsonDocument> pipeline, LongOffset startOffset, LongOffset endOffset) {
        super(partitionId, pipeline);
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public BsonTimestamp getStartOffsetTimestamp() {
        return new BsonTimestamp((int)this.startOffset.offset(), 0);
    }

    public BsonTimestamp getEndOffsetTimestamp() {
        return new BsonTimestamp((int)this.endOffset.offset(), 0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MongoMicroBatchInputPartition that = (MongoMicroBatchInputPartition)o;
        return Objects.equals(this.startOffset, that.startOffset) && Objects.equals(this.endOffset, that.endOffset);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.startOffset, this.endOffset);
    }

    @Override
    public String toString() {
        return "MongoMicroBatchInputPartition{partitionId=" + this.getPartitionId() + ", pipeline=" + this.getPipeline().stream().map(BsonDocument::toJson).collect(Collectors.joining(",", "[", "]")) + ", preferredLocations=" + Arrays.toString(this.preferredLocations()) + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + "} ";
    }
}

