/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.MongoClient;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.spark.sql.connector.assertions.Assertions;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.exceptions.MongoSparkException;
import com.mongodb.spark.sql.connector.read.MongoMicroBatchInputPartition;
import com.mongodb.spark.sql.connector.read.ResumeTokenTimestampHelper;
import com.mongodb.spark.sql.connector.schema.BsonDocumentToRowConverter;
import java.util.ArrayList;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MongoMicroBatchPartitionReader
implements PartitionReader<InternalRow> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoMicroBatchPartitionReader.class);
    private static final String FULL_DOCUMENT = "fullDocument";
    private final MongoMicroBatchInputPartition partition;
    private final BsonDocumentToRowConverter bsonDocumentToRowConverter;
    private final ReadConfig readConfig;
    private final MongoClient mongoClient;
    private volatile boolean closed = false;
    private MongoChangeStreamCursor<BsonDocument> changeStreamCursor;
    private InternalRow currentRow;

    MongoMicroBatchPartitionReader(MongoMicroBatchInputPartition partition, BsonDocumentToRowConverter bsonDocumentToRowConverter, ReadConfig readConfig) {
        this.partition = partition;
        this.bsonDocumentToRowConverter = bsonDocumentToRowConverter;
        this.readConfig = readConfig;
        this.mongoClient = readConfig.getMongoClient();
        LOGGER.info("Creating partition reader for: PartitionId: {} with Schema: {}", (Object)partition.getPartitionId(), (Object)bsonDocumentToRowConverter.getSchema());
    }

    public boolean next() {
        boolean hasNext;
        BsonDocument cursorNext;
        Assertions.ensureState(() -> !this.closed, () -> "Cannot call next() on a closed PartitionReader.");
        MongoChangeStreamCursor<BsonDocument> cursor = this.getCursor();
        do {
            try {
                cursorNext = (BsonDocument)cursor.tryNext();
            }
            catch (RuntimeException e) {
                throw new MongoSparkException("Calling `cursor.tryNext()` errored.", e);
            }
        } while (cursorNext == null && cursor.getServerCursor() != null && (cursor.getResumeToken() == null || ResumeTokenTimestampHelper.getTimestamp(cursor.getResumeToken()).compareTo(this.partition.getEndOffsetTimestamp()) <= 0));
        boolean bl = hasNext = cursorNext != null;
        if (hasNext) {
            if (this.readConfig.streamPublishFullDocumentOnly()) {
                cursorNext = cursorNext.getDocument((Object)FULL_DOCUMENT, new BsonDocument());
            }
            this.currentRow = this.bsonDocumentToRowConverter.toInternalRow(cursorNext);
        }
        return hasNext;
    }

    public InternalRow get() {
        Assertions.ensureState(() -> !this.closed, () -> "Cannot call get() on a closed PartitionReader.");
        return this.currentRow;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.changeStreamCursor != null) {
                LOGGER.debug("Closing cursor for partitionId: {}", (Object)this.partition.getPartitionId());
                try {
                    this.changeStreamCursor.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.changeStreamCursor = null;
                }
            }
            this.mongoClient.close();
        }
    }

    private MongoChangeStreamCursor<BsonDocument> getCursor() {
        if (this.changeStreamCursor == null) {
            ArrayList<BsonDocument> pipeline = new ArrayList<BsonDocument>();
            pipeline.add(Aggregates.match((Bson)Filters.lt((String)"clusterTime", (Object)this.partition.getEndOffsetTimestamp())).toBsonDocument());
            if (this.readConfig.streamPublishFullDocumentOnly()) {
                pipeline.add(Aggregates.match((Bson)Filters.exists((String)FULL_DOCUMENT)).toBsonDocument());
            }
            pipeline.addAll(this.partition.getPipeline());
            ChangeStreamIterable changeStreamIterable = this.mongoClient.getDatabase(this.readConfig.getDatabaseName()).getCollection(this.readConfig.getCollectionName()).watch(pipeline).fullDocument(this.readConfig.getStreamFullDocument());
            if (this.partition.getStartOffsetTimestamp().getTime() >= 0) {
                changeStreamIterable.startAtOperationTime(this.partition.getStartOffsetTimestamp());
            }
            try {
                this.changeStreamCursor = (MongoChangeStreamCursor)changeStreamIterable.withDocumentClass(BsonDocument.class).cursor();
                LOGGER.debug("Opened change stream cursor for partition: {}", (Object)this.partition);
            }
            catch (RuntimeException e) {
                throw new MongoSparkException("Could not create the change stream cursor.", e);
            }
        }
        return this.changeStreamCursor;
    }
}

