/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.read.MongoBatch;
import com.mongodb.spark.sql.connector.read.MongoContinuousStream;
import com.mongodb.spark.sql.connector.read.MongoMicroBatchStream;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.streaming.ContinuousStream;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.types.StructType;

final class MongoScan
implements Scan {
    private final StructType schema;
    private final ReadConfig readConfig;

    MongoScan(StructType schema, ReadConfig readConfig) {
        this.schema = schema;
        this.readConfig = readConfig;
    }

    public StructType readSchema() {
        return this.schema;
    }

    public String description() {
        return "MongoScan{namespace=" + this.readConfig.getNamespace().toString() + '}';
    }

    public Batch toBatch() {
        return new MongoBatch(this.schema, this.readConfig);
    }

    public MicroBatchStream toMicroBatchStream(String checkpointLocation) {
        return new MongoMicroBatchStream(this.schema, this.readConfig);
    }

    public ContinuousStream toContinuousStream(String checkpointLocation) {
        return new MongoContinuousStream(this.schema, this.readConfig);
    }
}

