/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.spark.sql.connector.exceptions.MongoSparkException;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.bson.BsonDocument;

final class ResumeTokenOffset
extends Offset {
    static final ResumeTokenOffset INITIAL_RESUME_TOKEN_OFFSET = new ResumeTokenOffset(new BsonDocument());
    private final BsonDocument resumeToken;

    public static ResumeTokenOffset parse(String json) {
        try {
            return new ResumeTokenOffset(BsonDocument.parse((String)json));
        }
        catch (RuntimeException ex) {
            throw new MongoSparkException("Unable to parse the json string into a resume token. " + ex.getMessage(), ex);
        }
    }

    ResumeTokenOffset(BsonDocument resumeToken) {
        this.resumeToken = resumeToken != null ? resumeToken : new BsonDocument();
    }

    public BsonDocument getResumeToken() {
        return this.resumeToken;
    }

    public String json() {
        return this.resumeToken.toJson();
    }
}

