/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.spark.sql.connector.assertions.Assertions;
import java.util.Objects;
import org.apache.spark.sql.connector.read.streaming.PartitionOffset;
import org.bson.BsonDocument;

final class ResumeTokenPartitionOffset
implements PartitionOffset {
    private static final long serialVersionUID = 1L;
    private final BsonDocument resumeToken;

    ResumeTokenPartitionOffset(BsonDocument resumeToken) {
        Assertions.ensureArgument(() -> resumeToken != null, () -> "Invalid resume token");
        this.resumeToken = resumeToken;
    }

    BsonDocument getResumeToken() {
        return this.resumeToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResumeTokenPartitionOffset that = (ResumeTokenPartitionOffset)o;
        return Objects.equals(this.getResumeToken(), that.getResumeToken());
    }

    public int hashCode() {
        return Objects.hash(this.getResumeToken());
    }

    public String toString() {
        return "ResumeTokenPartitionOffset{resumeToken=" + this.resumeToken.toJson() + '}';
    }
}

