/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.write;

import com.mongodb.client.MongoCollection;
import com.mongodb.spark.sql.connector.config.WriteConfig;
import com.mongodb.spark.sql.connector.exceptions.DataException;
import com.mongodb.spark.sql.connector.write.MongoDataWriterFactory;
import java.util.Arrays;
import java.util.Objects;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MongoBatchWrite
implements BatchWrite {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoBatchWrite.class);
    private final LogicalWriteInfo info;
    private final WriteConfig writeConfig;
    private final boolean truncate;

    MongoBatchWrite(LogicalWriteInfo info, WriteConfig writeConfig, boolean truncate) {
        this.info = info;
        this.writeConfig = writeConfig;
        this.truncate = truncate;
    }

    public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo physicalWriteInfo) {
        if (this.truncate) {
            this.writeConfig.doWithCollection(MongoCollection::drop);
        }
        return new MongoDataWriterFactory(this.info.schema(), this.writeConfig);
    }

    public void commit(WriterCommitMessage[] messages) {
        LOGGER.debug("Write committed for: {}, with {} task(s).", (Object)this.info.queryId(), (Object)messages.length);
    }

    public void abort(WriterCommitMessage[] messages) {
        long tasksCompleted = Arrays.stream(messages).filter(Objects::nonNull).count();
        throw new DataException(String.format("Write aborted for: %s. %s/%s tasks completed.", this.info.queryId(), tasksCompleted, messages.length));
    }
}

