/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.IOException;
import java.security.Principal;
import org.mortbay.jetty.Authenticator;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.UserRealm;
import org.mortbay.jetty.security.B64Code;
import org.mortbay.log.Log;
import org.mortbay.util.StringUtil;

public class BasicAuthenticator
implements Authenticator {
    public Principal authenticate(UserRealm realm, String pathInContext, Request request, Response response) throws IOException {
        Principal user = null;
        String credentials = request.getHeader("Authorization");
        if (credentials != null) {
            try {
                String password;
                int i;
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Credentials: " + credentials));
                }
                credentials = credentials.substring(credentials.indexOf(32) + 1);
                String username = (credentials = B64Code.decode(credentials, StringUtil.__ISO_8859_1)).substring(0, i = credentials.indexOf(58));
                user = realm.authenticate(username, (Object)(password = credentials.substring(i + 1)), request);
                if (user == null) {
                    Log.warn((String)"AUTH FAILURE: user {}", (Object)StringUtil.printable((String)username));
                } else {
                    request.setAuthType("BASIC");
                    request.setUserPrincipal(user);
                }
            }
            catch (Exception e) {
                Log.warn((String)("AUTH FAILURE: " + e.toString()));
                Log.ignore((Throwable)e);
            }
        }
        if (user == null && response != null) {
            this.sendChallenge(realm, response);
        }
        return user;
    }

    public String getAuthMethod() {
        return "BASIC";
    }

    public void sendChallenge(UserRealm realm, Response response) throws IOException {
        response.setHeader("WWW-Authenticate", "Basic realm=\"" + realm.getName() + '\"');
        response.sendError(401);
    }
}

