/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.database;

import java.util.Collection;
import org.mule.api.MuleEvent;
import org.mule.api.registry.MuleRegistry;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.resolver.database.AbstractDbConfigResolver;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.database.UnresolvableDbConfigException;

public class DefaultDbConfigResolver
extends AbstractDbConfigResolver {
    private final MuleRegistry registry;
    private DbConfigResolver defaultConfigResolver;

    public DefaultDbConfigResolver(MuleRegistry registry) {
        this.registry = registry;
    }

    private DbConfigResolver getDefaultConfigResolver() {
        Collection dbConfigResolvers = this.registry.lookupObjects(DbConfigResolver.class);
        if (dbConfigResolvers.isEmpty()) {
            throw new UnresolvableDbConfigException("There is no database config defined");
        }
        if (dbConfigResolvers.size() > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            for (DbConfigResolver dbConfigResolver : dbConfigResolvers) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(dbConfigResolver.resolve(null).getName());
            }
            throw new UnresolvableDbConfigException("Database config must be explicitly defined using 'config-ref' attribute there are multiple database configs defined: " + stringBuilder);
        }
        return (DbConfigResolver)dbConfigResolvers.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbConfig resolve(MuleEvent muleEvent) {
        if (this.defaultConfigResolver == null) {
            DefaultDbConfigResolver defaultDbConfigResolver = this;
            synchronized (defaultDbConfigResolver) {
                if (this.defaultConfigResolver == null) {
                    this.defaultConfigResolver = this.getDefaultConfigResolver();
                }
            }
        }
        return this.defaultConfigResolver.resolve(muleEvent);
    }
}

