/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.Accessor;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.OptimizerFactory;

public class InlineCollectionNode
extends ASTNode {
    private transient Accessor accessor;

    public InlineCollectionNode(char[] expr, int start, int end, int fields) {
        super(expr, start, end, fields | 0x8000);
        if ((fields & 0x10) != 0) {
            AccessorOptimizer ao = OptimizerFactory.getDefaultAccessorCompiler();
            this.accessor = ao.optimizeCollection(this.name, null, null, null);
            this.egressType = ao.getEgressType();
        }
    }

    public InlineCollectionNode(char[] expr, int fields) {
        super(expr, fields);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            return this.accessor.getValue(ctx, thisValue, factory);
        }
        catch (NullPointerException e) {
            if (this.accessor == null) {
                AccessorOptimizer ao = OptimizerFactory.getDefaultAccessorCompiler();
                this.accessor = ao.optimizeCollection(this.name, ctx, thisValue, factory);
                this.egressType = ao.getEgressType();
                return this.accessor.getValue(ctx, thisValue, factory);
            }
            throw e;
        }
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE).optimizeCollection(this.name, ctx, thisValue, factory).getValue(ctx, thisValue, factory);
    }
}

