/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.mvel.CompileException;
import org.mvel.ExpressionCompiler;
import org.mvel.ParserContext;
import org.mvel.PropertyAccessException;
import org.mvel.optimizers.AbstractOptimizer;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.StringAppender;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyVerifier
extends AbstractOptimizer {
    private static final int DONE = -1;
    private static final int NORM = 0;
    private static final int METH = 1;
    private static final int COL = 2;
    private ParserContext parserContext;
    private List<String> inputs = new LinkedList<String>();
    private boolean first = true;
    private boolean resolvedExternally;

    public PropertyVerifier(char[] property, ParserContext parserContext) {
        this.expr = property;
        this.length = property.length;
        this.parserContext = parserContext;
    }

    public PropertyVerifier(String property, ParserContext parserContext) {
        this.expr = property.toCharArray();
        this.length = this.expr.length;
        this.parserContext = parserContext;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    public Class analyze() {
        Class clazz;
        try {
            clazz = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Class ctx = clazz;
        this.resolvedExternally = true;
        this.first = true;
        while (this.cursor < this.length) {
            switch (this.nextSubToken()) {
                case 0: {
                    ctx = this.getBeanProperty(ctx, this.capture());
                    break;
                }
                case 1: {
                    ctx = this.getMethod(ctx, this.capture());
                    break;
                }
                case 2: {
                    ctx = this.getCollectionProperty();
                    break;
                }
            }
            this.first = false;
        }
        return ctx;
    }

    private Class getBeanProperty(Class ctx, String property) {
        Class<?> clazz;
        Member member;
        if (this.first) {
            Class<?> clazz2;
            if (this.parserContext.hasVarOrInput(property)) {
                return this.parserContext.getVarOrInputType(property);
            }
            if (this.parserContext.hasImport(property)) {
                this.resolvedExternally = false;
                return this.parserContext.getImport(property);
            }
            try {
                clazz2 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz2;
        }
        this.start = this.cursor;
        Member member2 = member = ctx != null ? PropertyTools.getFieldOrAccessor(ctx, property) : null;
        if (member instanceof Field) {
            return ((Field)member).getType();
        }
        if (member != null) {
            return ((Method)member).getReturnType();
        }
        if (this.parserContext.hasImport(property)) {
            return this.parserContext.getImport(property);
        }
        Object tryStaticMethodRef = this.tryStaticAccess();
        if (tryStaticMethodRef != null) {
            if (tryStaticMethodRef instanceof Class) {
                return tryStaticMethodRef.getClass();
            }
            try {
                return ((Field)tryStaticMethodRef).get(null).getClass();
            }
            catch (Exception e) {
                throw new CompileException("in verifier: ", e);
            }
        }
        if (ctx != null) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("java.lang.Class");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (ctx.getClass() == clazz3) {
                Method[] methodArray = ctx.getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    if (property.equals(m.getName())) {
                        return m.getReturnType();
                    }
                    ++n2;
                }
            }
        }
        if (this.parserContext.isStrictTypeEnforcement()) {
            this.addFatalError(new StringBuffer("unqualified type in strict mode for: ").append(property).toString());
        }
        try {
            clazz = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return clazz;
    }

    private Class getCollectionProperty() {
        Class<?> clazz;
        int start = ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.length) {
            throw new PropertyAccessException("unterminated '['");
        }
        if (!this.scanTo(']')) {
            this.addFatalError("unterminated [ in token");
        }
        ExpressionCompiler compiler = new ExpressionCompiler(new String(this.expr, start, this.cursor - start));
        compiler._compile();
        ++this.cursor;
        if (compiler.getReturnType() == null) {
            try {
                clazz = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } else {
            clazz = compiler.getReturnType();
        }
        return clazz;
    }

    private Class getMethod(Class ctx, String name) {
        Class[] args;
        if (this.first && this.parserContext.hasImport(name)) {
            Method m = this.parserContext.getStaticImport(name).getMethod();
            ctx = m.getDeclaringClass();
            name = m.getName();
            this.first = false;
        }
        int st = this.cursor;
        this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, '(');
        String tk = this.cursor - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        if (tk.length() > 0) {
            String[] stringArray = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                new ExpressionCompiler(token)._compile();
                ++n2;
            }
        }
        if (tk.length() == 0) {
            args = new Class[]{};
        } else {
            String[] subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            args = new Class[subtokens.length];
            int i = 0;
            while (i < subtokens.length) {
                Class<?> clazz;
                ExpressionCompiler compiler = new ExpressionCompiler(subtokens[i], true);
                compiler._compile();
                if (compiler.getReturnType() != null) {
                    clazz = compiler.getReturnType();
                } else {
                    try {
                        clazz = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                args[i] = clazz;
                ++i;
            }
        }
        Method m = ParseTools.getBestCandidate(args, name, ctx.getMethods());
        if (m == null && (m = ParseTools.getBestCandidate(args, name, ctx.getDeclaredMethods())) == null) {
            Class<?> clazz;
            StringAppender errorBuild = new StringAppender();
            int i = 0;
            while (i < args.length) {
                errorBuild.append(args[i] != null ? args[i].getClass().getName() : null);
                if (i < args.length - 1) {
                    errorBuild.append(", ");
                }
                ++i;
            }
            if ("size".equals(name) && args.length == 0 && ctx.isArray()) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz2;
            }
            if (this.parserContext.isStrictTypeEnforcement()) {
                this.addFatalError(new StringBuffer("unable to resolve method using strict-mode: ").append(ctx.getName()).append(".").append(name).append("(...)").toString());
            }
            try {
                clazz = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        return m.getReturnType();
    }

    public boolean isResolvedExternally() {
        return this.resolvedExternally;
    }
}

