/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests.perftests;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mvel.MVEL;
import org.mvel.TemplateInterpreter;
import org.mvel.tests.main.res.Bar;
import org.mvel.tests.main.res.Base;
import org.mvel.tests.main.res.Foo;

public class ParserPerformanceTests {
    private static final int COUNT = 10000;
    Foo foo = new Foo();
    Map<String, Object> map = new HashMap<String, Object>(100);
    Base base = new Base();
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.mvel.tests.perftests.ParserPerformanceTests");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ParserPerformanceTests() {
        this.foo.setBar(new Bar());
        this.map.put("foo", this.foo);
        this.map.put("a", null);
        this.map.put("b", null);
        this.map.put("c", "cat");
        this.map.put("BWAH", "");
        this.map.put("bar2", new Base());
        this.map.put("pi", "3.14");
        this.map.put("hour", "60");
    }

    public void testSimplePropertyAccessPerf() {
        int i = 0;
        while (i < 10000) {
            this.parseDirect("((hour + 10 - 1) == 69) && c == 'cat'");
            ++i;
        }
    }

    public void testSimplePropertyAccessPerf2() {
        this.testSimplePropertyAccessPerf();
    }

    public void testDeepPropertyAccessPerf() {
        int i = 0;
        while (i < 10000) {
            this.parseDirect("foo.bar.name");
            ++i;
        }
    }

    public void testDeepPropertyAccessPerf2() {
        this.testDeepPropertyAccessPerf();
    }

    public void testSimplePropertyAccessPerfDirect() {
        int i = 0;
        while (i < 10000) {
            this.parseDirect("hour != null");
            ++i;
        }
    }

    public void testPreCompiledB() {
        Serializable ex = MVEL.compileExpression("((hour + 10 - 1) == 69) && c == 'cat'");
        int i = 0;
        while (i < 10000) {
            MVEL.executeExpression((Object)ex, null, this.map);
            ++i;
        }
        MVEL.executeExpression((Object)ex, null, this.map);
    }

    public void testPreCompiledB2() {
        this.testPreCompiledB();
    }

    public void testPreCompiledB3() {
        this.testPreCompiledB();
    }

    public void testPreCompiledC() {
        Serializable ex = MVEL.compileExpression("hour");
        int i = 0;
        while (i < 10000) {
            if (!$assertionsDisabled && !"60".equals(MVEL.executeExpression((Object)ex, null, this.map))) {
                throw new AssertionError();
            }
            ++i;
        }
        MVEL.executeExpression((Object)ex, null, this.map);
    }

    public void testSimplePropertyAccessPerfDirect2() {
        this.testSimplePropertyAccessPerfDirect();
    }

    public void testLogicPerformance() {
        int i = 0;
        while (i < 10000) {
            this.parseDirect("a != null && pi == 3.14");
            ++i;
        }
    }

    public void testRegularExpression() {
        int i = 0;
        while (i < 10000) {
            this.parse("@{c ~= '[a-z].+'}");
            ++i;
        }
    }

    public void testObjectCreation() {
        int i = 0;
        while (i < 10000) {
            this.parse("@{new String('hello')}");
            ++i;
        }
    }

    public Object parse(String ex) {
        return new TemplateInterpreter(ex).execute(this.base, this.map);
    }

    public Object parseDirect(String ex) {
        return MVEL.eval(ex, (Object)this.base, this.map);
    }
}

