/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.mvel.AbstractParser;
import org.mvel.CompileException;
import org.mvel.ExpressionCompiler;
import org.mvel.ParserContext;
import org.mvel.PropertyAccessException;
import org.mvel.optimizers.AbstractOptimizer;
import org.mvel.optimizers.impl.refl.FieldAccessor;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.StringAppender;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyVerifier
extends AbstractOptimizer {
    private static final int DONE = -1;
    private static final int NORM = 0;
    private static final int METH = 1;
    private static final int COL = 2;
    private ParserContext parserContext;
    private List<String> inputs = new LinkedList<String>();
    private boolean first = true;

    public PropertyVerifier(char[] property, ParserContext parserContext) {
        this.expr = property;
        this.length = property.length;
        this.parserContext = parserContext;
    }

    public PropertyVerifier(String property, ParserContext parserContext) {
        this.expr = property.toCharArray();
        this.length = this.expr.length;
        this.parserContext = parserContext;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    public Class analyze() {
        Class clazz;
        try {
            clazz = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Class ctx = clazz;
        this.first = true;
        while (this.cursor < this.length) {
            switch (this.nextSubToken()) {
                case 0: {
                    ctx = this.getBeanProperty(ctx, this.capture());
                    break;
                }
                case 1: {
                    ctx = this.getMethod(ctx, this.capture());
                    break;
                }
                case 2: {
                    ctx = this.getCollectionProperty();
                    break;
                }
            }
            this.first = false;
        }
        return ctx;
    }

    private Class getBeanProperty(Class ctx, String property) {
        Class<?> clazz;
        Member member;
        if (this.first) {
            Class<?> clazz2;
            if (this.parserContext.hasVarOrInput(property)) {
                return this.parserContext.getVarOrInputType(property);
            }
            if (AbstractParser.LITERALS.containsKey(property)) {
                return (Class)AbstractParser.LITERALS.get(property);
            }
            try {
                clazz2 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz2;
        }
        this.start = this.cursor;
        Member member2 = member = ctx != null ? PropertyTools.getFieldOrAccessor(ctx, property) : null;
        if (member instanceof Field) {
            FieldAccessor accessor = new FieldAccessor();
            accessor.setField((Field)member);
            return ((Field)member).getType();
        }
        if (member != null) {
            return ((Method)member).getReturnType();
        }
        if (AbstractParser.LITERALS.containsKey(property)) {
            return (Class)AbstractParser.LITERALS.get(property);
        }
        Object tryStaticMethodRef = this.tryStaticAccess();
        if (tryStaticMethodRef != null) {
            if (tryStaticMethodRef instanceof Class) {
                return tryStaticMethodRef.getClass();
            }
            try {
                return ((Field)tryStaticMethodRef).get(null).getClass();
            }
            catch (Exception e) {
                throw new CompileException("in verifier: ", e);
            }
        }
        if (ctx != null) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("java.lang.Class");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (ctx.getClass() == clazz3) {
                Method[] methodArray = ctx.getMethods();
                int n = 0;
                int n2 = methodArray.length;
                while (n < n2) {
                    Method m = methodArray[n];
                    if (property.equals(m.getName())) {
                        return m.getReturnType();
                    }
                    ++n;
                }
            }
        }
        if (this.parserContext.isStrictTypeEnforcement()) {
            this.addFatalError(new StringBuffer("unqualified type in strict mode for: ").append(property).toString());
        }
        try {
            clazz = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return clazz;
    }

    private Class getCollectionProperty() {
        Class<?> clazz;
        int start = ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.length) {
            throw new PropertyAccessException("unterminated '['");
        }
        if (!this.scanTo(']')) {
            this.addFatalError("unterminated [ in token");
        }
        ExpressionCompiler compiler = new ExpressionCompiler(new String(this.expr, start, this.cursor - start));
        compiler._compile();
        ++this.cursor;
        if (compiler.getReturnType() == null) {
            try {
                clazz = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } else {
            clazz = compiler.getReturnType();
        }
        return clazz;
    }

    private Class getMethod(Class ctx, String name) {
        Class[] args;
        if (this.first && this.parserContext.hasImport(name)) {
            Method m = this.parserContext.getStaticImport(name);
            ctx = m.getDeclaringClass();
            name = m.getName();
            this.first = false;
        }
        int st = this.cursor;
        int depth = 1;
        while (this.cursor++ < this.length - 1 && depth != 0) {
            switch (this.expr[this.cursor]) {
                case '(': {
                    ++depth;
                    break;
                }
                case ')': {
                    --depth;
                }
            }
        }
        --this.cursor;
        String tk = this.cursor - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        if (tk.length() > 0) {
            String[] subtokens;
            String[] stringArray = subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String token = stringArray[n];
                ExpressionCompiler verifCompiler = new ExpressionCompiler(token);
                verifCompiler._compile();
                ++n;
            }
        }
        if (tk.length() == 0) {
            args = new Class[]{};
        } else {
            String[] subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            args = new Class[subtokens.length];
            int i = 0;
            while (i < subtokens.length) {
                ExpressionCompiler compiler = new ExpressionCompiler(subtokens[i]);
                compiler.setVerifying(true);
                compiler._compile();
                args[i] = compiler.getReturnType();
                ++i;
            }
        }
        Method m = ParseTools.getBestCandidate(args, name, ctx.getMethods());
        if (m == null && (m = ParseTools.getBestCandidate(args, name, ctx.getDeclaredMethods())) == null) {
            Class<?> clazz;
            StringAppender errorBuild = new StringAppender();
            int i = 0;
            while (i < args.length) {
                errorBuild.append(args[i] != null ? args[i].getClass().getName() : null);
                if (i < args.length - 1) {
                    errorBuild.append(", ");
                }
                ++i;
            }
            if ("size".equals(name) && args.length == 0 && ctx.isArray()) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return clazz2;
            }
            if (this.parserContext.isStrictTypeEnforcement()) {
                this.addFatalError(new StringBuffer("unable to resolve method using strict-mode: ").append(ctx.getName()).append(".").append(name).append("(...)").toString());
            }
            try {
                clazz = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        return m.getReturnType();
    }
}

