/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import java.util.ArrayList;
import org.mvel.CompileException;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.ast.BlockNode;
import org.mvel.ast.NestedStatement;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ParseTools;

public class WithNode
extends BlockNode
implements NestedStatement {
    private ExecutableStatement nestedStatement;
    private ParmValuePair[] withExpressions;

    public WithNode(char[] expr, char[] block, int fields) {
        super(expr, fields, block);
        this.nestedStatement = (ExecutableStatement)ParseTools.subCompileExpression(new String(expr).trim());
        this.compileWithExpressions();
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        Object ctxObject = this.nestedStatement.getValue(ctx, thisValue, factory);
        ParmValuePair[] parmValuePairArray = this.withExpressions;
        int n = 0;
        int n2 = parmValuePairArray.length;
        while (n < n2) {
            ParmValuePair pvp = parmValuePairArray[n];
            if (pvp.getParameter() != null) {
                MVEL.setProperty(ctxObject, pvp.getParameter(), pvp.getStatement().getValue(ctx, thisValue, factory));
            } else {
                pvp.getStatement().getValue(ctxObject, ctxObject, factory);
            }
            ++n;
        }
        return ctxObject;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }

    private void compileWithExpressions() {
        ArrayList<ParmValuePair> parms = new ArrayList<ParmValuePair>();
        int start = 0;
        String parm = "";
        int i = 0;
        while (i < this.block.length) {
            switch (this.block[i]) {
                case '(': 
                case '[': 
                case '{': {
                    i = ParseTools.balancedCapture(this.block, i, this.block[i]);
                    if (i != -1) break;
                    throw new CompileException("unbalanced braces", this.block, i);
                }
                case '=': {
                    parm = new String(this.block, start, i - start).trim();
                    start = ++i;
                    break;
                }
                case ',': {
                    if (parm == null) {
                        parms.add(new ParmValuePair(null, (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.subset(this.block, start, i - start))));
                        start = ++i;
                        break;
                    }
                    parms.add(new ParmValuePair(parm, (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.subset(this.block, start, i - start))));
                    parm = null;
                    start = ++i;
                }
            }
            ++i;
        }
        if (parm != null && start != this.block.length) {
            parms.add(new ParmValuePair(parm, (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.subset(this.block, start, this.block.length - start))));
        }
        this.withExpressions = new ParmValuePair[parms.size()];
        parms.toArray(this.withExpressions);
    }

    public ExecutableStatement getNestedStatement() {
        return this.nestedStatement;
    }

    public ParmValuePair[] getWithExpressions() {
        return this.withExpressions;
    }

    public static final class ParmValuePair {
        private String parameter;
        private ExecutableStatement statement;

        public ParmValuePair() {
        }

        public ParmValuePair(String parameter, ExecutableStatement statement) {
            this.parameter = parameter;
            this.statement = statement;
        }

        public String getParameter() {
            return this.parameter;
        }

        public void setParameter(String parameter) {
            this.parameter = parameter;
        }

        public ExecutableStatement getStatement() {
            return this.statement;
        }

        public void setStatement(ExecutableStatement statement) {
            this.statement = statement;
        }
    }
}

