/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.EstimateEvaluator;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.util.PathImpl;
import org.neo4j.graphalgo.impl.util.PriorityMap;
import org.neo4j.graphalgo.impl.util.WeightedPathImpl;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.StandardExpander;

public class AStar
implements PathFinder<WeightedPath> {
    private final PathExpander<?> expander;
    private final CostEvaluator<Double> lengthEvaluator;
    private final EstimateEvaluator<Double> estimateEvaluator;
    private Metadata lastMetadata;

    public AStar(RelationshipExpander expander, CostEvaluator<Double> lengthEvaluator, EstimateEvaluator<Double> estimateEvaluator) {
        this(StandardExpander.toPathExpander((RelationshipExpander)expander), lengthEvaluator, estimateEvaluator);
    }

    public AStar(PathExpander<?> expander, CostEvaluator<Double> lengthEvaluator, EstimateEvaluator<Double> estimateEvaluator) {
        this.expander = expander;
        this.lengthEvaluator = lengthEvaluator;
        this.estimateEvaluator = estimateEvaluator;
    }

    @Override
    public WeightedPath findSinglePath(Node start, Node end) {
        this.lastMetadata = new Metadata();
        AStarIterator iterator = new AStarIterator(start, end);
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            GraphDatabaseService graphDb = node.getGraphDatabase();
            if (!node.equals(end)) continue;
            double weight = ((Visit)iterator.visitData.get(node.getId())).wayLength;
            LinkedList<Relationship> rels = new LinkedList<Relationship>();
            Relationship rel = graphDb.getRelationshipById(((Visit)iterator.visitData.get(node.getId())).cameFromRelationship);
            while (rel != null) {
                rels.addFirst(rel);
                node = rel.getOtherNode(node);
                long nextRelId = ((Visit)iterator.visitData.get(node.getId())).cameFromRelationship;
                rel = nextRelId == -1L ? null : graphDb.getRelationshipById(nextRelId);
            }
            Path path = this.toPath(start, rels);
            this.lastMetadata.paths++;
            return new WeightedPathImpl(weight, path);
        }
        return null;
    }

    @Override
    public Iterable<WeightedPath> findAllPaths(Node node, Node end) {
        return Iterables.option((Object)this.findSinglePath(node, end));
    }

    @Override
    public TraversalMetadata metadata() {
        return this.lastMetadata;
    }

    private Path toPath(Node start, LinkedList<Relationship> rels) {
        PathImpl.Builder builder = new PathImpl.Builder(start);
        for (Relationship rel : rels) {
            builder = builder.push(rel);
        }
        return builder.build();
    }

    private static class Metadata
    implements TraversalMetadata {
        private int rels;
        private int paths;

        private Metadata() {
        }

        public int getNumberOfPathsReturned() {
            return this.paths;
        }

        public int getNumberOfRelationshipsTraversed() {
            return this.rels;
        }
    }

    private class AStarIterator
    extends PrefetchingIterator<Node>
    implements Path {
        private final Node start;
        private final Node end;
        private Node lastNode;
        private final PriorityMap<Node, Node, Double> nextPrioritizedNodes = PriorityMap.withSelfKeyNaturalOrder();
        private final Map<Long, Visit> visitData = new HashMap<Long, Visit>();

        AStarIterator(Node start, Node end) {
            this.start = start;
            this.end = end;
            Visit visit = new Visit(-1L, 0.0, (Double)AStar.this.estimateEvaluator.getCost(start, end));
            this.addNext(start, visit.getFscore(), visit);
            this.visitData.put(start.getId(), visit);
        }

        private void addNext(Node node, double fscore, Visit visit) {
            this.nextPrioritizedNodes.put(node, fscore);
            visit.next = true;
        }

        private Node popLowestScoreNode() {
            PriorityMap.Entry<Node, Double> top = this.nextPrioritizedNodes.pop();
            if (top == null) {
                return null;
            }
            Node node = top.getEntity();
            Visit visit = this.visitData.get(node.getId());
            visit.visited = true;
            visit.next = false;
            return node;
        }

        protected Node fetchNextOrNull() {
            if (this.lastNode != null) {
                this.expand();
            }
            this.lastNode = this.popLowestScoreNode();
            return this.lastNode;
        }

        private void expand() {
            Iterable expand = AStar.this.expander.expand((Path)this, BranchState.NO_STATE);
            for (Relationship rel : expand) {
                AStar.this.lastMetadata.rels++;
                Node node = rel.getOtherNode(this.lastNode);
                Visit visit = this.visitData.get(node.getId());
                if (visit != null && visit.visited) continue;
                Visit lastVisit = this.visitData.get(this.lastNode.getId());
                double tentativeGScore = lastVisit.wayLength + (Double)AStar.this.lengthEvaluator.getCost(rel, Direction.OUTGOING);
                double estimate = (Double)AStar.this.estimateEvaluator.getCost(node, this.end);
                if (visit != null && visit.next && !(tentativeGScore < visit.wayLength)) continue;
                if (visit == null) {
                    visit = new Visit(rel.getId(), tentativeGScore, estimate);
                    this.visitData.put(node.getId(), visit);
                } else {
                    visit.update(rel.getId(), tentativeGScore, estimate);
                }
                this.addNext(node, estimate + tentativeGScore, visit);
            }
        }

        public Node startNode() {
            return this.start;
        }

        public Node endNode() {
            return this.lastNode;
        }

        public Relationship lastRelationship() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Relationship> relationships() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Relationship> reverseRelationships() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Node> nodes() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Node> reverseNodes() {
            throw new UnsupportedOperationException();
        }

        public int length() {
            throw new UnsupportedOperationException();
        }

        public Iterator<PropertyContainer> iterator() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Visit {
        private double wayLength;
        private double estimate;
        private long cameFromRelationship;
        private boolean visited;
        private boolean next;

        Visit(long cameFromRelationship, double wayLength, double estimate) {
            this.update(cameFromRelationship, wayLength, estimate);
        }

        void update(long cameFromRelationship, double wayLength, double estimate) {
            this.cameFromRelationship = cameFromRelationship;
            this.wayLength = wayLength;
            this.estimate = estimate;
        }

        double getFscore() {
            return this.wayLength + this.estimate;
        }
    }
}

