/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import org.neo4j.graphalgo.impl.path.TraversalPathFinder;
import org.neo4j.graphalgo.impl.util.LiteDepthFirstSelector;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.StandardExpander;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;

public class ExactDepthPathFinder
extends TraversalPathFinder {
    private final PathExpander expander;
    private final int onDepth;
    private final int startThreshold;

    public ExactDepthPathFinder(RelationshipExpander expander, int onDepth, int startThreshold) {
        this(StandardExpander.toPathExpander((RelationshipExpander)expander), onDepth, startThreshold);
    }

    public ExactDepthPathFinder(PathExpander expander, int onDepth, int startThreshold) {
        this.expander = expander;
        this.onDepth = onDepth;
        this.startThreshold = startThreshold;
    }

    @Override
    protected Traverser instantiateTraverser(Node start, Node end) {
        TraversalDescription side = Traversal.traversal().breadthFirst().expand(this.expander).uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_GLOBAL).order(new BranchOrderingPolicy(){

            public BranchSelector create(TraversalBranch startSource, PathExpander expander) {
                return new LiteDepthFirstSelector(startSource, ExactDepthPathFinder.this.startThreshold, expander);
            }
        });
        return Traversal.bidirectionalTraversal().startSide(side.evaluator(Evaluators.toDepth((int)(this.onDepth / 2)))).endSide(side.evaluator(Evaluators.toDepth((int)(this.onDepth - this.onDepth / 2)))).collisionEvaluator(Evaluators.atDepth((int)this.onDepth)).traverse(start, end);
    }
}

