/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.IndexProviders;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.DaemonThreadFactory;
import org.neo4j.helpers.Factory;
import org.neo4j.helpers.FunctionFromPrimitiveLong;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.Settings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.ResourceClosingIterator;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.AutoConfigurator;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DatabaseAvailability;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelDiagnostics;
import org.neo4j.kernel.KernelEventHandlers;
import org.neo4j.kernel.PlaceboTransaction;
import org.neo4j.kernel.StoreLocker;
import org.neo4j.kernel.StoreLockerLifecycleAdapter;
import org.neo4j.kernel.TopLevelTransaction;
import org.neo4j.kernel.TransactionBuilder;
import org.neo4j.kernel.TransactionBuilderImpl;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.ReadOnlyDatabaseKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationChange;
import org.neo4j.kernel.configuration.ConfigurationChangeListener;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.KernelSchemaStateStore;
import org.neo4j.kernel.impl.api.NonTransactionalTokenNameLookup;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.RemoveOrphanConstraintIndexesOnStartup;
import org.neo4j.kernel.impl.cache.BridgingCacheAccess;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.MonitorGc;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.DefaultCaches;
import org.neo4j.kernel.impl.core.DefaultLabelIdCreator;
import org.neo4j.kernel.impl.core.DefaultPropertyTokenCreator;
import org.neo4j.kernel.impl.core.DefaultRelationshipTypeCreator;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.core.ReadOnlyNodeManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.core.TransactionEventsSyncHook;
import org.neo4j.kernel.impl.core.Transactor;
import org.neo4j.kernel.impl.core.TxEventSyncHookFactory;
import org.neo4j.kernel.impl.coreapi.IndexManagerImpl;
import org.neo4j.kernel.impl.coreapi.NodeAutoIndexerImpl;
import org.neo4j.kernel.impl.coreapi.RelationshipAutoIndexerImpl;
import org.neo4j.kernel.impl.coreapi.schema.SchemaImpl;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreProvider;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.nioneo.xa.NioNeoDbPersistenceSource;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.KernelHealth;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockManagerImpl;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.RagManager;
import org.neo4j.kernel.impl.transaction.ReadOnlyTxManager;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.transaction.TransactionManagerProvider;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategies;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.traversal.BidirectionalTraversalDescriptionImpl;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraversalDescription;
import org.neo4j.kernel.impl.util.AbstractPrimitiveLongIterator;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.impl.util.PrimitiveLongIterator;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.lifecycle.LifecycleListener;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.kernel.logging.DefaultLogging;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.tooling.GlobalGraphOperations;

@Deprecated
public abstract class InternalAbstractGraphDatabase
extends AbstractGraphDatabase
implements GraphDatabaseService,
GraphDatabaseAPI,
SchemaWriteGuard {
    private static final long MAX_NODE_ID = IdType.NODE.getMaxValue();
    private static final long MAX_RELATIONSHIP_ID = IdType.RELATIONSHIP.getMaxValue();
    protected File storeDir;
    protected Map<String, String> params;
    protected final TransactionInterceptorProviders transactionInterceptorProviders;
    protected StoreId storeId;
    private final TransactionBuilder defaultTxBuilder = new TransactionBuilderImpl(this, ForceMode.forced);
    protected final KernelExtensions kernelExtensions;
    protected Config config;
    protected DependencyResolver dependencyResolver;
    protected Logging logging;
    protected StringLogger msgLog;
    protected StoreLockerLifecycleAdapter storeLocker;
    protected KernelEventHandlers kernelEventHandlers;
    protected TransactionEventHandlers transactionEventHandlers;
    protected RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    protected NodeManager nodeManager;
    protected IndexManagerImpl indexManager;
    protected Schema schema;
    protected KernelPanicEventGenerator kernelPanicEventGenerator;
    protected KernelHealth kernelHealth;
    protected RemoteTxHook txHook;
    protected FileSystemAbstraction fileSystem;
    protected XaDataSourceManager xaDataSourceManager;
    protected LockManager lockManager;
    protected IdGeneratorFactory idGeneratorFactory;
    protected NioNeoDbPersistenceSource persistenceSource;
    protected TxEventSyncHookFactory syncHook;
    protected PersistenceManager persistenceManager;
    protected PropertyKeyTokenHolder propertyKeyTokenHolder;
    protected LabelTokenHolder labelTokenHolder;
    protected IndexStore indexStore;
    protected AbstractTransactionManager txManager;
    protected TxIdGenerator txIdGenerator;
    protected StoreFactory storeFactory;
    protected XaFactory xaFactory;
    protected DiagnosticsManager diagnosticsManager;
    protected NeoStoreXaDataSource neoDataSource;
    protected RecoveryVerifier recoveryVerifier;
    protected Guard guard;
    protected NodeAutoIndexerImpl nodeAutoIndexer;
    protected RelationshipAutoIndexerImpl relAutoIndexer;
    protected KernelData extensions;
    protected Caches caches;
    protected TransactionStateFactory stateFactory;
    protected ThreadToStatementContextBridge statementContextProvider;
    protected BridgingCacheAccess cacheBridge;
    protected JobScheduler jobScheduler;
    protected UpdateableSchemaState updateableSchemaState;
    protected Monitors monitors;
    protected final LifeSupport life = new LifeSupport();
    private final Map<String, CacheProvider> cacheProviders;
    protected AvailabilityGuard availabilityGuard;
    protected long accessTimeout;

    protected InternalAbstractGraphDatabase(String storeDir, Map<String, String> params, Dependencies dependencies) {
        this.params = params;
        this.dependencyResolver = new DependencyResolverImpl();
        params.put(Configuration.store_dir.name(), storeDir);
        this.cacheProviders = this.mapCacheProviders(dependencies.cacheProviders());
        this.config = new Config(params, this.getSettingsClasses(dependencies.settingsClasses(), dependencies.kernelExtensions(), dependencies.cacheProviders()));
        this.logging = dependencies.logging();
        this.kernelExtensions = new KernelExtensions(dependencies.kernelExtensions(), this.config, this.getDependencyResolver(), UnsatisfiedDependencyStrategies.fail());
        this.transactionInterceptorProviders = new TransactionInterceptorProviders(dependencies.transactionInterceptorProviders(), this.dependencyResolver);
        this.storeDir = this.config.get(Configuration.store_dir);
        this.accessTimeout = 1000L;
    }

    private Map<String, CacheProvider> mapCacheProviders(Iterable<CacheProvider> cacheProviders) {
        HashMap<String, CacheProvider> map = new HashMap<String, CacheProvider>();
        for (CacheProvider provider : cacheProviders) {
            map.put(provider.getName(), provider);
        }
        return map;
    }

    protected void run() {
        this.create();
        try {
            this.registerRecovery();
            this.life.start();
            Throwable recoveryError = this.txManager.getRecoveryError();
            if (recoveryError != null) {
                throw recoveryError;
            }
        }
        catch (Throwable throwable) {
            StringBuilder msg = new StringBuilder();
            msg.append("Startup failed");
            for (Throwable temporaryThrowable = throwable; temporaryThrowable != null; temporaryThrowable = temporaryThrowable.getCause()) {
                msg.append(": ").append(temporaryThrowable.getMessage());
            }
            this.msgLog.error(msg.toString());
            this.shutdown();
            throw new RuntimeException("Error starting " + this.getClass().getName() + ", " + this.storeDir.getAbsolutePath(), throwable);
        }
    }

    protected void createDatabaseAvailability() {
        this.life.add(new DatabaseAvailability(this.txManager, this.availabilityGuard));
    }

    protected void registerRecovery() {
        this.life.addLifecycleListener(new LifecycleListener(){

            @Override
            public void notifyStatusChanged(Object instance, LifecycleStatus from, LifecycleStatus to) {
                if (instance instanceof KernelExtensions && to.equals((Object)LifecycleStatus.STARTED)) {
                    InternalAbstractGraphDatabase.this.doAfterRecoveryAndStartup(true);
                }
            }
        });
    }

    protected void doAfterRecoveryAndStartup(boolean isMaster) {
        if (this.txManager.getRecoveryError() != null) {
            return;
        }
        if (this.txManager instanceof TxManager) {
            NeoStoreXaDataSource neoStoreDataSource = this.xaDataSourceManager.getNeoStoreDataSource();
            this.storeId = neoStoreDataSource.getStoreId();
            KernelDiagnostics.register(this.diagnosticsManager, this, neoStoreDataSource);
            if (isMaster) {
                new RemoveOrphanConstraintIndexesOnStartup(new Transactor(this.txManager, this.persistenceManager), this.logging).perform();
            }
        }
    }

    protected void create() {
        this.availabilityGuard = this.createAvailabilityGuard();
        this.availabilityGuard.addListener(new AvailabilityGuard.AvailabilityListener(){

            @Override
            public void available() {
                InternalAbstractGraphDatabase.this.msgLog.info("Database is now ready");
            }

            @Override
            public void unavailable() {
                InternalAbstractGraphDatabase.this.msgLog.info("Database is now unavailable");
            }
        });
        this.fileSystem = this.createFileSystemAbstraction();
        if (this.logging == null) {
            this.logging = this.createLogging();
        }
        this.monitors = this.createMonitors();
        AutoConfigurator autoConfigurator = new AutoConfigurator(this.fileSystem, this.config.get(NeoStoreXaDataSource.Configuration.store_dir), this.config.get(Configuration.use_memory_mapped_buffers), this.logging.getConsoleLog(AutoConfigurator.class));
        if (this.config.get(GraphDatabaseSettings.dump_configuration).booleanValue()) {
            System.out.println(autoConfigurator.getNiceMemoryInformation());
        }
        Map<String, String> configParams = this.config.getParams();
        Map<String, String> autoConfiguration = autoConfigurator.configure();
        for (Map.Entry<String, String> autoConfig : autoConfiguration.entrySet()) {
            String key = autoConfig.getKey();
            if (this.params.containsKey(key)) continue;
            configParams.put(key, autoConfig.getValue());
        }
        this.config.applyChanges(configParams);
        this.msgLog = this.logging.getMessagesLog(this.getClass());
        this.config.setLogger(this.msgLog);
        this.storeLocker = this.life.add(new StoreLockerLifecycleAdapter(new StoreLocker(this.fileSystem), this.storeDir));
        new JvmChecker(this.msgLog, new JvmMetadataRepository()).checkJvmCompatibilityAndIssueWarning();
        boolean readOnly = this.config.get(Configuration.read_only);
        String cacheTypeName = this.config.get(Configuration.cache_type);
        CacheProvider cacheProvider = this.cacheProviders.get(cacheTypeName);
        if (cacheProvider == null) {
            throw new IllegalArgumentException("No provider for cache type '" + cacheTypeName + "'. " + "Cache providers are loaded using java service loading where they " + "register themselves in resource (plain-text) files found on the class path under " + "META-INF/services/" + CacheProvider.class.getName() + ". This missing provider may have " + "been caused by either such a missing registration, or by the lack of the provider class itself.");
        }
        this.jobScheduler = this.life.add(new Neo4jJobScheduler(this.toString(), this.logging.getMessagesLog(Neo4jJobScheduler.class)));
        this.kernelEventHandlers = new KernelEventHandlers(this.logging.getMessagesLog(KernelEventHandlers.class));
        this.caches = this.createCaches();
        this.diagnosticsManager = this.life.add(new DiagnosticsManager(this.logging.getMessagesLog(DiagnosticsManager.class)));
        this.kernelPanicEventGenerator = new KernelPanicEventGenerator(this.kernelEventHandlers);
        this.kernelHealth = new KernelHealth(this.kernelPanicEventGenerator, this.logging);
        this.xaDataSourceManager = this.life.add(this.createXaDataSourceManager());
        this.txHook = this.createTxHook();
        this.guard = this.config.get(Configuration.execution_guard_enabled) != false ? new Guard(this.msgLog) : null;
        this.stateFactory = this.createTransactionStateFactory();
        Factory<byte[]> xidGlobalIdFactory = this.createXidGlobalIdFactory();
        this.updateableSchemaState = new KernelSchemaStateStore(this.newSchemaStateMap());
        if (readOnly) {
            this.txManager = new ReadOnlyTxManager(this.xaDataSourceManager, xidGlobalIdFactory, this.logging.getMessagesLog(ReadOnlyTxManager.class));
        } else {
            String serviceName = this.config.get(GraphDatabaseSettings.tx_manager_impl);
            if (GraphDatabaseSettings.tx_manager_impl.getDefaultValue().equals(serviceName)) {
                this.txManager = new TxManager(this.storeDir, this.xaDataSourceManager, this.logging.getMessagesLog(TxManager.class), this.fileSystem, this.stateFactory, xidGlobalIdFactory, this.kernelHealth, this.monitors);
            } else {
                TransactionManagerProvider provider = Service.load(TransactionManagerProvider.class, serviceName);
                this.txManager = provider.loadTransactionManager(this.storeDir.getPath(), this.xaDataSourceManager, this.kernelPanicEventGenerator, this.txHook, this.logging.getMessagesLog(AbstractTransactionManager.class), this.fileSystem, this.stateFactory);
            }
        }
        this.life.add(this.txManager);
        this.transactionEventHandlers = new TransactionEventHandlers(this.txManager);
        this.txIdGenerator = this.life.add(this.createTxIdGenerator());
        this.lockManager = this.createLockManager();
        this.idGeneratorFactory = this.createIdGeneratorFactory();
        this.persistenceSource = this.life.add(new NioNeoDbPersistenceSource(this.xaDataSourceManager));
        this.syncHook = new DefaultTxEventSyncHookFactory();
        this.persistenceManager = new PersistenceManager(this.logging.getMessagesLog(PersistenceManager.class), this.txManager, this.persistenceSource, this.syncHook);
        this.propertyKeyTokenHolder = this.life.add(new PropertyKeyTokenHolder(this.txManager, this.persistenceManager, this.persistenceSource, this.createPropertyKeyCreator()));
        this.labelTokenHolder = this.life.add(new LabelTokenHolder(this.txManager, this.persistenceManager, this.persistenceSource, this.createLabelIdCreator()));
        this.relationshipTypeTokenHolder = this.life.add(new RelationshipTypeTokenHolder(this.txManager, this.persistenceManager, this.persistenceSource, this.createRelationshipTypeCreator()));
        this.caches.configure(cacheProvider, this.config);
        Cache<NodeImpl> nodeCache = this.diagnosticsManager.tryAppendProvider(this.caches.node());
        Cache<RelationshipImpl> relCache = this.diagnosticsManager.tryAppendProvider(this.caches.relationship());
        this.statementContextProvider = this.life.add(new ThreadToStatementContextBridge(this.persistenceManager));
        this.nodeManager = this.guard != null ? this.createGuardedNodeManager(readOnly, cacheProvider, nodeCache, relCache) : this.createNodeManager(readOnly, cacheProvider, nodeCache, relCache);
        this.stateFactory.setDependencies(this.lockManager, this.nodeManager, this.txHook, this.txIdGenerator);
        this.indexStore = this.life.add(new IndexStore(this.storeDir, this.fileSystem));
        this.diagnosticsManager.prependProvider(this.config);
        this.params = this.config.getParams();
        this.extensions = this.life.add(this.createKernelData());
        this.life.add(this.kernelExtensions);
        this.schema = new SchemaImpl(this.statementContextProvider);
        this.indexManager = new IndexManagerImpl(this.config, this.indexStore, this.xaDataSourceManager, this.txManager, this);
        this.nodeAutoIndexer = this.life.add(new NodeAutoIndexerImpl(this.config, this.indexManager, this.nodeManager));
        this.relAutoIndexer = this.life.add(new RelationshipAutoIndexerImpl(this.config, this.indexManager, this.nodeManager));
        this.indexManager.setNodeAutoIndexer(this.nodeAutoIndexer);
        this.indexManager.setRelAutoIndexer(this.relAutoIndexer);
        this.recoveryVerifier = this.createRecoveryVerifier();
        this.storeFactory = this.createStoreFactory();
        String keepLogicalLogsConfig = this.config.get(GraphDatabaseSettings.keep_logical_logs);
        this.xaFactory = new XaFactory(this.config, this.txIdGenerator, this.txManager, this.fileSystem, this.monitors, this.logging, this.recoveryVerifier, LogPruneStrategies.fromConfigValue(this.fileSystem, keepLogicalLogsConfig), this.kernelHealth);
        this.createNeoDataSource();
        this.life.add(new MonitorGc(this.config, this.msgLog));
        this.life.add(this.nodeManager);
        this.createDatabaseAvailability();
        this.life.add(this.kernelEventHandlers);
        this.life.add(new ConfigurationChangedRestarter());
    }

    protected Monitors createMonitors() {
        return new Monitors();
    }

    protected Factory<byte[]> createXidGlobalIdFactory() {
        return new Factory<byte[]>(){

            @Override
            public byte[] newInstance() {
                return XidImpl.getNewGlobalId(XidImpl.DEFAULT_SEED, -1);
            }
        };
    }

    protected AvailabilityGuard createAvailabilityGuard() {
        return new AvailabilityGuard(Clock.SYSTEM_CLOCK, 1);
    }

    @Override
    public void assertSchemaWritesAllowed() throws InvalidTransactionTypeKernelException {
    }

    private Map<Object, Object> newSchemaStateMap() {
        return new HashMap<Object, Object>();
    }

    protected TransactionStateFactory createTransactionStateFactory() {
        return new TransactionStateFactory(this.logging);
    }

    protected XaDataSourceManager createXaDataSourceManager() {
        return new XaDataSourceManager(this.logging.getMessagesLog(XaDataSourceManager.class));
    }

    @Override
    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    protected TokenCreator createRelationshipTypeCreator() {
        return new DefaultRelationshipTypeCreator(this.logging);
    }

    protected TokenCreator createPropertyKeyCreator() {
        return new DefaultPropertyTokenCreator(this.logging);
    }

    protected TokenCreator createLabelIdCreator() {
        return new DefaultLabelIdCreator(this.logging);
    }

    private NodeManager createNodeManager(boolean readOnly, CacheProvider cacheType, Cache<NodeImpl> nodeCache, Cache<RelationshipImpl> relCache) {
        if (readOnly) {
            return new ReadOnlyNodeManager(this.logging.getMessagesLog(NodeManager.class), this, this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeTokenHolder, cacheType, this.propertyKeyTokenHolder, this.labelTokenHolder, this.createNodeLookup(), this.createRelationshipLookups(), nodeCache, relCache, this.xaDataSourceManager, this.statementContextProvider);
        }
        return new NodeManager(this.logging.getMessagesLog(NodeManager.class), this, this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeTokenHolder, cacheType, this.propertyKeyTokenHolder, this.labelTokenHolder, this.createNodeLookup(), this.createRelationshipLookups(), nodeCache, relCache, this.xaDataSourceManager, this.statementContextProvider);
    }

    private NodeManager createGuardedNodeManager(boolean readOnly, CacheProvider cacheType, Cache<NodeImpl> nodeCache, Cache<RelationshipImpl> relCache) {
        if (readOnly) {
            return new ReadOnlyNodeManager(this.logging.getMessagesLog(NodeManager.class), this, this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeTokenHolder, cacheType, this.propertyKeyTokenHolder, this.labelTokenHolder, this.createNodeLookup(), this.createRelationshipLookups(), nodeCache, relCache, this.xaDataSourceManager, this.statementContextProvider){

                @Override
                public Node getNodeByIdOrNull(long nodeId) {
                    InternalAbstractGraphDatabase.this.guard.check();
                    return super.getNodeByIdOrNull(nodeId);
                }

                @Override
                public NodeImpl getNodeForProxy(long nodeId, LockType lock) {
                    InternalAbstractGraphDatabase.this.guard.check();
                    return super.getNodeForProxy(nodeId, lock);
                }

                @Override
                public RelationshipImpl getRelationshipForProxy(long relId) {
                    InternalAbstractGraphDatabase.this.guard.check();
                    return super.getRelationshipForProxy(relId);
                }

                @Override
                protected Relationship getRelationshipByIdOrNull(long relId) {
                    InternalAbstractGraphDatabase.this.guard.check();
                    return super.getRelationshipByIdOrNull(relId);
                }

                @Override
                public Node createNode() {
                    InternalAbstractGraphDatabase.this.guard.check();
                    return super.createNode();
                }

                @Override
                public Relationship createRelationship(Node startNodeProxy, NodeImpl startNode, Node endNode, long relationshipTypeId) {
                    InternalAbstractGraphDatabase.this.guard.check();
                    return super.createRelationship(startNodeProxy, startNode, endNode, relationshipTypeId);
                }
            };
        }
        return new NodeManager(this.logging.getMessagesLog(NodeManager.class), this, this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeTokenHolder, cacheType, this.propertyKeyTokenHolder, this.labelTokenHolder, this.createNodeLookup(), this.createRelationshipLookups(), nodeCache, relCache, this.xaDataSourceManager, this.statementContextProvider){

            @Override
            public Node getNodeByIdOrNull(long nodeId) {
                InternalAbstractGraphDatabase.this.guard.check();
                return super.getNodeByIdOrNull(nodeId);
            }

            @Override
            public NodeImpl getNodeForProxy(long nodeId, LockType lock) {
                InternalAbstractGraphDatabase.this.guard.check();
                return super.getNodeForProxy(nodeId, lock);
            }

            @Override
            public RelationshipImpl getRelationshipForProxy(long relId) {
                InternalAbstractGraphDatabase.this.guard.check();
                return super.getRelationshipForProxy(relId);
            }

            @Override
            protected Relationship getRelationshipByIdOrNull(long relId) {
                InternalAbstractGraphDatabase.this.guard.check();
                return super.getRelationshipByIdOrNull(relId);
            }

            @Override
            public Node createNode() {
                InternalAbstractGraphDatabase.this.guard.check();
                return super.createNode();
            }

            @Override
            public Relationship createRelationship(Node startNodeProxy, NodeImpl startNode, Node endNode, long relationshipTypeId) {
                InternalAbstractGraphDatabase.this.guard.check();
                return super.createRelationship(startNodeProxy, startNode, endNode, relationshipTypeId);
            }
        };
    }

    @Override
    public boolean isAvailable(long timeout) {
        return this.availabilityGuard.isAvailable(timeout);
    }

    @Override
    public void shutdown() {
        try {
            this.msgLog.info("Shutdown started");
            this.msgLog.flush();
            this.availabilityGuard.shutdown();
            this.life.shutdown();
        }
        catch (LifecycleException throwable) {
            this.msgLog.warn("Shutdown failed", throwable);
            throw throwable;
        }
    }

    protected StoreFactory createStoreFactory() {
        return new StoreFactory(this.config, this.idGeneratorFactory, this.createWindowPoolFactory(), this.fileSystem, this.logging.getMessagesLog(StoreFactory.class), this.txHook);
    }

    protected DefaultWindowPoolFactory createWindowPoolFactory() {
        return new DefaultWindowPoolFactory();
    }

    protected RecoveryVerifier createRecoveryVerifier() {
        return RecoveryVerifier.ALWAYS_VALID;
    }

    protected KernelData createKernelData() {
        return new DefaultKernelData(this.config, this);
    }

    protected TxIdGenerator createTxIdGenerator() {
        return TxIdGenerator.DEFAULT;
    }

    protected Caches createCaches() {
        return new DefaultCaches(this.msgLog, this.monitors);
    }

    protected RelationshipProxy.RelationshipLookups createRelationshipLookups() {
        return new RelationshipProxy.RelationshipLookups(){

            @Override
            public RelationshipImpl lookupRelationship(long relationshipId) {
                InternalAbstractGraphDatabase.this.assertDatabaseRunning();
                return InternalAbstractGraphDatabase.this.nodeManager.getRelationshipForProxy(relationshipId);
            }

            @Override
            public GraphDatabaseService getGraphDatabaseService() {
                return InternalAbstractGraphDatabase.this;
            }

            @Override
            public NodeManager getNodeManager() {
                return InternalAbstractGraphDatabase.this.nodeManager;
            }

            @Override
            public Node newNodeProxy(long nodeId) {
                return InternalAbstractGraphDatabase.this.nodeManager.newNodeProxyById(nodeId);
            }
        };
    }

    protected NodeProxy.NodeLookup createNodeLookup() {
        return new NodeProxy.NodeLookup(){

            @Override
            public NodeImpl lookup(long nodeId) {
                InternalAbstractGraphDatabase.this.assertDatabaseRunning();
                return InternalAbstractGraphDatabase.this.nodeManager.getNodeForProxy(nodeId, null);
            }

            @Override
            public NodeImpl lookup(long nodeId, LockType lock) {
                InternalAbstractGraphDatabase.this.assertDatabaseRunning();
                return InternalAbstractGraphDatabase.this.nodeManager.getNodeForProxy(nodeId, lock);
            }

            @Override
            public GraphDatabaseService getGraphDatabase() {
                return InternalAbstractGraphDatabase.this;
            }

            @Override
            public NodeManager getNodeManager() {
                return InternalAbstractGraphDatabase.this.nodeManager;
            }
        };
    }

    private void assertDatabaseRunning() {
        if (this.life.isRunning()) {
            return;
        }
        throw new DatabaseShutdownException();
    }

    protected RemoteTxHook createTxHook() {
        return new DefaultTxHook();
    }

    protected FileSystemAbstraction createFileSystemAbstraction() {
        return new DefaultFileSystemAbstraction();
    }

    protected IdGeneratorFactory createIdGeneratorFactory() {
        return new DefaultIdGeneratorFactory();
    }

    protected LockManager createLockManager() {
        return new LockManagerImpl(new RagManager());
    }

    protected Logging createLogging() {
        return this.life.add(DefaultLogging.createDefaultLogging(this.config));
    }

    protected void createNeoDataSource() {
        this.neoDataSource = new NeoStoreXaDataSource(this.config, this.storeFactory, this.logging.getMessagesLog(NeoStoreXaDataSource.class), this.xaFactory, this.stateFactory, this.transactionInterceptorProviders, this.jobScheduler, this.logging, this.updateableSchemaState, new NonTransactionalTokenNameLookup(this.labelTokenHolder, this.propertyKeyTokenHolder), this.dependencyResolver, this.txManager, this.propertyKeyTokenHolder, this.labelTokenHolder, this.relationshipTypeTokenHolder, this.persistenceManager, this.lockManager, this, this.monitors.newMonitor(IndexingService.Monitor.class, new String[0]));
        this.xaDataSourceManager.registerDataSource(this.neoDataSource);
    }

    @Override
    public final String getStoreDir() {
        return this.storeDir.getPath();
    }

    @Override
    public StoreId storeId() {
        return this.storeId;
    }

    @Override
    public Transaction beginTx() {
        return this.tx().begin();
    }

    protected Transaction beginTx(ForceMode forceMode) {
        if (!this.availabilityGuard.isAvailable(this.accessTimeout)) {
            throw new TransactionFailureException("Database is currently not available. " + this.availabilityGuard.describeWhoIsBlocking());
        }
        try {
            if (this.transactionRunning()) {
                return new PlaceboTransaction(this.persistenceManager, this.txManager, this.txManager.getTransactionState());
            }
            this.txManager.begin(forceMode);
            return new TopLevelTransaction(this.persistenceManager, this.txManager, this.txManager.getTransactionState());
        }
        catch (SystemException e) {
            throw new TransactionFailureException("Couldn't get transaction", e);
        }
        catch (NotSupportedException e) {
            throw new TransactionFailureException("Couldn't begin transaction", e);
        }
    }

    @Override
    public boolean transactionRunning() {
        try {
            return this.txManager.getTransaction() != null;
        }
        catch (SystemException e) {
            throw new TransactionFailureException("Unable to get transaction.", e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.getStoreDir() + "]";
    }

    @Override
    public Iterable<Node> getAllNodes() {
        return GlobalGraphOperations.at(this).getAllNodes();
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        return GlobalGraphOperations.at(this).getAllRelationshipTypes();
    }

    @Override
    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        return this.kernelEventHandlers.registerKernelEventHandler(handler);
    }

    @Override
    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.transactionEventHandlers.registerTransactionEventHandler(handler);
    }

    @Override
    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.kernelEventHandlers.unregisterKernelEventHandler(handler);
    }

    @Override
    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.transactionEventHandlers.unregisterTransactionEventHandler(handler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Node createNode() {
        try (Statement statement = this.statementContextProvider.instance();){
            NodeProxy nodeProxy = this.nodeManager.newNodeProxyById(statement.dataWriteOperations().nodeCreate());
            return nodeProxy;
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (ReadOnlyDatabaseKernelException e) {
            throw new ReadOnlyDbException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Node createNode(Label ... labels) {
        try (Statement statement = this.statementContextProvider.instance();){
            long nodeId = statement.dataWriteOperations().nodeCreate();
            for (Label label : labels) {
                int labelId = statement.tokenWriteOperations().labelGetOrCreateForName(label.name());
                try {
                    statement.dataWriteOperations().nodeAddLabel(nodeId, labelId);
                }
                catch (EntityNotFoundException e) {
                    throw new NotFoundException("No node with id " + nodeId + " found.", e);
                }
            }
            NodeProxy nodeProxy = this.nodeManager.newNodeProxyById(nodeId);
            return nodeProxy;
        }
        catch (ConstraintValidationKernelException e) {
            throw new ConstraintViolationException("Unable to add label.", e);
        }
        catch (SchemaKernelException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (ReadOnlyDatabaseKernelException e) {
            throw new ReadOnlyDbException();
        }
    }

    @Override
    public Node getNodeById(long id) {
        if (id < 0L || id > MAX_NODE_ID) {
            throw new NotFoundException(String.format("Node %d not found", id));
        }
        return this.nodeManager.getNodeById(id);
    }

    @Override
    public Relationship getRelationshipById(long id) {
        if (id < 0L || id > MAX_RELATIONSHIP_ID) {
            throw new NotFoundException(String.format("Relationship %d not found", id));
        }
        return this.nodeManager.getRelationshipById(id);
    }

    @Override
    public TransactionBuilder tx() {
        return this.defaultTxBuilder;
    }

    @Override
    public IndexManager index() {
        return this.indexManager;
    }

    @Override
    public Schema schema() {
        this.txManager.assertInTransaction();
        return this.schema;
    }

    public Config getConfig() {
        return this.config;
    }

    private Iterable<Class<?>> getSettingsClasses(Iterable<Class<?>> settingsClasses, Iterable<KernelExtensionFactory<?>> kernelExtensions, Iterable<CacheProvider> cacheProviders) {
        ArrayList totalSettingsClasses = new ArrayList();
        Iterables.addAll(totalSettingsClasses, settingsClasses);
        for (KernelExtensionFactory<?> kernelExtension : kernelExtensions) {
            if (kernelExtension.getSettingsClass() == null) continue;
            totalSettingsClasses.add(kernelExtension.getSettingsClass());
        }
        for (CacheProvider cacheProvider : cacheProviders) {
            if (cacheProvider.getSettingsClass() == null) continue;
            totalSettingsClasses.add(cacheProvider.getSettingsClass());
        }
        return totalSettingsClasses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof InternalAbstractGraphDatabase)) {
            return false;
        }
        InternalAbstractGraphDatabase that = (InternalAbstractGraphDatabase)o;
        return (this.storeId != null ? this.storeId.equals(that.storeId) : that.storeId == null) && this.storeDir.equals(that.storeDir);
    }

    public int hashCode() {
        return this.storeDir.hashCode();
    }

    @Override
    public ResourceIterable<Node> findNodesByLabelAndProperty(final Label myLabel, final String key, final Object value) {
        return new ResourceIterable<Node>(){

            @Override
            public ResourceIterator<Node> iterator() {
                return InternalAbstractGraphDatabase.this.nodesByLabelAndProperty(myLabel, key, value);
            }
        };
    }

    private ResourceIterator<Node> nodesByLabelAndProperty(Label myLabel, String key, Object value) {
        Statement statement = this.statementContextProvider.instance();
        ReadOperations readOps = statement.readOperations();
        int propertyId = readOps.propertyKeyGetForName(key);
        int labelId = readOps.labelGetForName(myLabel.name());
        if (propertyId == -1 || labelId == -1) {
            statement.close();
            return IteratorUtil.emptyIterator();
        }
        IndexDescriptor descriptor = this.findAnyIndexByLabelAndProperty(readOps, propertyId, labelId);
        try {
            if (null != descriptor) {
                return this.map2nodes(readOps.nodesGetFromIndexLookup(descriptor, value), statement);
            }
        }
        catch (IndexNotFoundKernelException e) {
            // empty catch block
        }
        return this.getNodesByLabelAndPropertyWithoutIndex(propertyId, value, statement, labelId);
    }

    private IndexDescriptor findAnyIndexByLabelAndProperty(ReadOperations readOps, int propertyId, int labelId) {
        IndexDescriptor descriptor = this.findUniqueIndexByLabelAndProperty(readOps, labelId, propertyId);
        if (null == descriptor) {
            descriptor = this.findRegularIndexByLabelAndProperty(readOps, labelId, propertyId);
        }
        return descriptor;
    }

    private IndexDescriptor findUniqueIndexByLabelAndProperty(ReadOperations readOps, int labelId, int propertyId) {
        try {
            IndexDescriptor descriptor = readOps.indexesGetForLabelAndPropertyKey(labelId, propertyId);
            if (readOps.indexGetState(descriptor) == InternalIndexState.ONLINE) {
                return descriptor;
            }
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            // empty catch block
        }
        return null;
    }

    private IndexDescriptor findRegularIndexByLabelAndProperty(ReadOperations readOps, int labelId, int propertyId) {
        try {
            IndexDescriptor descriptor = readOps.indexesGetForLabelAndPropertyKey(labelId, propertyId);
            if (readOps.indexGetState(descriptor) == InternalIndexState.ONLINE) {
                return descriptor;
            }
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            // empty catch block
        }
        return null;
    }

    private ResourceIterator<Node> getNodesByLabelAndPropertyWithoutIndex(int propertyId, Object value, Statement statement, int labelId) {
        return this.map2nodes(new PropertyValueFilteringNodeIdIterator(statement.readOperations().nodesGetForLabel(labelId), statement.readOperations(), propertyId, value), statement);
    }

    private ResourceIterator<Node> map2nodes(PrimitiveLongIterator input, Statement statement) {
        return ResourceClosingIterator.newResourceIterator(statement, Iterables.map(new FunctionFromPrimitiveLong<Node>(){

            @Override
            public Node apply(long id) {
                return InternalAbstractGraphDatabase.this.getNodeById(id);
            }
        }, input));
    }

    @Override
    public TraversalDescription traversalDescription() {
        return new MonoDirectionalTraversalDescription(this.statementContextProvider);
    }

    @Override
    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        return new BidirectionalTraversalDescriptionImpl(this.statementContextProvider);
    }

    private static class PropertyValueFilteringNodeIdIterator
    extends AbstractPrimitiveLongIterator {
        private final PrimitiveLongIterator nodesWithLabel;
        private final ReadOperations statement;
        private final int propertyKeyId;
        private final Object value;

        PropertyValueFilteringNodeIdIterator(PrimitiveLongIterator nodesWithLabel, ReadOperations statement, int propertyKeyId, Object value) {
            this.nodesWithLabel = nodesWithLabel;
            this.statement = statement;
            this.propertyKeyId = propertyKeyId;
            this.value = value;
            this.computeNext();
        }

        @Override
        protected void computeNext() {
            boolean hasNext = this.nodesWithLabel.hasNext();
            while (hasNext) {
                long nextValue = this.nodesWithLabel.next();
                try {
                    if (this.statement.nodeGetProperty(nextValue, this.propertyKeyId).valueEquals(this.value)) {
                        this.next(nextValue);
                        return;
                    }
                }
                catch (EntityNotFoundException e) {
                    // empty catch block
                }
                hasNext = this.nodesWithLabel.hasNext();
            }
            this.endReached();
        }
    }

    class ConfigurationChangedRestarter
    extends LifecycleAdapter {
        private final ConfigurationChangeListener listener = new ConfigurationChangeListener(){
            Executor executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory("Database configuration restart"));

            @Override
            public void notifyConfigurationChanges(final Iterable<ConfigurationChange> change) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            InternalAbstractGraphDatabase.this.life.stop();
                            InternalAbstractGraphDatabase.this.life.start();
                            InternalAbstractGraphDatabase.this.msgLog.logMessage("Database restarted with the following configuration changes:" + change);
                        }
                        catch (LifecycleException e) {
                            InternalAbstractGraphDatabase.this.msgLog.logMessage("Could not restart database", e);
                        }
                    }
                });
            }
        };

        ConfigurationChangedRestarter() {
        }

        @Override
        public void start() throws Throwable {
            InternalAbstractGraphDatabase.this.config.addConfigurationChangeListener(this.listener);
        }

        @Override
        public void stop() throws Throwable {
            InternalAbstractGraphDatabase.this.config.removeConfigurationChangeListener(this.listener);
        }
    }

    class DependencyResolverImpl
    extends DependencyResolver.Adapter {
        DependencyResolverImpl() {
        }

        private <T> T resolveKnownSingleDependency(Class<T> type) {
            if (type.equals(Map.class)) {
                return type.cast(InternalAbstractGraphDatabase.this.getConfig().getParams());
            }
            if (type.equals(Config.class)) {
                return type.cast(InternalAbstractGraphDatabase.this.getConfig());
            }
            if (GraphDatabaseService.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this)) {
                return type.cast(InternalAbstractGraphDatabase.this);
            }
            if (TransactionManager.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.txManager)) {
                return type.cast(InternalAbstractGraphDatabase.this.txManager);
            }
            if (LockManager.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.lockManager)) {
                return type.cast(InternalAbstractGraphDatabase.this.lockManager);
            }
            if (LockService.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.neoDataSource.getLockService())) {
                return type.cast(InternalAbstractGraphDatabase.this.neoDataSource.getLockService());
            }
            if (StoreFactory.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.storeFactory)) {
                return type.cast(InternalAbstractGraphDatabase.this.storeFactory);
            }
            if (SchemaWriteGuard.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this);
            }
            if (StringLogger.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.msgLog)) {
                return type.cast(InternalAbstractGraphDatabase.this.msgLog);
            }
            if (Logging.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.logging)) {
                return type.cast(InternalAbstractGraphDatabase.this.logging);
            }
            if (IndexStore.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.indexStore)) {
                return type.cast(InternalAbstractGraphDatabase.this.indexStore);
            }
            if (XaFactory.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.xaFactory)) {
                return type.cast(InternalAbstractGraphDatabase.this.xaFactory);
            }
            if (XaDataSourceManager.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.xaDataSourceManager)) {
                return type.cast(InternalAbstractGraphDatabase.this.xaDataSourceManager);
            }
            if (FileSystemAbstraction.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.fileSystem)) {
                return type.cast(InternalAbstractGraphDatabase.this.fileSystem);
            }
            if (Guard.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.guard)) {
                return type.cast(InternalAbstractGraphDatabase.this.guard);
            }
            if (IndexProviders.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.indexManager)) {
                return type.cast(InternalAbstractGraphDatabase.this.indexManager);
            }
            if (KernelData.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.extensions)) {
                return type.cast(InternalAbstractGraphDatabase.this.extensions);
            }
            if (TransactionInterceptorProviders.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.transactionInterceptorProviders)) {
                return type.cast(InternalAbstractGraphDatabase.this.transactionInterceptorProviders);
            }
            if (KernelExtensions.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.kernelExtensions)) {
                return type.cast(InternalAbstractGraphDatabase.this.kernelExtensions);
            }
            if (NodeManager.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.nodeManager)) {
                return type.cast(InternalAbstractGraphDatabase.this.nodeManager);
            }
            if (TransactionStateFactory.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.stateFactory)) {
                return type.cast(InternalAbstractGraphDatabase.this.stateFactory);
            }
            if (TxIdGenerator.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.txIdGenerator)) {
                return type.cast(InternalAbstractGraphDatabase.this.txIdGenerator);
            }
            if (DiagnosticsManager.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.diagnosticsManager)) {
                return type.cast(InternalAbstractGraphDatabase.this.diagnosticsManager);
            }
            if (RelationshipTypeTokenHolder.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.relationshipTypeTokenHolder)) {
                return type.cast(InternalAbstractGraphDatabase.this.relationshipTypeTokenHolder);
            }
            if (PropertyKeyTokenHolder.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.propertyKeyTokenHolder)) {
                return type.cast(InternalAbstractGraphDatabase.this.propertyKeyTokenHolder);
            }
            if (LabelTokenHolder.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.labelTokenHolder)) {
                return type.cast(InternalAbstractGraphDatabase.this.labelTokenHolder);
            }
            if (KernelPanicEventGenerator.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.kernelPanicEventGenerator);
            }
            if (LifeSupport.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.life);
            }
            if (Monitors.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.monitors);
            }
            if (PersistenceManager.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.persistenceManager)) {
                return type.cast(InternalAbstractGraphDatabase.this.persistenceManager);
            }
            if (ThreadToStatementContextBridge.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.statementContextProvider)) {
                return type.cast(InternalAbstractGraphDatabase.this.statementContextProvider);
            }
            if (CacheAccessBackDoor.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.cacheBridge)) {
                return type.cast(InternalAbstractGraphDatabase.this.cacheBridge);
            }
            if (StoreLockerLifecycleAdapter.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.storeLocker)) {
                return type.cast(InternalAbstractGraphDatabase.this.storeLocker);
            }
            if (IndexManager.class.equals(type) && type.isInstance(InternalAbstractGraphDatabase.this.indexManager)) {
                return type.cast(InternalAbstractGraphDatabase.this.indexManager);
            }
            if (IndexingService.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.neoDataSource.getIndexService())) {
                return type.cast(InternalAbstractGraphDatabase.this.neoDataSource.getIndexService());
            }
            if (JobScheduler.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.jobScheduler)) {
                return type.cast(InternalAbstractGraphDatabase.this.jobScheduler);
            }
            if (LabelScanStore.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.neoDataSource.getLabelScanStore())) {
                return type.cast(InternalAbstractGraphDatabase.this.neoDataSource.getLabelScanStore());
            }
            if (NeoStoreProvider.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.neoDataSource);
            }
            if (IdGeneratorFactory.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.idGeneratorFactory);
            }
            if (Monitors.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.monitors);
            }
            if (RemoteTxHook.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.txHook);
            }
            if (DependencyResolver.class.equals(type)) {
                return type.cast(this);
            }
            if (KernelHealth.class.isAssignableFrom(type)) {
                return (T)InternalAbstractGraphDatabase.this.kernelHealth;
            }
            return null;
        }

        @Override
        public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
            T result = this.resolveKnownSingleDependency(type);
            if (result != null) {
                return selector.select(type, Iterables.option(result));
            }
            return InternalAbstractGraphDatabase.this.kernelExtensions.resolveDependency(type, selector);
        }
    }

    private class DefaultTxEventSyncHookFactory
    implements TxEventSyncHookFactory {
        private DefaultTxEventSyncHookFactory() {
        }

        @Override
        public TransactionEventsSyncHook create() {
            return InternalAbstractGraphDatabase.this.transactionEventHandlers.hasHandlers() ? new TransactionEventsSyncHook(InternalAbstractGraphDatabase.this.transactionEventHandlers, InternalAbstractGraphDatabase.this.txManager) : null;
        }
    }

    protected final class DefaultKernelData
    extends KernelData
    implements Lifecycle {
        private final GraphDatabaseAPI graphDb;

        public DefaultKernelData(Config config, GraphDatabaseAPI graphDb) {
            super(config);
            this.graphDb = graphDb;
        }

        @Override
        public Version version() {
            return Version.getKernel();
        }

        @Override
        public GraphDatabaseAPI graphDatabase() {
            return this.graphDb;
        }

        @Override
        public void init() throws Throwable {
        }

        @Override
        public void start() throws Throwable {
        }

        @Override
        public void stop() throws Throwable {
        }
    }

    public static class Configuration {
        public static final Setting<Boolean> read_only = GraphDatabaseSettings.read_only;
        public static final Setting<Boolean> use_memory_mapped_buffers = GraphDatabaseSettings.use_memory_mapped_buffers;
        public static final Setting<Boolean> execution_guard_enabled = GraphDatabaseSettings.execution_guard_enabled;
        public static final Setting<String> cache_type = GraphDatabaseSettings.cache_type;
        public static final Setting<Boolean> ephemeral = Settings.setting("ephemeral", Settings.BOOLEAN, "false");
        public static final Setting<File> store_dir = GraphDatabaseSettings.store_dir;
        public static final Setting<File> neo_store = GraphDatabaseSettings.neo_store;
        public static final Setting<File> logical_log = GraphDatabaseSettings.logical_log;
    }

    public static interface Dependencies {
        public Logging logging();

        public Iterable<Class<?>> settingsClasses();

        public Iterable<KernelExtensionFactory<?>> kernelExtensions();

        public Iterable<CacheProvider> cacheProviders();

        public Iterable<TransactionInterceptorProvider> transactionInterceptorProviders();
    }
}

