/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.exceptions.TransactionalException;

public class TransactionFailureException
extends TransactionalException {
    private static final int NO_CODE = 0;
    private final int errorCode;

    public TransactionFailureException(HeuristicMixedException cause) {
        super((Exception)((Object)cause));
        this.errorCode = 5;
    }

    public TransactionFailureException(HeuristicRollbackException cause) {
        super((Exception)((Object)cause));
        this.errorCode = 6;
    }

    public TransactionFailureException(RollbackException cause) {
        super((Exception)((Object)cause));
        this.errorCode = 100;
    }

    public TransactionFailureException(SystemException cause) {
        super((Exception)((Object)cause));
        this.errorCode = -3;
    }

    public TransactionFailureException(Exception e) {
        super(e);
        this.errorCode = 0;
    }

    public RuntimeException unBoxedForCommit() throws XAException {
        Throwable cause = this.getCause();
        if (this.errorCode == 0) {
            return cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
        }
        throw Exceptions.withCause(new XAException(this.errorCode), cause);
    }
}

