/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Function;

public final class TimeUtil {
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    public static final Function<String, Long> parseTimeMillis = new Function<String, Long>(){

        public Long apply(String timeWithOrWithoutUnit) {
            TimeUnit timeUnit;
            int unitIndex = -1;
            for (int i = 0; i < timeWithOrWithoutUnit.length(); ++i) {
                char ch = timeWithOrWithoutUnit.charAt(i);
                if (Character.isDigit(ch)) continue;
                unitIndex = i;
                break;
            }
            if (unitIndex == -1) {
                return DEFAULT_TIME_UNIT.toMillis(Integer.parseInt(timeWithOrWithoutUnit));
            }
            int amount = Integer.parseInt(timeWithOrWithoutUnit.substring(0, unitIndex));
            String unit = timeWithOrWithoutUnit.substring(unitIndex).toLowerCase();
            if (unit.equals("ms")) {
                timeUnit = TimeUnit.MILLISECONDS;
            } else if (unit.equals("s")) {
                timeUnit = TimeUnit.SECONDS;
            } else if (unit.equals("m")) {
                timeUnit = TimeUnit.MINUTES;
            } else if (unit.equals("h")) {
                timeUnit = TimeUnit.HOURS;
            } else {
                throw new RuntimeException("Unrecognized unit " + unit);
            }
            return timeUnit.toMillis(amount);
        }
    };

    private TimeUtil() {
    }
}

