/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import org.neo4j.function.Predicate;
import org.neo4j.function.Supplier;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.IdTypeConfiguration;
import org.neo4j.kernel.IdTypeConfigurationProvider;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.store.id.BufferingIdGenerator;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;

public class BufferingIdGeneratorFactory
implements IdGeneratorFactory {
    private final BufferingIdGenerator[] overriddenIdGenerators = new BufferingIdGenerator[IdType.values().length];
    private Supplier<KernelTransactionsSnapshot> boundaries;
    private Predicate<KernelTransactionsSnapshot> safeThreshold;
    private final IdGeneratorFactory delegate;
    private final IdTypeConfigurationProvider idTypeConfigurationProvider;

    public BufferingIdGeneratorFactory(IdGeneratorFactory delegate, IdTypeConfigurationProvider idTypeConfigurationProvider) {
        this.delegate = delegate;
        this.idTypeConfigurationProvider = idTypeConfigurationProvider;
    }

    public void initialize(Supplier<KernelTransactionsSnapshot> boundaries, final IdReuseEligibility eligibleForReuse) {
        this.boundaries = boundaries;
        this.safeThreshold = new Predicate<KernelTransactionsSnapshot>(){

            public boolean test(KernelTransactionsSnapshot snapshot) {
                return snapshot.allClosed() && eligibleForReuse.isEligible(snapshot);
            }
        };
        for (BufferingIdGenerator generator : this.overriddenIdGenerators) {
            if (generator == null) continue;
            generator.initialize(boundaries, this.safeThreshold);
        }
    }

    @Override
    public IdGenerator open(File filename, IdType idType, long highId) {
        IdTypeConfiguration typeConfiguration = this.idTypeConfigurationProvider.getIdTypeConfiguration(idType);
        return this.open(filename, typeConfiguration.getGrabSize(), idType, highId);
    }

    @Override
    public IdGenerator open(File filename, int grabSize, IdType idType, long highId) {
        IdGenerator generator = this.delegate.open(filename, grabSize, idType, highId);
        IdTypeConfiguration typeConfiguration = this.getIdTypeConfiguration(idType);
        if (typeConfiguration.allowAggressiveReuse()) {
            BufferingIdGenerator bufferingGenerator = new BufferingIdGenerator(generator);
            if (this.boundaries != null) {
                bufferingGenerator.initialize(this.boundaries, this.safeThreshold);
            }
            this.overriddenIdGenerators[idType.ordinal()] = bufferingGenerator;
            generator = bufferingGenerator;
        }
        return generator;
    }

    @Override
    public void create(File filename, long highId, boolean throwIfFileExists) {
        this.delegate.create(filename, highId, throwIfFileExists);
    }

    private IdTypeConfiguration getIdTypeConfiguration(IdType idType) {
        return this.idTypeConfigurationProvider.getIdTypeConfiguration(idType);
    }

    @Override
    public IdGenerator get(IdType idType) {
        BufferingIdGenerator generator = this.overriddenIdGenerators[idType.ordinal()];
        return generator != null ? generator : this.delegate.get(idType);
    }

    public void maintenance() {
        for (BufferingIdGenerator generator : this.overriddenIdGenerators) {
            if (generator == null) continue;
            generator.maintenance();
        }
    }

    public void clear() {
        for (BufferingIdGenerator generator : this.overriddenIdGenerators) {
            if (generator == null) continue;
            generator.clear();
        }
    }
}

