/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.bitmaps;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.kernel.impl.util.PrimitiveLongIterator;

public class LongPageIterator
implements PrimitiveLongIterator {
    private final Iterator<long[]> source;
    private long[] current;
    private int offset;

    public LongPageIterator(Iterator<long[]> source) {
        this.source = source;
    }

    public boolean hasNext() {
        while (this.current == null || this.offset >= this.current.length) {
            if (!this.source.hasNext()) {
                this.current = null;
                return false;
            }
            this.current = this.source.next();
            this.offset = 0;
        }
        return true;
    }

    public long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.current[this.offset++];
    }
}

