/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.driver;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class TypeAdapterLookupDelegate {
    private final Map<Class<?>, Function<Object, Object>> cachedAdapters = new ConcurrentHashMap();
    private final Map<Class<?>, Function> registeredTypeAdapter;

    public TypeAdapterLookupDelegate(Map<Class<?>, Function> registeredTypeAdapter) {
        this.registeredTypeAdapter = Collections.unmodifiableMap(registeredTypeAdapter);
    }

    public Function<Object, Object> getAdapterFor(Class<?> clazz) {
        return this.findAdapterFor(clazz);
    }

    public boolean hasAdapterFor(Class<?> clazz) {
        return this.registeredTypeAdapter.containsKey(clazz) || this.registeredTypeAdapter.keySet().stream().anyMatch(c -> c.isAssignableFrom(clazz));
    }

    private Function<Object, Object> findAdapterFor(Class<?> clazz) {
        return this.cachedAdapters.computeIfAbsent(clazz, c -> {
            Function f = c == null ? Function.identity() : (this.registeredTypeAdapter.containsKey(c) ? this.registeredTypeAdapter.get(c) : this.registeredTypeAdapter.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom((Class<?>)c)).findFirst().map(Map.Entry::getValue).orElseGet(Function::identity));
            return o -> o == null ? null : f.apply(o);
        });
    }
}

