/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.compiler.CompileContext;
import org.neo4j.ogm.compiler.Compiler;
import org.neo4j.ogm.compiler.NodeBuilder;
import org.neo4j.ogm.context.Mappable;

public class CypherContext
implements CompileContext {
    private final Map<Long, NodeBuilder> visitedObjects = new HashMap<Long, NodeBuilder>();
    private final Set<Long> visitedRelationshipEntities = new HashSet<Long>();
    private final Map<Long, Object> createdObjectsWithId = new HashMap<Long, Object>();
    private final Collection<Mappable> registeredRelationships = new HashSet<Mappable>();
    private final Collection<Mappable> deletedRelationships = new HashSet<Mappable>();
    private final Map<Long, Long> newNodeIds = new HashMap<Long, Long>();
    private final Collection<Object> log = new HashSet<Object>();
    private final Compiler compiler;

    public CypherContext(Compiler compiler) {
        this.compiler = compiler;
    }

    public boolean visited(Long obj) {
        return this.visitedObjects.containsKey(obj);
    }

    public void visit(Long identity, NodeBuilder nodeBuilder) {
        this.visitedObjects.put(identity, nodeBuilder);
    }

    public void registerRelationship(Mappable mappedRelationship) {
        this.registeredRelationships.add(mappedRelationship);
    }

    public boolean removeRegisteredRelationship(Mappable mappedRelationship) {
        return this.registeredRelationships.remove(mappedRelationship);
    }

    public NodeBuilder visitedNode(Long identity) {
        return this.visitedObjects.get(identity);
    }

    public void registerNewObject(Long reference, Object relationshipEntity) {
        this.createdObjectsWithId.put(reference, relationshipEntity);
    }

    public Object getNewObject(Long id) {
        return this.createdObjectsWithId.get(id);
    }

    public void register(Object object) {
        this.log.add(object);
    }

    public Collection<Object> registry() {
        return this.log;
    }

    public boolean deregisterOutgoingRelationships(Long src, String relationshipType, Class endNodeType) {
        Mappable mappedRelationship;
        Iterator<Object> iterator = this.registeredRelationships.iterator();
        boolean nothingToDelete = true;
        ArrayList<Mappable> cleared = new ArrayList<Mappable>();
        while (iterator.hasNext()) {
            mappedRelationship = iterator.next();
            if (mappedRelationship.getStartNodeId() != src.longValue() || !mappedRelationship.getRelationshipType().equals(relationshipType) || !endNodeType.equals(mappedRelationship.getEndNodeType())) continue;
            cleared.add(mappedRelationship);
            iterator.remove();
            nothingToDelete = false;
        }
        if (nothingToDelete) {
            return true;
        }
        iterator = cleared.iterator();
        while (iterator.hasNext()) {
            mappedRelationship = (Mappable)iterator.next();
            if (this.isMappableAlreadyDeleted(mappedRelationship)) {
                this.registerRelationship(mappedRelationship);
                iterator.remove();
                continue;
            }
            this.deletedRelationships.add(mappedRelationship);
        }
        return cleared.size() > 0;
    }

    public boolean deregisterIncomingRelationships(Long tgt, String relationshipType, Class endNodeType, boolean relationshipEntity) {
        Mappable mappedRelationship;
        Iterator<Object> iterator = this.registeredRelationships.iterator();
        ArrayList<Mappable> cleared = new ArrayList<Mappable>();
        boolean nothingToDelete = true;
        while (iterator.hasNext()) {
            mappedRelationship = iterator.next();
            if (mappedRelationship.getEndNodeId() != tgt.longValue() || !mappedRelationship.getRelationshipType().equals(relationshipType) || !endNodeType.equals(relationshipEntity ? mappedRelationship.getEndNodeType() : mappedRelationship.getStartNodeType())) continue;
            cleared.add(mappedRelationship);
            iterator.remove();
            nothingToDelete = false;
        }
        if (nothingToDelete) {
            return true;
        }
        iterator = cleared.iterator();
        while (iterator.hasNext()) {
            mappedRelationship = (Mappable)iterator.next();
            if (this.isMappableAlreadyDeleted(mappedRelationship)) {
                this.registerRelationship(mappedRelationship);
                iterator.remove();
                continue;
            }
            this.deletedRelationships.add(mappedRelationship);
        }
        return cleared.size() > 0;
    }

    public void visitRelationshipEntity(Long relationshipEntity) {
        this.visitedRelationshipEntities.add(relationshipEntity);
    }

    public boolean visitedRelationshipEntity(Long relationshipEntity) {
        return this.visitedRelationshipEntities.contains(relationshipEntity);
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public Long newNodeId(Long reference) {
        if (this.newNodeIds.containsKey(reference)) {
            return this.newNodeIds.get(reference);
        }
        return reference;
    }

    public void registerNewNodeId(Long reference, Long id) {
        this.newNodeIds.put(reference, id);
    }

    public void deregister(NodeBuilder nodeBuilder) {
        this.compiler.unmap(nodeBuilder);
    }

    private boolean isMappableAlreadyDeleted(Mappable mappedRelationship) {
        for (Mappable deletedRelationship : this.deletedRelationships) {
            if (deletedRelationship.getEndNodeId() != mappedRelationship.getEndNodeId() || deletedRelationship.getStartNodeId() != mappedRelationship.getStartNodeId() || !deletedRelationship.getRelationshipType().equals(mappedRelationship.getRelationshipType())) continue;
            return true;
        }
        return false;
    }
}

