/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.compiler.emitters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.compiler.CypherEmitter;
import org.neo4j.ogm.model.Edge;

public class DeletedRelationshipEntityEmitter
implements CypherEmitter {
    private Set<Edge> deletedEdges;

    public DeletedRelationshipEntityEmitter(Set<Edge> deletedEdges) {
        this.deletedEdges = deletedEdges;
    }

    public void emit(StringBuilder queryBuilder, Map<String, Object> parameters) {
        if (this.deletedEdges != null && this.deletedEdges.size() > 0) {
            queryBuilder.append("START r=rel({relIds}) DELETE r");
            ArrayList<Long> relIds = new ArrayList<Long>(this.deletedEdges.size());
            ArrayList rows = new ArrayList();
            for (Edge edge : this.deletedEdges) {
                HashMap<String, Long> rowMap = new HashMap<String, Long>();
                rowMap.put("relId", edge.getId());
                rows.add(rowMap);
                relIds.add(edge.getId());
            }
            parameters.put("rows", rows);
            parameters.put("relIds", relIds);
        }
    }
}

