/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.ogm.context.IdentityMap;
import org.neo4j.ogm.context.LabelHistory;
import org.neo4j.ogm.context.LabelPrimaryId;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.id.IdStrategy;
import org.neo4j.ogm.id.InternalIdStrategy;
import org.neo4j.ogm.id.UuidStrategy;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.utils.EntityUtils;

public class MappingContext {
    private final Map<Long, Object> nodeEntityRegister;
    private final Map<LabelPrimaryId, Object> primaryIndexNodeRegister;
    private final Map<LabelPrimaryId, Long> primaryIdToNativeId;
    private final Map<Long, Object> relationshipEntityRegister;
    private final Map<LabelPrimaryId, Object> primaryIdToRelationship;
    private final Set<MappedRelationship> relationshipRegister;
    private final IdentityMap identityMap;
    private final MetaData metaData;

    public MappingContext(MetaData metaData) {
        this.metaData = metaData;
        this.identityMap = new IdentityMap(metaData);
        this.nodeEntityRegister = new HashMap<Long, Object>();
        this.primaryIndexNodeRegister = new HashMap<LabelPrimaryId, Object>();
        this.primaryIdToNativeId = new HashMap<LabelPrimaryId, Long>();
        this.relationshipEntityRegister = new HashMap<Long, Object>();
        this.primaryIdToRelationship = new HashMap<LabelPrimaryId, Object>();
        this.relationshipRegister = new HashSet<MappedRelationship>();
    }

    public Object getNodeEntity(Long graphId) {
        return this.nodeEntityRegister.get(graphId);
    }

    public Object getNodeEntityById(ClassInfo classInfo, Object id) {
        return this.primaryIndexNodeRegister.get(new LabelPrimaryId(classInfo, id));
    }

    public Object addNodeEntity(Object entity) {
        return this.addNodeEntity(entity, this.nativeId(entity));
    }

    public Object addNodeEntity(Object entity, Long id) {
        ClassInfo classInfo = this.metaData.classInfo(entity);
        if (this.nodeEntityRegister.putIfAbsent(id, entity) == null) {
            Object primaryIndexValue;
            this.remember(entity);
            FieldInfo primaryIndexField = classInfo.primaryIndexField();
            if (primaryIndexField != null && (primaryIndexValue = primaryIndexField.read(entity)) != null) {
                LabelPrimaryId key = new LabelPrimaryId(classInfo, primaryIndexValue);
                this.primaryIndexNodeRegister.putIfAbsent(key, entity);
                this.primaryIdToNativeId.put(key, id);
            }
        }
        return entity;
    }

    boolean removeRelationship(MappedRelationship mappedRelationship) {
        return this.relationshipRegister.remove(mappedRelationship);
    }

    void removeNodeEntity(Object entity, boolean deregisterDependentRelationshipEntity) {
        Object primaryIndexValue;
        Long id = this.nativeId(entity);
        this.nodeEntityRegister.remove(id);
        ClassInfo primaryIndexClassInfo = this.metaData.classInfo(entity);
        FieldInfo primaryIndexField = primaryIndexClassInfo.primaryIndexField();
        if (primaryIndexField != null && (primaryIndexValue = primaryIndexField.read(entity)) != null) {
            this.primaryIndexNodeRegister.remove(new LabelPrimaryId(primaryIndexClassInfo, primaryIndexValue));
        }
        if (deregisterDependentRelationshipEntity) {
            this.deregisterDependentRelationshipEntity(entity);
        }
    }

    public void replaceNodeEntity(Object entity, Long identity) {
        this.removeNodeEntity(entity, false);
        ClassInfo classInfo = this.metaData.classInfo(entity);
        if (classInfo.hasPrimaryIndexField()) {
            LabelPrimaryId key = new LabelPrimaryId(classInfo, classInfo.primaryIndexField().readProperty(entity));
            this.primaryIdToNativeId.put(key, identity);
        }
        this.addNodeEntity(entity, identity);
        this.deregisterDependentRelationshipEntity(entity);
    }

    public void replaceRelationshipEntity(Object entity, Long id) {
        this.relationshipEntityRegister.remove(id);
        ClassInfo classInfo = this.metaData.classInfo(entity);
        FieldInfo primaryIndexField = classInfo.primaryIndexField();
        if (primaryIndexField != null) {
            Object primaryId = primaryIndexField.read(entity);
            LabelPrimaryId labelPrimaryId = new LabelPrimaryId(classInfo, primaryId);
            this.primaryIdToRelationship.remove(labelPrimaryId);
            this.primaryIdToNativeId.remove(labelPrimaryId);
        }
        this.addRelationshipEntity(entity, id);
    }

    Collection<Object> getEntities(Class<?> type) {
        Collection result = this.metaData.isRelationshipEntity(type.getName()) ? (Collection)this.relationshipEntityRegister.values().stream().filter(c -> c.getClass().isAssignableFrom(type)).collect(Collectors.toList()) : (Collection)this.nodeEntityRegister.values().stream().filter(c -> c.getClass().isAssignableFrom(type)).collect(Collectors.toList());
        return result;
    }

    LabelHistory labelHistory(Object entity) {
        return this.identityMap.labelHistory(entity, this.nativeId(entity));
    }

    public boolean isDirty(Object entity) {
        Long graphId = this.nativeId(entity);
        return !this.identityMap.remembered(entity, graphId);
    }

    public boolean containsRelationship(MappedRelationship relationship) {
        return this.relationshipRegister.contains(relationship);
    }

    public Set<MappedRelationship> getRelationships() {
        return this.relationshipRegister;
    }

    public void addRelationship(MappedRelationship relationship) {
        if (relationship.getRelationshipId() != null && this.relationshipEntityRegister.get(relationship.getRelationshipId()) == null) {
            relationship.setRelationshipId(null);
        }
        this.relationshipRegister.add(relationship);
    }

    public void clear() {
        this.identityMap.clear();
        this.relationshipRegister.clear();
        this.primaryIdToRelationship.clear();
        this.nodeEntityRegister.clear();
        this.primaryIndexNodeRegister.clear();
        this.relationshipEntityRegister.clear();
    }

    public Object getRelationshipEntity(Long relationshipId) {
        return this.relationshipEntityRegister.get(relationshipId);
    }

    public Object getRelationshipEntityById(ClassInfo classInfo, Object id) {
        return this.primaryIdToRelationship.get(new LabelPrimaryId(classInfo, id));
    }

    public Object addRelationshipEntity(Object relationshipEntity, Long id) {
        if (this.relationshipEntityRegister.putIfAbsent(id, relationshipEntity) == null) {
            relationshipEntity = this.relationshipEntityRegister.get(id);
            this.remember(relationshipEntity);
            ClassInfo classInfo = this.metaData.classInfo(relationshipEntity);
            FieldInfo primaryIdField = classInfo.primaryIndexField();
            if (primaryIdField != null) {
                Object primaryId = primaryIdField.read(relationshipEntity);
                this.primaryIdToRelationship.put(new LabelPrimaryId(classInfo, primaryId), relationshipEntity);
                this.primaryIdToNativeId.put(new LabelPrimaryId(classInfo, primaryId), id);
            }
        }
        return relationshipEntity;
    }

    public void removeType(Class<?> type) {
        ClassInfo classInfo = this.metaData.classInfo(type.getName());
        if (classInfo.isInterface()) {
            List<ClassInfo> implementingClasses = this.metaData.getImplementingClassInfos(classInfo.name());
            for (ClassInfo implementingClass : implementingClasses) {
                try {
                    this.removeType(classInfo.getUnderlyingClass());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            for (Object entity : this.getEntities(type)) {
                this.purge(entity, type);
            }
        }
    }

    public boolean detachNodeEntity(Long id) {
        Object objectToDetach = this.getNodeEntity(id);
        if (objectToDetach != null) {
            this.removeEntity(objectToDetach);
            return true;
        }
        return false;
    }

    public boolean detachRelationshipEntity(Long id) {
        Object objectToDetach = this.relationshipEntityRegister.get(id);
        if (objectToDetach != null) {
            this.removeEntity(objectToDetach);
            return true;
        }
        return false;
    }

    void removeEntity(Object entity) {
        Class<?> type = entity.getClass();
        this.purge(entity, type);
    }

    public void reset(Object entity) {
        this.removeEntity(entity);
        EntityUtils.setIdentity(entity, null, this.metaData);
    }

    public Set<Object> neighbours(Object entity) {
        HashSet<Object> neighbours = new HashSet<Object>();
        Class<?> type = entity.getClass();
        Long id = this.nativeId(entity);
        if (id >= 0L) {
            if (!this.metaData.isRelationshipEntity(type.getName())) {
                if (this.getNodeEntity(id) != null) {
                    for (MappedRelationship mappedRelationship : this.relationshipRegister) {
                        Object affectedObject;
                        if (mappedRelationship.getStartNodeId() != id.longValue() && mappedRelationship.getEndNodeId() != id.longValue() || (affectedObject = mappedRelationship.getEndNodeId() == id.longValue() ? this.getNodeEntity(mappedRelationship.getStartNodeId()) : this.getNodeEntity(mappedRelationship.getEndNodeId())) == null) continue;
                        neighbours.add(affectedObject);
                    }
                }
            } else if (this.relationshipEntityRegister.containsKey(id)) {
                ClassInfo classInfo = this.metaData.classInfo(type.getName());
                FieldInfo startNodeReader = classInfo.getStartNodeReader();
                FieldInfo endNodeReader = classInfo.getEndNodeReader();
                neighbours.add(startNodeReader.read(entity));
                neighbours.add(endNodeReader.read(entity));
            }
        }
        return neighbours;
    }

    private void deregisterDependentRelationshipEntity(Object startOrEndEntity) {
        Iterator<Long> relationshipEntityIdIterator = this.relationshipEntityRegister.keySet().iterator();
        while (relationshipEntityIdIterator.hasNext()) {
            Long relationshipEntityId = relationshipEntityIdIterator.next();
            Object relationshipEntity = this.relationshipEntityRegister.get(relationshipEntityId);
            ClassInfo classInfo = this.metaData.classInfo(relationshipEntity);
            FieldInfo startNodeReader = classInfo.getStartNodeReader();
            FieldInfo endNodeReader = classInfo.getEndNodeReader();
            if (startOrEndEntity != startNodeReader.read(relationshipEntity) && startOrEndEntity != endNodeReader.read(relationshipEntity)) continue;
            relationshipEntityIdIterator.remove();
        }
    }

    private void purge(Object entity, Class type) {
        Long id = this.nativeId(entity);
        HashSet<Object> relEntitiesToPurge = new HashSet<Object>();
        if (id >= 0L) {
            if (!this.metaData.isRelationshipEntity(type.getName())) {
                if (this.getNodeEntity(id) != null) {
                    this.removeNodeEntity(entity, false);
                    Iterator<MappedRelationship> mappedRelationshipIterator = this.relationshipRegister.iterator();
                    while (mappedRelationshipIterator.hasNext()) {
                        Object relEntity;
                        MappedRelationship mappedRelationship = mappedRelationshipIterator.next();
                        if (mappedRelationship.getStartNodeId() != id.longValue() && mappedRelationship.getEndNodeId() != id.longValue()) continue;
                        if (mappedRelationship.getRelationshipId() != null && (relEntity = this.relationshipEntityRegister.get(mappedRelationship.getRelationshipId())) != null) {
                            relEntitiesToPurge.add(relEntity);
                        }
                        mappedRelationshipIterator.remove();
                    }
                }
            } else if (this.relationshipEntityRegister.containsKey(id)) {
                this.relationshipEntityRegister.remove(id);
                ClassInfo classInfo = this.metaData.classInfo(entity);
                FieldInfo fieldInfo = classInfo.getStartNodeReader();
                Object startNode = fieldInfo.read(entity);
                this.removeEntity(startNode);
                FieldInfo endNodeReader = classInfo.getEndNodeReader();
                Object endNode = endNodeReader.read(entity);
                this.removeEntity(endNode);
            }
            for (Object e : relEntitiesToPurge) {
                ClassInfo relClassInfo = this.metaData.classInfo(e);
                this.purge(e, relClassInfo.getUnderlyingClass());
            }
        }
    }

    private void remember(Object entity) {
        this.identityMap.remember(entity, this.nativeId(entity));
    }

    public Long nativeId(Object entity) {
        ClassInfo classInfo = this.metaData.classInfo(entity);
        if (classInfo == null) {
            throw new IllegalArgumentException("Class " + entity.getClass() + " is not a valid entity class. Please check the entity mapping.");
        }
        this.generateIdIfNecessary(entity, classInfo);
        if (classInfo.hasIdentityField()) {
            return EntityUtils.identity(entity, this.metaData);
        }
        FieldInfo fieldInfo = classInfo.primaryIndexField();
        Object primaryId = fieldInfo.readProperty(entity);
        if (primaryId == null) {
            throw new MappingException("Field with primary id is null for entity " + entity);
        }
        LabelPrimaryId key = new LabelPrimaryId(classInfo, primaryId);
        Long graphId = this.primaryIdToNativeId.get(key);
        if (graphId == null) {
            graphId = EntityUtils.nextRef();
            this.primaryIdToNativeId.put(key, graphId);
        }
        return graphId;
    }

    private void generateIdIfNecessary(Object entity, ClassInfo classInfo) {
        if (classInfo.idStrategyClass() == null || InternalIdStrategy.class.equals(classInfo.idStrategyClass())) {
            return;
        }
        if (classInfo.idStrategy() == null) {
            throw new MappingException("Id strategy " + classInfo.idStrategyClass() + " could not be instantiated and wasn't registered. Either provide no argument constructor or register instance with SessionFactory");
        }
        FieldInfo primaryIndexField = classInfo.primaryIndexField();
        Object existingUuid = primaryIndexField.read(entity);
        if (existingUuid == null) {
            IdStrategy strategy = classInfo.idStrategy();
            Object id = strategy.generateId(entity);
            if (strategy instanceof UuidStrategy && primaryIndexField.isTypeOf(String.class)) {
                id = id.toString();
            }
            primaryIndexField.writeDirect(entity, id);
        }
    }
}

