/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher;

import org.neo4j.ogm.cypher.CaseInsensitiveLikePropertyValueTransformer;
import org.neo4j.ogm.cypher.NoOpPropertyValueTransformer;
import org.neo4j.ogm.cypher.PropertyValueTransformer;

public enum ComparisonOperator {
    EQUALS("="),
    MATCHES("=~"),
    LIKE("=~", new CaseInsensitiveLikePropertyValueTransformer()),
    GREATER_THAN(">"),
    GREATER_THAN_EQUAL(">="),
    LESS_THAN("<"),
    LESS_THAN_EQUAL("<="),
    IS_NULL("IS NULL"),
    STARTING_WITH("STARTS WITH"),
    ENDING_WITH("ENDS WITH"),
    CONTAINING("CONTAINS"),
    IN("IN"),
    EXISTS("EXISTS"),
    IS_TRUE("=");

    private final String value;
    private final PropertyValueTransformer valueTransformer;

    private ComparisonOperator(String value) {
        this(value, new NoOpPropertyValueTransformer());
    }

    private ComparisonOperator(String value, PropertyValueTransformer propertyValueTransformer) {
        this.value = value;
        this.valueTransformer = propertyValueTransformer;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isOneOf(ComparisonOperator ... these) {
        for (ComparisonOperator candidate : these) {
            if (!this.equals((Object)candidate)) continue;
            return true;
        }
        return false;
    }

    public PropertyValueTransformer getPropertyValueTransformer() {
        return this.valueTransformer;
    }
}

