/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.context.MappingSupport;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.reflect.ReflectionEntityInstantiator;
import org.neo4j.ogm.session.Neo4jSession;

public class DtoMapper {
    public static final Set<String> classes = new HashSet<String>();
    private final Neo4jSession session;
    private final ReflectionEntityInstantiator instantiator;

    public DtoMapper(Neo4jSession session) {
        this.session = session;
        this.instantiator = new ReflectionEntityInstantiator(session.metaData());
    }

    public <T> T newInstance(Class<T> type, Map<String, Object> properties) {
        T object = this.instantiator.createInstanceWithConstructorArgs(type, properties);
        this.setProperties(properties, object);
        return object;
    }

    private void setProperties(Map<String, Object> properties, Object instance) {
        ClassInfo classInfo = this.session.metaData().classInfo(instance);
        properties.forEach((s, o) -> MappingSupport.writeProperty(classInfo, instance, s, o));
    }
}

